/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Chunk;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class CoordSpanInputSteam
extends InputStream {
    private SeekableStream delegate;
    private Iterator<Chunk> it;
    private Chunk current;
    private boolean eof = false;

    public CoordSpanInputSteam(SeekableStream seekableStream, long[] lArray) throws IOException {
        this.delegate = seekableStream;
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        for (int i = 0; i < lArray.length; i += 2) {
            if (lArray[i] > seekableStream.length()) {
                throw new RuntimeException("Chunk start is passed EOF: " + lArray[i]);
            }
            Chunk chunk = new Chunk(lArray[i], lArray[i + 1] > seekableStream.length() ? seekableStream.length() : lArray[i + 1]);
            arrayList.add(chunk);
            System.err.printf("Adding chunk: %d - %d\n", chunk.getChunkStart(), chunk.getChunkEnd());
        }
        this.it = arrayList.iterator();
        this.nextChunk();
    }

    private void nextChunk() throws IOException {
        if (this.eof || !this.it.hasNext()) {
            this.eof = true;
            return;
        }
        this.current = this.it.next();
        this.delegate.seek(this.current.getChunkStart());
    }

    @Override
    public int read() throws IOException {
        if (this.eof || this.delegate.eof()) {
            this.eof = true;
            return -1;
        }
        if (this.delegate.position() < this.current.getChunkEnd()) {
            return this.delegate.read();
        }
        this.nextChunk();
        if (this.eof) {
            return -1;
        }
        return this.delegate.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.eof || this.delegate.eof()) {
            this.eof = true;
            return -1;
        }
        int n3 = this.available();
        if (n3 > n2) {
            return this.delegate.read(byArray, n, n2);
        }
        int n4 = this.delegate.read(byArray, n, n3);
        if (this.delegate.position() >= this.current.getChunkEnd()) {
            this.nextChunk();
        }
        return n4;
    }

    @Override
    public int available() throws IOException {
        return (int)(this.current.getChunkEnd() - this.delegate.position());
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
        this.it = null;
    }
}

