/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLoggerInterface;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class ProgressLogger
implements ProgressLoggerInterface {
    private final Log log;
    private final int n;
    private final String verb;
    private final String noun;
    private final long startTime = System.currentTimeMillis();
    private final NumberFormat fmt = new DecimalFormat("#,###");
    private final NumberFormat timeFmt = new DecimalFormat("00");
    private long processed = 0L;
    private long lastStartTime = -1L;

    public ProgressLogger(Log log, int n, String string, String string2) {
        this.log = log;
        this.n = n;
        this.verb = string;
        this.noun = string2;
    }

    public ProgressLogger(Log log, int n, String string) {
        this(log, n, string, "records");
    }

    public ProgressLogger(Log log, int n) {
        this(log, n, "Processed");
    }

    public ProgressLogger(Log log) {
        this(log, 1000000);
    }

    @Override
    public synchronized boolean record(String string, int n) {
        if (this.lastStartTime == -1L) {
            this.lastStartTime = System.currentTimeMillis();
        }
        if (++this.processed % (long)this.n == 0L) {
            long l = System.currentTimeMillis();
            long l2 = (l - this.lastStartTime) / 1000L;
            this.lastStartTime = l;
            long l3 = (System.currentTimeMillis() - this.startTime) / 1000L;
            String string2 = this.formatElapseTime(l3);
            String string3 = this.pad(this.fmt.format(l2), 4);
            String string4 = this.pad(this.fmt.format(this.processed), 13);
            String string5 = string == null ? "*/*" : string + ":" + this.fmt.format(n);
            this.log.info(this.verb, " ", string4, " " + this.noun + ".  Elapsed time: ", string2, "s.  Time for last ", this.fmt.format(this.n), ": ", string3, "s.  Last read position: ", string5);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean record(SAMRecord sAMRecord) {
        if (sAMRecord.getReferenceIndex() == -1) {
            return this.record(null, 0);
        }
        return this.record(sAMRecord.getReferenceName(), sAMRecord.getAlignmentStart());
    }

    @Override
    public boolean record(SAMRecord ... sAMRecordArray) {
        boolean bl = false;
        for (SAMRecord sAMRecord : sAMRecordArray) {
            bl = this.record(sAMRecord) || bl;
        }
        return bl;
    }

    public long getCount() {
        return this.processed;
    }

    public long getElapsedSeconds() {
        return (System.currentTimeMillis() - this.startTime) / 1000L;
    }

    private String pad(String string, int n) {
        while (string.length() < n) {
            string = " " + string;
        }
        return string;
    }

    private String formatElapseTime(long l) {
        long l2 = l % 60L;
        long l3 = l / 60L;
        long l4 = l3 % 60L;
        long l5 = l3 / 60L;
        return this.timeFmt.format(l5) + ":" + this.timeFmt.format(l4) + ":" + this.timeFmt.format(l2);
    }
}

