/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import hbparquet.hadoop.util.ContextUtil;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.seqdoop.hadoop_bam.KeyIgnoringBCFRecordWriter;
import org.seqdoop.hadoop_bam.KeyIgnoringVCFRecordWriter;
import org.seqdoop.hadoop_bam.VCFFormat;
import org.seqdoop.hadoop_bam.VCFOutputFormat;
import org.seqdoop.hadoop_bam.VariantContextWritable;
import org.seqdoop.hadoop_bam.util.VCFHeaderReader;
import org.seqdoop.hadoop_bam.util.WrapSeekable;

public class KeyIgnoringVCFOutputFormat<K>
extends VCFOutputFormat<K> {
    protected VCFHeader header;
    public static final String WRITE_HEADER_PROPERTY = "hadoopbam.vcf.write-header";

    public KeyIgnoringVCFOutputFormat(VCFFormat fmt) {
        super(fmt);
    }

    public KeyIgnoringVCFOutputFormat(Configuration conf) {
        super(conf);
        if (this.format == null) {
            throw new IllegalArgumentException("unknown VCF format: OUTPUT_VCF_FORMAT_PROPERTY not set");
        }
    }

    public KeyIgnoringVCFOutputFormat(Configuration conf, Path path) {
        super(conf);
        if (this.format == null) {
            this.format = VCFFormat.inferFromFilePath(path);
            if (this.format == null) {
                throw new IllegalArgumentException("unknown VCF format: " + path);
            }
        }
    }

    public VCFHeader getHeader() {
        return this.header;
    }

    public void setHeader(VCFHeader header) {
        this.header = header;
    }

    public void readHeaderFrom(Path path, FileSystem fs) throws IOException {
        WrapSeekable<FSDataInputStream> i = WrapSeekable.openPath(fs, path);
        this.readHeaderFrom(i);
        i.close();
    }

    public void readHeaderFrom(SeekableStream in) throws IOException {
        this.header = VCFHeaderReader.readHeaderFrom(in);
    }

    public RecordWriter<K, VariantContextWritable> getRecordWriter(TaskAttemptContext ctx) throws IOException {
        return this.getRecordWriter(ctx, this.getDefaultWorkFile(ctx, ""));
    }

    public RecordWriter<K, VariantContextWritable> getRecordWriter(TaskAttemptContext ctx, Path out) throws IOException {
        if (this.header == null) {
            throw new IOException("Can't create a RecordWriter without the VCF header");
        }
        boolean wh = ContextUtil.getConfiguration((JobContext)ctx).getBoolean(WRITE_HEADER_PROPERTY, true);
        switch (this.format) {
            case BCF: {
                return new KeyIgnoringBCFRecordWriter(out, this.header, wh, ctx);
            }
            case VCF: {
                return new KeyIgnoringVCFRecordWriter(out, this.header, wh, ctx);
            }
        }
        assert (false);
        return null;
    }
}

