/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.bdgenomics.formats.avro.GenotypeAllele;
import org.bdgenomics.formats.avro.Variant;
import org.bdgenomics.formats.avro.VariantCallingAnnotations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AvroGenerated
public class Genotype
extends SpecificRecordBase
implements SpecificRecord {
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Genotype\",\"namespace\":\"org.bdgenomics.formats.avro\",\"fields\":[{\"name\":\"variant\",\"type\":{\"type\":\"record\",\"name\":\"Variant\",\"fields\":[{\"name\":\"contig\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Contig\",\"doc\":\"Record for describing a reference assembly. Not used for storing the contents\\n of said assembly.\\n\\n @see NucleotideContigFragment\",\"fields\":[{\"name\":\"contigName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of this contig in the assembly (e.g., \\\"chr1\\\").\",\"default\":null},{\"name\":\"contigLength\",\"type\":[\"null\",\"long\"],\"doc\":\"The length of this contig.\",\"default\":null},{\"name\":\"contigMD5\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The MD5 checksum of the assembly for this contig.\",\"default\":null},{\"name\":\"referenceURL\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The URL at which this reference assembly can be found.\",\"default\":null},{\"name\":\"assembly\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of this assembly (e.g., \\\"hg19\\\").\",\"default\":null},{\"name\":\"species\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The species that this assembly is for.\",\"default\":null}]}],\"doc\":\"The reference contig that this variant exists on.\",\"default\":null},{\"name\":\"start\",\"type\":[\"null\",\"long\"],\"doc\":\"The 0-based start position of this variant on the reference contig.\",\"default\":null},{\"name\":\"end\",\"type\":[\"null\",\"long\"],\"doc\":\"The 0-based, exclusive end position of this variant on the reference contig.\",\"default\":null},{\"name\":\"referenceAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A string describing the reference allele at this site.\",\"default\":null},{\"name\":\"alternateAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A string describing the variant allele at this site. Should be left null if\\n   the site is a structural variant.\",\"default\":null},{\"name\":\"svAllele\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"StructuralVariant\",\"fields\":[{\"name\":\"type\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"StructuralVariantType\",\"doc\":\"Descriptors for the type of a structural variant. The most specific descriptor\\n should be used, if possible. E.g., duplication should be used instead of\\n insertion if the inserted sequence is not novel. Tandem duplication should\\n be used instead of duplication if the duplication is known to follow the\\n duplicated sequence.\",\"symbols\":[\"DELETION\",\"INSERTION\",\"INVERSION\",\"MOBILE_INSERTION\",\"MOBILE_DELETION\",\"DUPLICATION\",\"TANDEM_DUPLICATION\"]}],\"doc\":\"The type of this structural variant.\",\"default\":null},{\"name\":\"assembly\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The URL of the FASTA/NucleotideContig assembly for this structural variant,\\n   if one is available.\",\"default\":null},{\"name\":\"precise\",\"type\":[\"boolean\",\"null\"],\"doc\":\"Whether this structural variant call has precise breakpoints or not. Default\\n   value is true. If the call is imprecise, confidence intervals should be provided.\",\"default\":true},{\"name\":\"startWindow\",\"type\":[\"null\",\"int\"],\"doc\":\"The size of the confidence window around the start of the structural variant.\",\"default\":null},{\"name\":\"endWindow\",\"type\":[\"null\",\"int\"],\"doc\":\"The size of the confidence window around the end of the structural variant.\",\"default\":null}]}],\"doc\":\"The structural variant at this site, if the alternate allele is a structural\\n   variant. If the site is not a structural variant, this field should be left \\n   null.\",\"default\":null}]},\"doc\":\"The variant called at this site.\"},{\"name\":\"variantCallingAnnotations\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"VariantCallingAnnotations\",\"fields\":[{\"name\":\"variantCallErrorProbability\",\"type\":[\"null\",\"float\"],\"default\":null},{\"name\":\"variantIsPassing\",\"type\":[\"null\",\"boolean\"],\"default\":null},{\"name\":\"variantFilters\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"default\":[]},{\"name\":\"readDepth\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"downsampled\",\"type\":[\"null\",\"boolean\"],\"default\":null},{\"name\":\"baseQRankSum\",\"type\":[\"null\",\"float\"],\"default\":null},{\"name\":\"clippingRankSum\",\"type\":[\"null\",\"float\"],\"default\":null},{\"name\":\"fisherStrandBiasPValue\",\"type\":[\"null\",\"float\"],\"default\":null},{\"name\":\"haplotypeScore\",\"type\":[\"null\",\"float\"],\"default\":null},{\"name\":\"inbreedingCoefficient\",\"type\":[\"null\",\"float\"],\"default\":null},{\"name\":\"rmsMapQ\",\"type\":[\"null\",\"float\"],\"default\":null},{\"name\":\"mapq0Reads\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"mqRankSum\",\"type\":[\"null\",\"float\"],\"default\":null},{\"name\":\"variantQualityByDepth\",\"type\":[\"null\",\"float\"],\"default\":null},{\"name\":\"readPositionRankSum\",\"type\":[\"null\",\"float\"],\"default\":null},{\"name\":\"vqslod\",\"type\":[\"null\",\"float\"],\"default\":null},{\"name\":\"culprit\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"usedForNegativeTrainingSet\",\"type\":[\"null\",\"boolean\"],\"default\":null},{\"name\":\"usedForPositiveTrainingSet\",\"type\":[\"null\",\"boolean\"],\"default\":null}]}],\"doc\":\"Statistics collected at this site, if available.\",\"default\":null},{\"name\":\"sampleId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The unique identifier for this sample.\",\"default\":null},{\"name\":\"sampleDescription\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A description of this sample.\",\"default\":null},{\"name\":\"processingDescription\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A string describing the provenance of this sample and the processing applied\\n   in genotyping this sample.\",\"default\":null},{\"name\":\"alleles\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"enum\",\"name\":\"GenotypeAllele\",\"doc\":\"An enumeration that describes the allele that corresponds to a genotype. Can take\\n the following values:\\n\\n * Ref: The genotype is the reference allele\\n * Alt: The genotype is the alternate allele\\n * OtherAlt: The genotype is an unspecified other alternate allele. This occurs\\n   in our schema when we have split a multi-allelic genotype into two genotype\\n   records.\\n * NoCall: The genotype could not be called.\",\"symbols\":[\"Ref\",\"Alt\",\"OtherAlt\",\"NoCall\"]}},\"doc\":\"An array describing the genotype called at this site. The length of this\\n   array is equal to the ploidy of the sample at this site. This array may\\n   reference OtherAlt alleles if this site is multi-allelic in this sample.\",\"default\":[]},{\"name\":\"expectedAlleleDosage\",\"type\":[\"null\",\"float\"],\"doc\":\"The expected dosage of the alternate allele in this sample.\",\"default\":null},{\"name\":\"referenceReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"The number of reads that show evidence for the reference at this site.\\n   \\n   @see alternateReadDepth\\n   @see readDepth\",\"default\":null},{\"name\":\"alternateReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"The number of reads that show evidence for this alternate allele at this site.\\n   \\n   @see referenceReadDepth\\n   @see readDepth\",\"default\":null},{\"name\":\"readDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"The total number of reads at this site. May not equal (alternateReadDepth +\\n   referenceReadDepth) if this site shows evidence of multiple alternate alleles.\\n   \\n   @see referenceReadDepth\\n   @see alternateReadDepth\\n\\n   @note Analogous to VCF's DP.\",\"default\":null},{\"name\":\"minReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"The minimum number of reads seen at this site across samples when joint\\n   calling variants.\\n\\n   @note Analogous to VCF's MIN_DP.\",\"default\":null},{\"name\":\"genotypeQuality\",\"type\":[\"null\",\"int\"],\"doc\":\"The phred-scaled probability that we're correct for this genotype call.\\n\\n   @note Analogous to VCF's GQ.\",\"default\":null},{\"name\":\"genotypeLikelihoods\",\"type\":{\"type\":\"array\",\"items\":\"int\"},\"doc\":\"Phred scaled likelihoods that we have n copies of this alternate allele.\\n   The number of elements in this array should be equal to the ploidy at this\\n   site, plus 1.\\n   \\n   @note Analogous to VCF's PL.\",\"default\":[]},{\"name\":\"nonReferenceLikelihoods\",\"type\":{\"type\":\"array\",\"items\":\"int\"},\"doc\":\"Phred scaled likelihoods that we have n non-reference alleles at this site.\\n   The number of elements in this array should be equal to the ploidy at this\\n   site, plus 1.\",\"default\":[]},{\"name\":\"strandBiasComponents\",\"type\":{\"type\":\"array\",\"items\":\"int\"},\"doc\":\"Component statistics which comprise the Fisher's Exact Test to detect strand bias.\",\"default\":[]},{\"name\":\"splitFromMultiAllelic\",\"type\":[\"boolean\",\"null\"],\"doc\":\"We split multi-allelic VCF lines into multiple\\n   single-alternate records.  This bit is set if that happened for this\\n   record.\",\"default\":false},{\"name\":\"isPhased\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this genotype is phased.\\n\\n   @see phaseSetId\\n   @see phaseQuality\",\"default\":false},{\"name\":\"phaseSetId\",\"type\":[\"null\",\"int\"],\"doc\":\"The ID of this phase set, if this genotype is phased. Should only be populated\\n   if isPhased == true; else should be null.\\n\\n   @see isPhased\",\"default\":null},{\"name\":\"phaseQuality\",\"type\":[\"null\",\"int\"],\"doc\":\"Phred scaled quality score for the phasing of this genotype, if this genotype\\n   is phased. Should only be populated if isPhased == true; else should be null.\\n\\n   @see isPhased\",\"default\":null}]}");
    @Deprecated
    public Variant variant;
    @Deprecated
    public VariantCallingAnnotations variantCallingAnnotations;
    @Deprecated
    public String sampleId;
    @Deprecated
    public String sampleDescription;
    @Deprecated
    public String processingDescription;
    @Deprecated
    public List<GenotypeAllele> alleles;
    @Deprecated
    public Float expectedAlleleDosage;
    @Deprecated
    public Integer referenceReadDepth;
    @Deprecated
    public Integer alternateReadDepth;
    @Deprecated
    public Integer readDepth;
    @Deprecated
    public Integer minReadDepth;
    @Deprecated
    public Integer genotypeQuality;
    @Deprecated
    public List<Integer> genotypeLikelihoods;
    @Deprecated
    public List<Integer> nonReferenceLikelihoods;
    @Deprecated
    public List<Integer> strandBiasComponents;
    @Deprecated
    public Boolean splitFromMultiAllelic;
    @Deprecated
    public Boolean isPhased;
    @Deprecated
    public Integer phaseSetId;
    @Deprecated
    public Integer phaseQuality;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public Genotype() {
    }

    public Genotype(Variant variant, VariantCallingAnnotations variantCallingAnnotations, String sampleId, String sampleDescription, String processingDescription, List<GenotypeAllele> alleles, Float expectedAlleleDosage, Integer referenceReadDepth, Integer alternateReadDepth, Integer readDepth, Integer minReadDepth, Integer genotypeQuality, List<Integer> genotypeLikelihoods, List<Integer> nonReferenceLikelihoods, List<Integer> strandBiasComponents, Boolean splitFromMultiAllelic, Boolean isPhased, Integer phaseSetId, Integer phaseQuality) {
        this.variant = variant;
        this.variantCallingAnnotations = variantCallingAnnotations;
        this.sampleId = sampleId;
        this.sampleDescription = sampleDescription;
        this.processingDescription = processingDescription;
        this.alleles = alleles;
        this.expectedAlleleDosage = expectedAlleleDosage;
        this.referenceReadDepth = referenceReadDepth;
        this.alternateReadDepth = alternateReadDepth;
        this.readDepth = readDepth;
        this.minReadDepth = minReadDepth;
        this.genotypeQuality = genotypeQuality;
        this.genotypeLikelihoods = genotypeLikelihoods;
        this.nonReferenceLikelihoods = nonReferenceLikelihoods;
        this.strandBiasComponents = strandBiasComponents;
        this.splitFromMultiAllelic = splitFromMultiAllelic;
        this.isPhased = isPhased;
        this.phaseSetId = phaseSetId;
        this.phaseQuality = phaseQuality;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.variant;
            }
            case 1: {
                return this.variantCallingAnnotations;
            }
            case 2: {
                return this.sampleId;
            }
            case 3: {
                return this.sampleDescription;
            }
            case 4: {
                return this.processingDescription;
            }
            case 5: {
                return this.alleles;
            }
            case 6: {
                return this.expectedAlleleDosage;
            }
            case 7: {
                return this.referenceReadDepth;
            }
            case 8: {
                return this.alternateReadDepth;
            }
            case 9: {
                return this.readDepth;
            }
            case 10: {
                return this.minReadDepth;
            }
            case 11: {
                return this.genotypeQuality;
            }
            case 12: {
                return this.genotypeLikelihoods;
            }
            case 13: {
                return this.nonReferenceLikelihoods;
            }
            case 14: {
                return this.strandBiasComponents;
            }
            case 15: {
                return this.splitFromMultiAllelic;
            }
            case 16: {
                return this.isPhased;
            }
            case 17: {
                return this.phaseSetId;
            }
            case 18: {
                return this.phaseQuality;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.variant = (Variant)((Object)value$);
                break;
            }
            case 1: {
                this.variantCallingAnnotations = (VariantCallingAnnotations)((Object)value$);
                break;
            }
            case 2: {
                this.sampleId = (String)value$;
                break;
            }
            case 3: {
                this.sampleDescription = (String)value$;
                break;
            }
            case 4: {
                this.processingDescription = (String)value$;
                break;
            }
            case 5: {
                this.alleles = (List)value$;
                break;
            }
            case 6: {
                this.expectedAlleleDosage = (Float)value$;
                break;
            }
            case 7: {
                this.referenceReadDepth = (Integer)value$;
                break;
            }
            case 8: {
                this.alternateReadDepth = (Integer)value$;
                break;
            }
            case 9: {
                this.readDepth = (Integer)value$;
                break;
            }
            case 10: {
                this.minReadDepth = (Integer)value$;
                break;
            }
            case 11: {
                this.genotypeQuality = (Integer)value$;
                break;
            }
            case 12: {
                this.genotypeLikelihoods = (List)value$;
                break;
            }
            case 13: {
                this.nonReferenceLikelihoods = (List)value$;
                break;
            }
            case 14: {
                this.strandBiasComponents = (List)value$;
                break;
            }
            case 15: {
                this.splitFromMultiAllelic = (Boolean)value$;
                break;
            }
            case 16: {
                this.isPhased = (Boolean)value$;
                break;
            }
            case 17: {
                this.phaseSetId = (Integer)value$;
                break;
            }
            case 18: {
                this.phaseQuality = (Integer)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public Variant getVariant() {
        return this.variant;
    }

    public void setVariant(Variant value) {
        this.variant = value;
    }

    public VariantCallingAnnotations getVariantCallingAnnotations() {
        return this.variantCallingAnnotations;
    }

    public void setVariantCallingAnnotations(VariantCallingAnnotations value) {
        this.variantCallingAnnotations = value;
    }

    public String getSampleId() {
        return this.sampleId;
    }

    public void setSampleId(String value) {
        this.sampleId = value;
    }

    public String getSampleDescription() {
        return this.sampleDescription;
    }

    public void setSampleDescription(String value) {
        this.sampleDescription = value;
    }

    public String getProcessingDescription() {
        return this.processingDescription;
    }

    public void setProcessingDescription(String value) {
        this.processingDescription = value;
    }

    public List<GenotypeAllele> getAlleles() {
        return this.alleles;
    }

    public void setAlleles(List<GenotypeAllele> value) {
        this.alleles = value;
    }

    public Float getExpectedAlleleDosage() {
        return this.expectedAlleleDosage;
    }

    public void setExpectedAlleleDosage(Float value) {
        this.expectedAlleleDosage = value;
    }

    public Integer getReferenceReadDepth() {
        return this.referenceReadDepth;
    }

    public void setReferenceReadDepth(Integer value) {
        this.referenceReadDepth = value;
    }

    public Integer getAlternateReadDepth() {
        return this.alternateReadDepth;
    }

    public void setAlternateReadDepth(Integer value) {
        this.alternateReadDepth = value;
    }

    public Integer getReadDepth() {
        return this.readDepth;
    }

    public void setReadDepth(Integer value) {
        this.readDepth = value;
    }

    public Integer getMinReadDepth() {
        return this.minReadDepth;
    }

    public void setMinReadDepth(Integer value) {
        this.minReadDepth = value;
    }

    public Integer getGenotypeQuality() {
        return this.genotypeQuality;
    }

    public void setGenotypeQuality(Integer value) {
        this.genotypeQuality = value;
    }

    public List<Integer> getGenotypeLikelihoods() {
        return this.genotypeLikelihoods;
    }

    public void setGenotypeLikelihoods(List<Integer> value) {
        this.genotypeLikelihoods = value;
    }

    public List<Integer> getNonReferenceLikelihoods() {
        return this.nonReferenceLikelihoods;
    }

    public void setNonReferenceLikelihoods(List<Integer> value) {
        this.nonReferenceLikelihoods = value;
    }

    public List<Integer> getStrandBiasComponents() {
        return this.strandBiasComponents;
    }

    public void setStrandBiasComponents(List<Integer> value) {
        this.strandBiasComponents = value;
    }

    public Boolean getSplitFromMultiAllelic() {
        return this.splitFromMultiAllelic;
    }

    public void setSplitFromMultiAllelic(Boolean value) {
        this.splitFromMultiAllelic = value;
    }

    public Boolean getIsPhased() {
        return this.isPhased;
    }

    public void setIsPhased(Boolean value) {
        this.isPhased = value;
    }

    public Integer getPhaseSetId() {
        return this.phaseSetId;
    }

    public void setPhaseSetId(Integer value) {
        this.phaseSetId = value;
    }

    public Integer getPhaseQuality() {
        return this.phaseQuality;
    }

    public void setPhaseQuality(Integer value) {
        this.phaseQuality = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(Genotype other) {
        return new Builder(other);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends SpecificRecordBuilderBase<Genotype>
    implements RecordBuilder<Genotype> {
        private Variant variant;
        private VariantCallingAnnotations variantCallingAnnotations;
        private String sampleId;
        private String sampleDescription;
        private String processingDescription;
        private List<GenotypeAllele> alleles;
        private Float expectedAlleleDosage;
        private Integer referenceReadDepth;
        private Integer alternateReadDepth;
        private Integer readDepth;
        private Integer minReadDepth;
        private Integer genotypeQuality;
        private List<Integer> genotypeLikelihoods;
        private List<Integer> nonReferenceLikelihoods;
        private List<Integer> strandBiasComponents;
        private Boolean splitFromMultiAllelic;
        private Boolean isPhased;
        private Integer phaseSetId;
        private Integer phaseQuality;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
        }

        private Builder(Genotype other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.variant))) {
                this.variant = (Variant)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.variant));
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.variantCallingAnnotations))) {
                this.variantCallingAnnotations = (VariantCallingAnnotations)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.variantCallingAnnotations));
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.sampleId)) {
                this.sampleId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.sampleId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.sampleDescription)) {
                this.sampleDescription = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.sampleDescription);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.processingDescription)) {
                this.processingDescription = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.processingDescription);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], other.alleles)) {
                this.alleles = (List)this.data().deepCopy(this.fields()[5].schema(), other.alleles);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.expectedAlleleDosage)) {
                this.expectedAlleleDosage = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.expectedAlleleDosage);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.referenceReadDepth)) {
                this.referenceReadDepth = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.referenceReadDepth);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.alternateReadDepth)) {
                this.alternateReadDepth = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.alternateReadDepth);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.readDepth)) {
                this.readDepth = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.readDepth);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.minReadDepth)) {
                this.minReadDepth = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.minReadDepth);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.genotypeQuality)) {
                this.genotypeQuality = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.genotypeQuality);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], other.genotypeLikelihoods)) {
                this.genotypeLikelihoods = (List)this.data().deepCopy(this.fields()[12].schema(), other.genotypeLikelihoods);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], other.nonReferenceLikelihoods)) {
                this.nonReferenceLikelihoods = (List)this.data().deepCopy(this.fields()[13].schema(), other.nonReferenceLikelihoods);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], other.strandBiasComponents)) {
                this.strandBiasComponents = (List)this.data().deepCopy(this.fields()[14].schema(), other.strandBiasComponents);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.splitFromMultiAllelic)) {
                this.splitFromMultiAllelic = (Boolean)this.data().deepCopy(this.fields()[15].schema(), (Object)other.splitFromMultiAllelic);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.isPhased)) {
                this.isPhased = (Boolean)this.data().deepCopy(this.fields()[16].schema(), (Object)other.isPhased);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.phaseSetId)) {
                this.phaseSetId = (Integer)this.data().deepCopy(this.fields()[17].schema(), (Object)other.phaseSetId);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.phaseQuality)) {
                this.phaseQuality = (Integer)this.data().deepCopy(this.fields()[18].schema(), (Object)other.phaseQuality);
                this.fieldSetFlags()[18] = true;
            }
        }

        public Variant getVariant() {
            return this.variant;
        }

        public Builder setVariant(Variant value) {
            this.validate(this.fields()[0], (Object)value);
            this.variant = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasVariant() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearVariant() {
            this.variant = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public VariantCallingAnnotations getVariantCallingAnnotations() {
            return this.variantCallingAnnotations;
        }

        public Builder setVariantCallingAnnotations(VariantCallingAnnotations value) {
            this.validate(this.fields()[1], (Object)value);
            this.variantCallingAnnotations = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasVariantCallingAnnotations() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearVariantCallingAnnotations() {
            this.variantCallingAnnotations = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSampleId() {
            return this.sampleId;
        }

        public Builder setSampleId(String value) {
            this.validate(this.fields()[2], value);
            this.sampleId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSampleId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSampleId() {
            this.sampleId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getSampleDescription() {
            return this.sampleDescription;
        }

        public Builder setSampleDescription(String value) {
            this.validate(this.fields()[3], value);
            this.sampleDescription = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasSampleDescription() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearSampleDescription() {
            this.sampleDescription = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getProcessingDescription() {
            return this.processingDescription;
        }

        public Builder setProcessingDescription(String value) {
            this.validate(this.fields()[4], value);
            this.processingDescription = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasProcessingDescription() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearProcessingDescription() {
            this.processingDescription = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public List<GenotypeAllele> getAlleles() {
            return this.alleles;
        }

        public Builder setAlleles(List<GenotypeAllele> value) {
            this.validate(this.fields()[5], value);
            this.alleles = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasAlleles() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearAlleles() {
            this.alleles = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Float getExpectedAlleleDosage() {
            return this.expectedAlleleDosage;
        }

        public Builder setExpectedAlleleDosage(Float value) {
            this.validate(this.fields()[6], value);
            this.expectedAlleleDosage = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasExpectedAlleleDosage() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearExpectedAlleleDosage() {
            this.expectedAlleleDosage = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Integer getReferenceReadDepth() {
            return this.referenceReadDepth;
        }

        public Builder setReferenceReadDepth(Integer value) {
            this.validate(this.fields()[7], value);
            this.referenceReadDepth = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasReferenceReadDepth() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearReferenceReadDepth() {
            this.referenceReadDepth = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Integer getAlternateReadDepth() {
            return this.alternateReadDepth;
        }

        public Builder setAlternateReadDepth(Integer value) {
            this.validate(this.fields()[8], value);
            this.alternateReadDepth = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasAlternateReadDepth() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearAlternateReadDepth() {
            this.alternateReadDepth = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Integer getReadDepth() {
            return this.readDepth;
        }

        public Builder setReadDepth(Integer value) {
            this.validate(this.fields()[9], value);
            this.readDepth = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasReadDepth() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearReadDepth() {
            this.readDepth = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Integer getMinReadDepth() {
            return this.minReadDepth;
        }

        public Builder setMinReadDepth(Integer value) {
            this.validate(this.fields()[10], value);
            this.minReadDepth = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasMinReadDepth() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearMinReadDepth() {
            this.minReadDepth = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Integer getGenotypeQuality() {
            return this.genotypeQuality;
        }

        public Builder setGenotypeQuality(Integer value) {
            this.validate(this.fields()[11], value);
            this.genotypeQuality = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasGenotypeQuality() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearGenotypeQuality() {
            this.genotypeQuality = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public List<Integer> getGenotypeLikelihoods() {
            return this.genotypeLikelihoods;
        }

        public Builder setGenotypeLikelihoods(List<Integer> value) {
            this.validate(this.fields()[12], value);
            this.genotypeLikelihoods = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasGenotypeLikelihoods() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearGenotypeLikelihoods() {
            this.genotypeLikelihoods = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public List<Integer> getNonReferenceLikelihoods() {
            return this.nonReferenceLikelihoods;
        }

        public Builder setNonReferenceLikelihoods(List<Integer> value) {
            this.validate(this.fields()[13], value);
            this.nonReferenceLikelihoods = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasNonReferenceLikelihoods() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearNonReferenceLikelihoods() {
            this.nonReferenceLikelihoods = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public List<Integer> getStrandBiasComponents() {
            return this.strandBiasComponents;
        }

        public Builder setStrandBiasComponents(List<Integer> value) {
            this.validate(this.fields()[14], value);
            this.strandBiasComponents = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasStrandBiasComponents() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearStrandBiasComponents() {
            this.strandBiasComponents = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public Boolean getSplitFromMultiAllelic() {
            return this.splitFromMultiAllelic;
        }

        public Builder setSplitFromMultiAllelic(Boolean value) {
            this.validate(this.fields()[15], value);
            this.splitFromMultiAllelic = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasSplitFromMultiAllelic() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearSplitFromMultiAllelic() {
            this.splitFromMultiAllelic = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public Boolean getIsPhased() {
            return this.isPhased;
        }

        public Builder setIsPhased(Boolean value) {
            this.validate(this.fields()[16], value);
            this.isPhased = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasIsPhased() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearIsPhased() {
            this.isPhased = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public Integer getPhaseSetId() {
            return this.phaseSetId;
        }

        public Builder setPhaseSetId(Integer value) {
            this.validate(this.fields()[17], value);
            this.phaseSetId = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasPhaseSetId() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearPhaseSetId() {
            this.phaseSetId = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public Integer getPhaseQuality() {
            return this.phaseQuality;
        }

        public Builder setPhaseQuality(Integer value) {
            this.validate(this.fields()[18], value);
            this.phaseQuality = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasPhaseQuality() {
            return this.fieldSetFlags()[18];
        }

        public Builder clearPhaseQuality() {
            this.phaseQuality = null;
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public Genotype build() {
            try {
                Genotype record = new Genotype();
                record.variant = this.fieldSetFlags()[0] ? this.variant : (Variant)((Object)this.defaultValue(this.fields()[0]));
                record.variantCallingAnnotations = this.fieldSetFlags()[1] ? this.variantCallingAnnotations : (VariantCallingAnnotations)((Object)this.defaultValue(this.fields()[1]));
                record.sampleId = this.fieldSetFlags()[2] ? this.sampleId : (String)this.defaultValue(this.fields()[2]);
                record.sampleDescription = this.fieldSetFlags()[3] ? this.sampleDescription : (String)this.defaultValue(this.fields()[3]);
                record.processingDescription = this.fieldSetFlags()[4] ? this.processingDescription : (String)this.defaultValue(this.fields()[4]);
                record.alleles = this.fieldSetFlags()[5] ? this.alleles : (List)this.defaultValue(this.fields()[5]);
                record.expectedAlleleDosage = this.fieldSetFlags()[6] ? this.expectedAlleleDosage : (Float)this.defaultValue(this.fields()[6]);
                record.referenceReadDepth = this.fieldSetFlags()[7] ? this.referenceReadDepth : (Integer)this.defaultValue(this.fields()[7]);
                record.alternateReadDepth = this.fieldSetFlags()[8] ? this.alternateReadDepth : (Integer)this.defaultValue(this.fields()[8]);
                record.readDepth = this.fieldSetFlags()[9] ? this.readDepth : (Integer)this.defaultValue(this.fields()[9]);
                record.minReadDepth = this.fieldSetFlags()[10] ? this.minReadDepth : (Integer)this.defaultValue(this.fields()[10]);
                record.genotypeQuality = this.fieldSetFlags()[11] ? this.genotypeQuality : (Integer)this.defaultValue(this.fields()[11]);
                record.genotypeLikelihoods = this.fieldSetFlags()[12] ? this.genotypeLikelihoods : (List)this.defaultValue(this.fields()[12]);
                record.nonReferenceLikelihoods = this.fieldSetFlags()[13] ? this.nonReferenceLikelihoods : (List)this.defaultValue(this.fields()[13]);
                record.strandBiasComponents = this.fieldSetFlags()[14] ? this.strandBiasComponents : (List)this.defaultValue(this.fields()[14]);
                record.splitFromMultiAllelic = this.fieldSetFlags()[15] ? this.splitFromMultiAllelic : (Boolean)this.defaultValue(this.fields()[15]);
                record.isPhased = this.fieldSetFlags()[16] ? this.isPhased : (Boolean)this.defaultValue(this.fields()[16]);
                record.phaseSetId = this.fieldSetFlags()[17] ? this.phaseSetId : (Integer)this.defaultValue(this.fields()[17]);
                record.phaseQuality = this.fieldSetFlags()[18] ? this.phaseQuality : (Integer)this.defaultValue(this.fields()[18]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

