/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.bdgenomics.formats.avro.Base;
import org.bdgenomics.formats.avro.Contig;

@AvroGenerated
public class Pileup
extends SpecificRecordBase
implements SpecificRecord {
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Pileup\",\"namespace\":\"org.bdgenomics.formats.avro\",\"fields\":[{\"name\":\"contig\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Contig\",\"doc\":\"Record for describing a reference assembly. Not used for storing the contents\\n of said assembly.\\n\\n @see NucleotideContigFragment\",\"fields\":[{\"name\":\"contigName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of this contig in the assembly (e.g., \\\"chr1\\\").\",\"default\":null},{\"name\":\"contigLength\",\"type\":[\"null\",\"long\"],\"doc\":\"The length of this contig.\",\"default\":null},{\"name\":\"contigMD5\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The MD5 checksum of the assembly for this contig.\",\"default\":null},{\"name\":\"referenceURL\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The URL at which this reference assembly can be found.\",\"default\":null},{\"name\":\"assembly\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of this assembly (e.g., \\\"hg19\\\").\",\"default\":null},{\"name\":\"species\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The species that this assembly is for.\",\"default\":null}]}],\"doc\":\"The reference contig that this pileup is mapped to.\",\"default\":null},{\"name\":\"position\",\"type\":[\"null\",\"long\"],\"doc\":\"The 0-based mapping position of this pileup on the reference contig.\",\"default\":null},{\"name\":\"rangeOffset\",\"type\":[\"null\",\"int\"],\"doc\":\"The range offset and range length fields are used when an insertion or\\n   deletion has occured. The range length indicates the length of the event\\n   and the range offset field indicates the location of this base in the\\n   insertion or deletion event.\",\"default\":null},{\"name\":\"rangeLength\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"referenceBase\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"Base\",\"doc\":\"Enumeration for DNA/RNA bases. For codes outside of ACTGU, see the IUPAC \\n resolution codes (http://www.bioinformatics.org/sms/iupac.html).\",\"symbols\":[\"A\",\"C\",\"T\",\"G\",\"U\",\"N\",\"X\",\"K\",\"M\",\"R\",\"Y\",\"S\",\"W\",\"B\",\"V\",\"H\",\"D\"]}],\"doc\":\"The base in the reference at this position.\",\"default\":null},{\"name\":\"readBase\",\"type\":[\"null\",\"Base\"],\"doc\":\"The read base at this position.\",\"default\":null},{\"name\":\"sampleId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"sangerQuality\",\"type\":[\"null\",\"int\"],\"doc\":\"The Phred scaled base quality at this position.\",\"default\":null},{\"name\":\"mapQuality\",\"type\":[\"null\",\"int\"],\"doc\":\"The Phred scaled mapping quality of the read this pileup came from.\",\"default\":null},{\"name\":\"isReverseStrand\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this base is on the reverse strand.\",\"default\":false}]}");
    @Deprecated
    public Contig contig;
    @Deprecated
    public Long position;
    @Deprecated
    public Integer rangeOffset;
    @Deprecated
    public Integer rangeLength;
    @Deprecated
    public Base referenceBase;
    @Deprecated
    public Base readBase;
    @Deprecated
    public String sampleId;
    @Deprecated
    public Integer sangerQuality;
    @Deprecated
    public Integer mapQuality;
    @Deprecated
    public Boolean isReverseStrand;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public Pileup() {
    }

    public Pileup(Contig contig, Long position, Integer rangeOffset, Integer rangeLength, Base referenceBase, Base readBase, String sampleId, Integer sangerQuality, Integer mapQuality, Boolean isReverseStrand) {
        this.contig = contig;
        this.position = position;
        this.rangeOffset = rangeOffset;
        this.rangeLength = rangeLength;
        this.referenceBase = referenceBase;
        this.readBase = readBase;
        this.sampleId = sampleId;
        this.sangerQuality = sangerQuality;
        this.mapQuality = mapQuality;
        this.isReverseStrand = isReverseStrand;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.contig;
            }
            case 1: {
                return this.position;
            }
            case 2: {
                return this.rangeOffset;
            }
            case 3: {
                return this.rangeLength;
            }
            case 4: {
                return this.referenceBase;
            }
            case 5: {
                return this.readBase;
            }
            case 6: {
                return this.sampleId;
            }
            case 7: {
                return this.sangerQuality;
            }
            case 8: {
                return this.mapQuality;
            }
            case 9: {
                return this.isReverseStrand;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.contig = (Contig)((Object)value$);
                break;
            }
            case 1: {
                this.position = (Long)value$;
                break;
            }
            case 2: {
                this.rangeOffset = (Integer)value$;
                break;
            }
            case 3: {
                this.rangeLength = (Integer)value$;
                break;
            }
            case 4: {
                this.referenceBase = (Base)((Object)value$);
                break;
            }
            case 5: {
                this.readBase = (Base)((Object)value$);
                break;
            }
            case 6: {
                this.sampleId = (String)value$;
                break;
            }
            case 7: {
                this.sangerQuality = (Integer)value$;
                break;
            }
            case 8: {
                this.mapQuality = (Integer)value$;
                break;
            }
            case 9: {
                this.isReverseStrand = (Boolean)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public Contig getContig() {
        return this.contig;
    }

    public void setContig(Contig value) {
        this.contig = value;
    }

    public Long getPosition() {
        return this.position;
    }

    public void setPosition(Long value) {
        this.position = value;
    }

    public Integer getRangeOffset() {
        return this.rangeOffset;
    }

    public void setRangeOffset(Integer value) {
        this.rangeOffset = value;
    }

    public Integer getRangeLength() {
        return this.rangeLength;
    }

    public void setRangeLength(Integer value) {
        this.rangeLength = value;
    }

    public Base getReferenceBase() {
        return this.referenceBase;
    }

    public void setReferenceBase(Base value) {
        this.referenceBase = value;
    }

    public Base getReadBase() {
        return this.readBase;
    }

    public void setReadBase(Base value) {
        this.readBase = value;
    }

    public String getSampleId() {
        return this.sampleId;
    }

    public void setSampleId(String value) {
        this.sampleId = value;
    }

    public Integer getSangerQuality() {
        return this.sangerQuality;
    }

    public void setSangerQuality(Integer value) {
        this.sangerQuality = value;
    }

    public Integer getMapQuality() {
        return this.mapQuality;
    }

    public void setMapQuality(Integer value) {
        this.mapQuality = value;
    }

    public Boolean getIsReverseStrand() {
        return this.isReverseStrand;
    }

    public void setIsReverseStrand(Boolean value) {
        this.isReverseStrand = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(Pileup other) {
        return new Builder(other);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends SpecificRecordBuilderBase<Pileup>
    implements RecordBuilder<Pileup> {
        private Contig contig;
        private Long position;
        private Integer rangeOffset;
        private Integer rangeLength;
        private Base referenceBase;
        private Base readBase;
        private String sampleId;
        private Integer sangerQuality;
        private Integer mapQuality;
        private Boolean isReverseStrand;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
        }

        private Builder(Pileup other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.contig))) {
                this.contig = (Contig)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.contig));
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.position)) {
                this.position = (Long)this.data().deepCopy(this.fields()[1].schema(), (Object)other.position);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.rangeOffset)) {
                this.rangeOffset = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.rangeOffset);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.rangeLength)) {
                this.rangeLength = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.rangeLength);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.referenceBase))) {
                this.referenceBase = (Base)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.referenceBase));
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.readBase))) {
                this.readBase = (Base)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.readBase));
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.sampleId)) {
                this.sampleId = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.sampleId);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.sangerQuality)) {
                this.sangerQuality = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.sangerQuality);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.mapQuality)) {
                this.mapQuality = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.mapQuality);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.isReverseStrand)) {
                this.isReverseStrand = (Boolean)this.data().deepCopy(this.fields()[9].schema(), (Object)other.isReverseStrand);
                this.fieldSetFlags()[9] = true;
            }
        }

        public Contig getContig() {
            return this.contig;
        }

        public Builder setContig(Contig value) {
            this.validate(this.fields()[0], (Object)value);
            this.contig = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasContig() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearContig() {
            this.contig = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Long getPosition() {
            return this.position;
        }

        public Builder setPosition(Long value) {
            this.validate(this.fields()[1], value);
            this.position = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasPosition() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearPosition() {
            this.position = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Integer getRangeOffset() {
            return this.rangeOffset;
        }

        public Builder setRangeOffset(Integer value) {
            this.validate(this.fields()[2], value);
            this.rangeOffset = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasRangeOffset() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearRangeOffset() {
            this.rangeOffset = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Integer getRangeLength() {
            return this.rangeLength;
        }

        public Builder setRangeLength(Integer value) {
            this.validate(this.fields()[3], value);
            this.rangeLength = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasRangeLength() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearRangeLength() {
            this.rangeLength = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Base getReferenceBase() {
            return this.referenceBase;
        }

        public Builder setReferenceBase(Base value) {
            this.validate(this.fields()[4], (Object)value);
            this.referenceBase = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasReferenceBase() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearReferenceBase() {
            this.referenceBase = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Base getReadBase() {
            return this.readBase;
        }

        public Builder setReadBase(Base value) {
            this.validate(this.fields()[5], (Object)value);
            this.readBase = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasReadBase() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearReadBase() {
            this.readBase = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public String getSampleId() {
            return this.sampleId;
        }

        public Builder setSampleId(String value) {
            this.validate(this.fields()[6], value);
            this.sampleId = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasSampleId() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearSampleId() {
            this.sampleId = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Integer getSangerQuality() {
            return this.sangerQuality;
        }

        public Builder setSangerQuality(Integer value) {
            this.validate(this.fields()[7], value);
            this.sangerQuality = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasSangerQuality() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearSangerQuality() {
            this.sangerQuality = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Integer getMapQuality() {
            return this.mapQuality;
        }

        public Builder setMapQuality(Integer value) {
            this.validate(this.fields()[8], value);
            this.mapQuality = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasMapQuality() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearMapQuality() {
            this.mapQuality = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Boolean getIsReverseStrand() {
            return this.isReverseStrand;
        }

        public Builder setIsReverseStrand(Boolean value) {
            this.validate(this.fields()[9], value);
            this.isReverseStrand = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasIsReverseStrand() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearIsReverseStrand() {
            this.isReverseStrand = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Pileup build() {
            try {
                Pileup record = new Pileup();
                record.contig = this.fieldSetFlags()[0] ? this.contig : (Contig)((Object)this.defaultValue(this.fields()[0]));
                record.position = this.fieldSetFlags()[1] ? this.position : (Long)this.defaultValue(this.fields()[1]);
                record.rangeOffset = this.fieldSetFlags()[2] ? this.rangeOffset : (Integer)this.defaultValue(this.fields()[2]);
                record.rangeLength = this.fieldSetFlags()[3] ? this.rangeLength : (Integer)this.defaultValue(this.fields()[3]);
                record.referenceBase = this.fieldSetFlags()[4] ? this.referenceBase : (Base)((Object)this.defaultValue(this.fields()[4]));
                record.readBase = this.fieldSetFlags()[5] ? this.readBase : (Base)((Object)this.defaultValue(this.fields()[5]));
                record.sampleId = this.fieldSetFlags()[6] ? this.sampleId : (String)this.defaultValue(this.fields()[6]);
                record.sangerQuality = this.fieldSetFlags()[7] ? this.sangerQuality : (Integer)this.defaultValue(this.fields()[7]);
                record.mapQuality = this.fieldSetFlags()[8] ? this.mapQuality : (Integer)this.defaultValue(this.fields()[8]);
                record.isReverseStrand = this.fieldSetFlags()[9] ? this.isReverseStrand : (Boolean)this.defaultValue(this.fields()[9]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

