/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.bdgenomics.formats.avro.StructuralVariantType;

@AvroGenerated
public class StructuralVariant
extends SpecificRecordBase
implements SpecificRecord {
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"StructuralVariant\",\"namespace\":\"org.bdgenomics.formats.avro\",\"fields\":[{\"name\":\"type\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"StructuralVariantType\",\"doc\":\"Descriptors for the type of a structural variant. The most specific descriptor\\n should be used, if possible. E.g., duplication should be used instead of\\n insertion if the inserted sequence is not novel. Tandem duplication should\\n be used instead of duplication if the duplication is known to follow the\\n duplicated sequence.\",\"symbols\":[\"DELETION\",\"INSERTION\",\"INVERSION\",\"MOBILE_INSERTION\",\"MOBILE_DELETION\",\"DUPLICATION\",\"TANDEM_DUPLICATION\"]}],\"doc\":\"The type of this structural variant.\",\"default\":null},{\"name\":\"assembly\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The URL of the FASTA/NucleotideContig assembly for this structural variant,\\n   if one is available.\",\"default\":null},{\"name\":\"precise\",\"type\":[\"boolean\",\"null\"],\"doc\":\"Whether this structural variant call has precise breakpoints or not. Default\\n   value is true. If the call is imprecise, confidence intervals should be provided.\",\"default\":true},{\"name\":\"startWindow\",\"type\":[\"null\",\"int\"],\"doc\":\"The size of the confidence window around the start of the structural variant.\",\"default\":null},{\"name\":\"endWindow\",\"type\":[\"null\",\"int\"],\"doc\":\"The size of the confidence window around the end of the structural variant.\",\"default\":null}]}");
    @Deprecated
    public StructuralVariantType type;
    @Deprecated
    public String assembly;
    @Deprecated
    public Boolean precise;
    @Deprecated
    public Integer startWindow;
    @Deprecated
    public Integer endWindow;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public StructuralVariant() {
    }

    public StructuralVariant(StructuralVariantType type, String assembly, Boolean precise, Integer startWindow, Integer endWindow) {
        this.type = type;
        this.assembly = assembly;
        this.precise = precise;
        this.startWindow = startWindow;
        this.endWindow = endWindow;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.type;
            }
            case 1: {
                return this.assembly;
            }
            case 2: {
                return this.precise;
            }
            case 3: {
                return this.startWindow;
            }
            case 4: {
                return this.endWindow;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.type = (StructuralVariantType)((Object)value$);
                break;
            }
            case 1: {
                this.assembly = (String)value$;
                break;
            }
            case 2: {
                this.precise = (Boolean)value$;
                break;
            }
            case 3: {
                this.startWindow = (Integer)value$;
                break;
            }
            case 4: {
                this.endWindow = (Integer)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public StructuralVariantType getType() {
        return this.type;
    }

    public void setType(StructuralVariantType value) {
        this.type = value;
    }

    public String getAssembly() {
        return this.assembly;
    }

    public void setAssembly(String value) {
        this.assembly = value;
    }

    public Boolean getPrecise() {
        return this.precise;
    }

    public void setPrecise(Boolean value) {
        this.precise = value;
    }

    public Integer getStartWindow() {
        return this.startWindow;
    }

    public void setStartWindow(Integer value) {
        this.startWindow = value;
    }

    public Integer getEndWindow() {
        return this.endWindow;
    }

    public void setEndWindow(Integer value) {
        this.endWindow = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(StructuralVariant other) {
        return new Builder(other);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends SpecificRecordBuilderBase<StructuralVariant>
    implements RecordBuilder<StructuralVariant> {
        private StructuralVariantType type;
        private String assembly;
        private Boolean precise;
        private Integer startWindow;
        private Integer endWindow;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
        }

        private Builder(StructuralVariant other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.type))) {
                this.type = (StructuralVariantType)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.type));
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.assembly)) {
                this.assembly = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.assembly);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.precise)) {
                this.precise = (Boolean)this.data().deepCopy(this.fields()[2].schema(), (Object)other.precise);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.startWindow)) {
                this.startWindow = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.startWindow);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.endWindow)) {
                this.endWindow = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.endWindow);
                this.fieldSetFlags()[4] = true;
            }
        }

        public StructuralVariantType getType() {
            return this.type;
        }

        public Builder setType(StructuralVariantType value) {
            this.validate(this.fields()[0], (Object)value);
            this.type = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasType() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearType() {
            this.type = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getAssembly() {
            return this.assembly;
        }

        public Builder setAssembly(String value) {
            this.validate(this.fields()[1], value);
            this.assembly = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasAssembly() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearAssembly() {
            this.assembly = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Boolean getPrecise() {
            return this.precise;
        }

        public Builder setPrecise(Boolean value) {
            this.validate(this.fields()[2], value);
            this.precise = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasPrecise() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearPrecise() {
            this.precise = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Integer getStartWindow() {
            return this.startWindow;
        }

        public Builder setStartWindow(Integer value) {
            this.validate(this.fields()[3], value);
            this.startWindow = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasStartWindow() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearStartWindow() {
            this.startWindow = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getEndWindow() {
            return this.endWindow;
        }

        public Builder setEndWindow(Integer value) {
            this.validate(this.fields()[4], value);
            this.endWindow = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasEndWindow() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearEndWindow() {
            this.endWindow = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public StructuralVariant build() {
            try {
                StructuralVariant record = new StructuralVariant();
                record.type = this.fieldSetFlags()[0] ? this.type : (StructuralVariantType)((Object)this.defaultValue(this.fields()[0]));
                record.assembly = this.fieldSetFlags()[1] ? this.assembly : (String)this.defaultValue(this.fields()[1]);
                record.precise = this.fieldSetFlags()[2] ? this.precise : (Boolean)this.defaultValue(this.fields()[2]);
                record.startWindow = this.fieldSetFlags()[3] ? this.startWindow : (Integer)this.defaultValue(this.fields()[3]);
                record.endWindow = this.fieldSetFlags()[4] ? this.endWindow : (Integer)this.defaultValue(this.fields()[4]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

