/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileConstants;
import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexer;
import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;

class BAMFileWriter
extends SAMFileWriterImpl {
    private final BinaryCodec outputBinaryCodec;
    private BAMRecordCodec bamRecordCodec = null;
    private final BlockCompressedOutputStream blockCompressedOutputStream;
    private BAMIndexer bamIndexer = null;

    protected BAMFileWriter(File file) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(file);
        this.outputBinaryCodec = new BinaryCodec(new DataOutputStream(this.blockCompressedOutputStream));
        this.outputBinaryCodec.setOutputFileName(file.getAbsolutePath());
    }

    protected BAMFileWriter(File file, int n) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(file, n);
        this.outputBinaryCodec = new BinaryCodec(new DataOutputStream(this.blockCompressedOutputStream));
        this.outputBinaryCodec.setOutputFileName(file.getAbsolutePath());
    }

    protected BAMFileWriter(OutputStream outputStream, File file) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(outputStream, file);
        this.outputBinaryCodec = new BinaryCodec(new DataOutputStream(this.blockCompressedOutputStream));
        this.outputBinaryCodec.setOutputFileName(this.getPathString(file));
    }

    protected BAMFileWriter(OutputStream outputStream, File file, int n) {
        this.blockCompressedOutputStream = new BlockCompressedOutputStream(outputStream, file, n);
        this.outputBinaryCodec = new BinaryCodec(new DataOutputStream(this.blockCompressedOutputStream));
        this.outputBinaryCodec.setOutputFileName(this.getPathString(file));
    }

    private void prepareToWriteAlignments() {
        if (this.bamRecordCodec == null) {
            this.bamRecordCodec = new BAMRecordCodec(this.getFileHeader());
            this.bamRecordCodec.setOutputStream(this.outputBinaryCodec.getOutputStream(), this.getFilename());
        }
    }

    private String getPathString(File file) {
        return file != null ? file.getAbsolutePath() : null;
    }

    void enableBamIndexConstruction() {
        if (!this.getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            throw new SAMException("Not creating BAM index since not sorted by coordinates: " + (Object)((Object)this.getSortOrder()));
        }
        if (this.getFilename() == null) {
            throw new SAMException("Not creating BAM index since we don't have an output file name");
        }
        this.bamIndexer = this.createBamIndex(this.getFilename());
    }

    private BAMIndexer createBamIndex(String string) {
        try {
            String string2 = string.endsWith(".bam") ? string.substring(0, string.lastIndexOf(".")) : string;
            File file = new File(string2 + ".bai");
            if (file.exists() && !file.canWrite()) {
                throw new SAMException("Not creating BAM index since unable to write index file " + file);
            }
            return new BAMIndexer(file, this.getFileHeader());
        }
        catch (Exception exception) {
            throw new SAMException("Not creating BAM index", exception);
        }
    }

    @Override
    protected void writeAlignment(SAMRecord sAMRecord) {
        this.prepareToWriteAlignments();
        if (this.bamIndexer != null) {
            try {
                long l = this.blockCompressedOutputStream.getFilePointer();
                this.bamRecordCodec.encode(sAMRecord);
                long l2 = this.blockCompressedOutputStream.getFilePointer();
                sAMRecord.setFileSource(new SAMFileSource(null, new BAMFileSpan(new Chunk(l, l2))));
                this.bamIndexer.processAlignment(sAMRecord);
            }
            catch (Exception exception) {
                this.bamIndexer = null;
                throw new SAMException("Exception when processing alignment for BAM index " + sAMRecord, exception);
            }
        } else {
            this.bamRecordCodec.encode(sAMRecord);
        }
    }

    @Override
    protected void writeHeader(String string) {
        BAMFileWriter.writeHeader(this.outputBinaryCodec, this.getFileHeader(), string);
    }

    @Override
    protected void finish() {
        this.outputBinaryCodec.close();
        try {
            if (this.bamIndexer != null) {
                this.bamIndexer.finish();
            }
        }
        catch (Exception exception) {
            throw new SAMException("Exception writing BAM index file", exception);
        }
    }

    @Override
    protected String getFilename() {
        return this.outputBinaryCodec.getOutputFileName();
    }

    protected static void writeHeader(BinaryCodec binaryCodec, SAMFileHeader sAMFileHeader, String string) {
        binaryCodec.writeBytes(BAMFileConstants.BAM_MAGIC);
        binaryCodec.writeString(string, true, false);
        binaryCodec.writeInt(sAMFileHeader.getSequenceDictionary().size());
        for (SAMSequenceRecord sAMSequenceRecord : sAMFileHeader.getSequenceDictionary().getSequences()) {
            binaryCodec.writeString(sAMSequenceRecord.getSequenceName(), true, true);
            binaryCodec.writeInt(sAMSequenceRecord.getSequenceLength());
        }
    }

    protected static void writeHeader(BinaryCodec binaryCodec, SAMFileHeader sAMFileHeader) {
        StringWriter stringWriter = new StringWriter();
        new SAMTextHeaderCodec().encode(stringWriter, sAMFileHeader, true);
        String string = ((Object)stringWriter).toString();
        BAMFileWriter.writeHeader(binaryCodec, sAMFileHeader, string);
    }

    protected static void writeHeader(OutputStream outputStream, SAMFileHeader sAMFileHeader) {
        BlockCompressedOutputStream blockCompressedOutputStream = new BlockCompressedOutputStream(outputStream, null);
        BinaryCodec binaryCodec = new BinaryCodec(new DataOutputStream(blockCompressedOutputStream));
        BAMFileWriter.writeHeader(binaryCodec, sAMFileHeader);
        try {
            blockCompressedOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }
}

