/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AsyncSAMFileWriter;
import htsjdk.samtools.BAMFileWriter;
import htsjdk.samtools.CRAMFileWriter;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMTextWriter;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Md5CalculatingOutputStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SAMFileWriterFactory {
    private static boolean defaultCreateIndexWhileWriting = Defaults.CREATE_INDEX;
    private boolean createIndex = defaultCreateIndexWhileWriting;
    private static boolean defaultCreateMd5File = Defaults.CREATE_MD5;
    private boolean createMd5File = defaultCreateMd5File;
    private boolean useAsyncIo = Defaults.USE_ASYNC_IO;
    private int asyncOutputBufferSize = 2000;
    private int bufferSize = Defaults.BUFFER_SIZE;
    private File tmpDir;
    private Integer maxRecordsInRam;

    public static void setDefaultCreateMd5File(boolean bl) {
        defaultCreateMd5File = bl;
    }

    public SAMFileWriterFactory setCreateMd5File(boolean bl) {
        this.createMd5File = bl;
        return this;
    }

    public static void setDefaultCreateIndexWhileWriting(boolean bl) {
        defaultCreateIndexWhileWriting = bl;
    }

    public SAMFileWriterFactory setCreateIndex(boolean bl) {
        this.createIndex = bl;
        return this;
    }

    public SAMFileWriterFactory setMaxRecordsInRam(int n) {
        this.maxRecordsInRam = n;
        return this;
    }

    public SAMFileWriterFactory setUseAsyncIo(boolean bl) {
        this.useAsyncIo = bl;
        return this;
    }

    public SAMFileWriterFactory setAsyncOutputBufferSize(int n) {
        this.asyncOutputBufferSize = n;
        return this;
    }

    public SAMFileWriterFactory setBufferSize(int n) {
        this.bufferSize = n;
        return this;
    }

    public SAMFileWriterFactory setTempDirectory(File file) {
        this.tmpDir = file;
        return this;
    }

    public SAMFileWriter makeBAMWriter(SAMFileHeader sAMFileHeader, boolean bl, File file) {
        return this.makeBAMWriter(sAMFileHeader, bl, file, BlockCompressedOutputStream.getDefaultCompressionLevel());
    }

    public SAMFileWriter makeBAMWriter(SAMFileHeader sAMFileHeader, boolean bl, File file, int n) {
        try {
            boolean bl2;
            boolean bl3;
            boolean bl4 = bl3 = this.createMd5File && IOUtil.isRegularPath(file);
            if (this.createMd5File && !bl3) {
                System.err.println("Cannot create MD5 file for BAM because output file is not a regular file: " + file.getAbsolutePath());
            }
            OutputStream outputStream = IOUtil.maybeBufferOutputStream(new FileOutputStream(file, false), this.bufferSize);
            if (bl3) {
                outputStream = new Md5CalculatingOutputStream(outputStream, new File(file.getAbsolutePath() + ".md5"));
            }
            BAMFileWriter bAMFileWriter = new BAMFileWriter(outputStream, file, n);
            boolean bl5 = bl2 = this.createIndex && IOUtil.isRegularPath(file);
            if (this.createIndex && !bl2) {
                System.err.println("Cannot create index for BAM because output file is not a regular file: " + file.getAbsolutePath());
            }
            if (this.tmpDir != null) {
                bAMFileWriter.setTempDirectory(this.tmpDir);
            }
            this.initializeBAMWriter(bAMFileWriter, sAMFileHeader, bl, bl2);
            if (this.useAsyncIo) {
                return new AsyncSAMFileWriter(bAMFileWriter, this.asyncOutputBufferSize);
            }
            return bAMFileWriter;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Error opening file: " + file.getAbsolutePath());
        }
    }

    private void initializeBAMWriter(BAMFileWriter bAMFileWriter, SAMFileHeader sAMFileHeader, boolean bl, boolean bl2) {
        bAMFileWriter.setSortOrder(sAMFileHeader.getSortOrder(), bl);
        if (this.maxRecordsInRam != null) {
            bAMFileWriter.setMaxRecordsInRam(this.maxRecordsInRam);
        }
        bAMFileWriter.setHeader(sAMFileHeader);
        if (bl2 && bAMFileWriter.getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            bAMFileWriter.enableBamIndexConstruction();
        }
    }

    public SAMFileWriter makeSAMWriter(SAMFileHeader sAMFileHeader, boolean bl, File file) {
        try {
            SAMTextWriter sAMTextWriter = this.createMd5File ? new SAMTextWriter(new Md5CalculatingOutputStream(new FileOutputStream(file, false), new File(file.getAbsolutePath() + ".md5"))) : new SAMTextWriter(file);
            sAMTextWriter.setSortOrder(sAMFileHeader.getSortOrder(), bl);
            if (this.maxRecordsInRam != null) {
                sAMTextWriter.setMaxRecordsInRam(this.maxRecordsInRam);
            }
            sAMTextWriter.setHeader(sAMFileHeader);
            if (this.useAsyncIo) {
                return new AsyncSAMFileWriter(sAMTextWriter, this.asyncOutputBufferSize);
            }
            return sAMTextWriter;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Error opening file: " + file.getAbsolutePath());
        }
    }

    public SAMFileWriter makeSAMWriter(SAMFileHeader sAMFileHeader, boolean bl, OutputStream outputStream) {
        return this.initWriter(sAMFileHeader, bl, false, new SAMTextWriter(outputStream));
    }

    public SAMFileWriter makeBAMWriter(SAMFileHeader sAMFileHeader, boolean bl, OutputStream outputStream) {
        return this.initWriter(sAMFileHeader, bl, true, new BAMFileWriter(outputStream, null));
    }

    private SAMFileWriter initWriter(SAMFileHeader sAMFileHeader, boolean bl, boolean bl2, SAMFileWriterImpl sAMFileWriterImpl) {
        sAMFileWriterImpl.setSortOrder(sAMFileHeader.getSortOrder(), bl);
        if (this.maxRecordsInRam != null) {
            sAMFileWriterImpl.setMaxRecordsInRam(this.maxRecordsInRam);
        }
        sAMFileWriterImpl.setHeader(sAMFileHeader);
        if (this.useAsyncIo) {
            return new AsyncSAMFileWriter(sAMFileWriterImpl, this.asyncOutputBufferSize);
        }
        return sAMFileWriterImpl;
    }

    public SAMFileWriter makeSAMOrBAMWriter(SAMFileHeader sAMFileHeader, boolean bl, File file) {
        String string = file.getName();
        if (string.endsWith(".bam")) {
            return this.makeBAMWriter(sAMFileHeader, bl, file);
        }
        if (string.endsWith(".sam")) {
            return this.makeSAMWriter(sAMFileHeader, bl, file);
        }
        return this.makeBAMWriter(sAMFileHeader, bl, file);
    }

    public SAMFileWriter makeWriter(SAMFileHeader sAMFileHeader, boolean bl, File file, File file2) {
        if (file.getName().endsWith(SamReader.Type.CRAM_TYPE.fileExtension())) {
            try {
                return this.makeCRAMWriter(sAMFileHeader, new FileOutputStream(file), file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException(fileNotFoundException);
            }
        }
        return this.makeSAMOrBAMWriter(sAMFileHeader, bl, file);
    }

    public CRAMFileWriter makeCRAMWriter(SAMFileHeader sAMFileHeader, OutputStream outputStream, File file) {
        CRAMFileWriter cRAMFileWriter = new CRAMFileWriter(outputStream, new ReferenceSource(file), sAMFileHeader, null);
        cRAMFileWriter.setPreserveReadNames(true);
        cRAMFileWriter.setCaptureAllTags(true);
        return cRAMFileWriter;
    }
}

