/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractSAMHeaderRecord;
import htsjdk.samtools.util.Iso8601Date;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SAMReadGroupRecord
extends AbstractSAMHeaderRecord {
    private String mReadGroupId = null;
    public static final String READ_GROUP_ID_TAG = "ID";
    public static final String READ_GROUP_SAMPLE_TAG = "SM";
    public static final String PREDICTED_MEDIAN_INSERT_SIZE_TAG = "PI";
    public static final String DATE_RUN_PRODUCED_TAG = "DT";
    public static final String FLOW_ORDER_TAG = "FO";
    public static final String KEY_SEQUENCE_TAG = "KS";
    public static final String DESCRIPTION_TAG = "DS";
    public static final String PLATFORM_UNIT_TAG = "PU";
    public static final String SEQUENCING_CENTER_TAG = "CN";
    public static final String PLATFORM_TAG = "PL";
    public static final String LIBRARY_TAG = "LB";
    public static final Set<String> STANDARD_TAGS = new HashSet<String>(Arrays.asList("ID", "SM", "LB", "DS", "PU", "PI", "CN", "DT", "PL", "FO", "KS"));

    public SAMReadGroupRecord(String string) {
        this.mReadGroupId = string;
    }

    public SAMReadGroupRecord(String string, SAMReadGroupRecord sAMReadGroupRecord) {
        this.mReadGroupId = string;
        for (Map.Entry<String, String> entry : sAMReadGroupRecord.getAttributes()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getId() {
        return this.getReadGroupId();
    }

    public String getReadGroupId() {
        return this.mReadGroupId;
    }

    public String getSample() {
        return this.getAttribute(READ_GROUP_SAMPLE_TAG);
    }

    public void setSample(String string) {
        this.setAttribute(READ_GROUP_SAMPLE_TAG, string);
    }

    public String getLibrary() {
        return this.getAttribute(LIBRARY_TAG);
    }

    public void setLibrary(String string) {
        this.setAttribute(LIBRARY_TAG, string);
    }

    public String getPlatformUnit() {
        return this.getAttribute(PLATFORM_UNIT_TAG);
    }

    public void setPlatformUnit(String string) {
        this.setAttribute(PLATFORM_UNIT_TAG, string);
    }

    public String getPlatform() {
        return this.getAttribute(PLATFORM_TAG);
    }

    public void setPlatform(String string) {
        this.setAttribute(PLATFORM_TAG, string);
    }

    public Date getRunDate() {
        String string = this.getAttribute(DATE_RUN_PRODUCED_TAG);
        if (string == null) {
            return null;
        }
        return new Iso8601Date(string);
    }

    public String getFlowOrder() {
        return this.getAttribute(FLOW_ORDER_TAG);
    }

    public void setFlowOrder(String string) {
        this.setAttribute(FLOW_ORDER_TAG, string);
    }

    public String getKeySequence() {
        return this.getAttribute(KEY_SEQUENCE_TAG);
    }

    public void setKeySequence(String string) {
        this.setAttribute(KEY_SEQUENCE_TAG, string);
    }

    public void setRunDate(Date date) {
        if (date != null && !(date instanceof Iso8601Date)) {
            date = new Iso8601Date(date);
        }
        this.setAttribute(DATE_RUN_PRODUCED_TAG, date != null ? date.toString() : null);
    }

    public String getSequencingCenter() {
        return this.getAttribute(SEQUENCING_CENTER_TAG);
    }

    public void setSequencingCenter(String string) {
        this.setAttribute(SEQUENCING_CENTER_TAG, string);
    }

    public String getDescription() {
        return this.getAttribute(DESCRIPTION_TAG);
    }

    public void setDescription(String string) {
        this.setAttribute(DESCRIPTION_TAG, string);
    }

    public Integer getPredictedMedianInsertSize() {
        String string = this.getAttribute(PREDICTED_MEDIAN_INSERT_SIZE_TAG);
        if (string == null) {
            return null;
        }
        return Integer.parseInt(string);
    }

    public void setPredictedMedianInsertSize(Integer n) {
        this.setAttribute(PREDICTED_MEDIAN_INSERT_SIZE_TAG, n == null ? null : n.toString());
    }

    public boolean equivalent(SAMReadGroupRecord sAMReadGroupRecord) {
        return this.attributesEqual(sAMReadGroupRecord);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SAMReadGroupRecord sAMReadGroupRecord = (SAMReadGroupRecord)object;
        if (!this.attributesEqual(sAMReadGroupRecord)) {
            return false;
        }
        return !(this.mReadGroupId != null ? !this.mReadGroupId.equals(sAMReadGroupRecord.mReadGroupId) : sAMReadGroupRecord.mReadGroupId != null);
    }

    public int hashCode() {
        return this.mReadGroupId.hashCode();
    }

    @Override
    Set<String> getStandardTags() {
        return STANDARD_TAGS;
    }
}

