/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.DuplicateScoringStrategy;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordCoordinateComparator;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public class SAMRecordSetBuilder
implements Iterable<SAMRecord> {
    private static final String[] chroms = new String[]{"chr1", "chr2", "chr3", "chr4", "chr5", "chr6", "chr7", "chr8", "chr9", "chr10", "chr11", "chr12", "chr13", "chr14", "chr15", "chr16", "chr17", "chr18", "chr19", "chr20", "chr21", "chr22", "chrX", "chrY", "chrM"};
    private static final byte[] BASES = new byte[]{65, 67, 71, 84};
    private static final String READ_GROUP_ID = "1";
    private static final String SAMPLE = "FREE_SAMPLE";
    private final Random random = new Random();
    private SAMFileHeader header;
    private final Collection<SAMRecord> records;
    private int readLength = 36;
    private SAMProgramRecord programRecord = null;
    private SAMReadGroupRecord readGroup = null;
    public static final int DEFAULT_CHROMOSOME_LENGTH = 200000000;
    public static final DuplicateScoringStrategy.ScoringStrategy DEFAULT_DUPLICATE_SCORING_STRATEGY = DuplicateScoringStrategy.ScoringStrategy.TOTAL_MAPPED_REFERENCE_LENGTH;

    public SAMRecordSetBuilder() {
        this(true, SAMFileHeader.SortOrder.coordinate);
    }

    public SAMRecordSetBuilder(boolean bl, SAMFileHeader.SortOrder sortOrder) {
        this(bl, sortOrder, true);
    }

    public SAMRecordSetBuilder(boolean bl, SAMFileHeader.SortOrder sortOrder, boolean bl2) {
        this(bl, sortOrder, bl2, 200000000);
    }

    public SAMRecordSetBuilder(boolean bl, SAMFileHeader.SortOrder sortOrder, boolean bl2, int n) {
        this(bl, sortOrder, bl2, n, DEFAULT_DUPLICATE_SCORING_STRATEGY);
    }

    public SAMRecordSetBuilder(boolean bl, SAMFileHeader.SortOrder sortOrder, boolean bl2, int n, DuplicateScoringStrategy.ScoringStrategy scoringStrategy) {
        Object object;
        ArrayList<SAMSequenceRecord> arrayList = new ArrayList<SAMSequenceRecord>();
        for (String string : chroms) {
            SAMSequenceRecord sAMSequenceRecord = new SAMSequenceRecord(string, n);
            arrayList.add(sAMSequenceRecord);
        }
        this.header = new SAMFileHeader();
        this.header.setSequenceDictionary(new SAMSequenceDictionary(arrayList));
        this.header.setSortOrder(sortOrder);
        if (bl) {
            object = sortOrder == SAMFileHeader.SortOrder.queryname ? new SAMRecordQueryNameComparator() : new SAMRecordCoordinateComparator();
            this.records = new TreeSet<SAMRecord>((Comparator<SAMRecord>)object);
        } else {
            this.records = new ArrayList<SAMRecord>();
        }
        if (bl2) {
            object = new SAMReadGroupRecord(READ_GROUP_ID);
            ((SAMReadGroupRecord)object).setSample(SAMPLE);
            ((SAMReadGroupRecord)object).setPlatform("ILLUMINA");
            ArrayList<SAMReadGroupRecord> arrayList2 = new ArrayList<SAMReadGroupRecord>();
            arrayList2.add((SAMReadGroupRecord)object);
            this.header.setReadGroups(arrayList2);
        }
    }

    public int size() {
        return this.records.size();
    }

    public void setRandomSeed(long l) {
        this.random.setSeed(l);
    }

    public void setProgramRecord(SAMProgramRecord sAMProgramRecord) {
        this.programRecord = sAMProgramRecord;
        if (sAMProgramRecord != null) {
            this.header.addProgramRecord(sAMProgramRecord);
        }
    }

    public void setReadGroup(SAMReadGroupRecord sAMReadGroupRecord) {
        this.readGroup = sAMReadGroupRecord;
        if (sAMReadGroupRecord != null) {
            this.header.addReadGroup(sAMReadGroupRecord);
        }
    }

    public Collection<SAMRecord> getRecords() {
        return this.records;
    }

    public void setHeader(SAMFileHeader sAMFileHeader) {
        this.header = sAMFileHeader.clone();
    }

    public void addRecord(SAMRecord sAMRecord) {
        if (sAMRecord.getReadPairedFlag() && !sAMRecord.getMateUnmappedFlag() && null == sAMRecord.getAttribute(SAMTagUtil.getSingleton().MC)) {
            throw new SAMException("Mate Cigar tag (MC) not found in: " + sAMRecord.getReadName());
        }
        this.records.add(sAMRecord);
    }

    @Override
    public CloseableIterator<SAMRecord> iterator() {
        return new CloseableIterator<SAMRecord>(){
            private final Iterator<SAMRecord> iterator;
            {
                this.iterator = SAMRecordSetBuilder.this.records.iterator();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public SAMRecord next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    private SAMRecord createReadNoFlag(String string, int n, int n2, boolean bl, boolean bl2, String string2, String string3, int n3) throws SAMException {
        SAMRecord sAMRecord = new SAMRecord(this.header);
        sAMRecord.setReadName(string);
        if (chroms.length <= n) {
            throw new SAMException("Contig too big [" + chroms.length + " < " + n);
        }
        if (0 <= n) {
            sAMRecord.setReferenceIndex(n);
            sAMRecord.setReferenceName(chroms[n]);
            sAMRecord.setAlignmentStart(n2);
        }
        if (!bl2) {
            sAMRecord.setReadNegativeStrandFlag(bl);
            if (null != string2) {
                sAMRecord.setCigarString(string2);
            } else if (!sAMRecord.getReadUnmappedFlag()) {
                sAMRecord.setCigarString(this.readLength + "M");
            }
            sAMRecord.setMappingQuality(255);
        } else {
            sAMRecord.setReadUnmappedFlag(true);
        }
        sAMRecord.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            sAMRecord.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        if (this.readGroup != null) {
            sAMRecord.setAttribute(SAMTag.RG.name(), (Object)this.readGroup.getReadGroupId());
        }
        this.fillInBasesAndQualities(sAMRecord, string3, n3);
        return sAMRecord;
    }

    public void addFrag(String string, int n, int n2, boolean bl) {
        this.addFrag(string, n, n2, bl, false, null, null, -1);
    }

    public SAMRecord addFrag(String string, int n, int n2, boolean bl, boolean bl2, String string2, String string3, int n3) throws SAMException {
        return this.addFrag(string, n, n2, bl, bl2, string2, string3, n3, false);
    }

    public SAMRecord addFrag(String string, int n, int n2, boolean bl, boolean bl2, String string2, String string3, int n3, boolean bl3) throws SAMException {
        SAMRecord sAMRecord = this.createReadNoFlag(string, n, n2, bl, bl2, string2, string3, n3);
        if (bl3) {
            sAMRecord.setNotPrimaryAlignmentFlag(true);
        }
        this.records.add(sAMRecord);
        return sAMRecord;
    }

    private void fillInBasesAndQualities(SAMRecord sAMRecord, String string, int n) {
        if (null == string) {
            this.fillInBasesAndQualities(sAMRecord, n);
        } else {
            this.fillInBases(sAMRecord);
            sAMRecord.setBaseQualityString(string);
        }
    }

    private void fillInBases(SAMRecord sAMRecord) {
        int n = this.readLength;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = BASES[this.random.nextInt(BASES.length)];
        }
        sAMRecord.setReadBases(byArray);
    }

    public void addUnmappedFragment(String string) {
        this.addFrag(string, -1, -1, false, true, null, null, -1, false);
    }

    public void addPair(String string, int n, int n2, int n3) {
        SAMRecord sAMRecord = new SAMRecord(this.header);
        SAMRecord sAMRecord2 = new SAMRecord(this.header);
        boolean bl = this.random.nextBoolean();
        sAMRecord.setReadName(string);
        sAMRecord.setReferenceIndex(n);
        sAMRecord.setAlignmentStart(n2);
        sAMRecord.setReadNegativeStrandFlag(false);
        sAMRecord.setCigarString(this.readLength + "M");
        sAMRecord.setMappingQuality(255);
        sAMRecord.setReadPairedFlag(true);
        sAMRecord.setProperPairFlag(true);
        sAMRecord.setMateReferenceIndex(n);
        sAMRecord.setAttribute(SAMTag.MC.name(), (Object)(this.readLength + "M"));
        sAMRecord.setMateAlignmentStart(n3);
        sAMRecord.setMateNegativeStrandFlag(true);
        sAMRecord.setFirstOfPairFlag(bl);
        sAMRecord.setSecondOfPairFlag(!bl);
        sAMRecord.setInferredInsertSize(CoordMath.getLength(n2, CoordMath.getEnd(n3, this.readLength)));
        sAMRecord.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            sAMRecord.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        if (this.readGroup != null) {
            sAMRecord.setAttribute(SAMTag.RG.name(), (Object)this.readGroup.getReadGroupId());
        }
        this.fillInBasesAndQualities(sAMRecord);
        sAMRecord2.setReadName(string);
        sAMRecord2.setReferenceIndex(n);
        sAMRecord2.setAlignmentStart(n3);
        sAMRecord2.setReadNegativeStrandFlag(true);
        sAMRecord2.setCigarString(this.readLength + "M");
        sAMRecord2.setMappingQuality(255);
        sAMRecord2.setReadPairedFlag(true);
        sAMRecord2.setProperPairFlag(true);
        sAMRecord2.setMateReferenceIndex(n);
        sAMRecord2.setAttribute(SAMTag.MC.name(), (Object)(this.readLength + "M"));
        sAMRecord2.setMateAlignmentStart(n2);
        sAMRecord2.setMateNegativeStrandFlag(false);
        sAMRecord2.setFirstOfPairFlag(!bl);
        sAMRecord2.setSecondOfPairFlag(bl);
        sAMRecord2.setInferredInsertSize(sAMRecord.getInferredInsertSize());
        sAMRecord2.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            sAMRecord2.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        if (this.readGroup != null) {
            sAMRecord2.setAttribute(SAMTag.RG.name(), (Object)this.readGroup.getReadGroupId());
        }
        this.fillInBasesAndQualities(sAMRecord2);
        this.records.add(sAMRecord);
        this.records.add(sAMRecord2);
    }

    public List<SAMRecord> addPair(String string, int n, int n2, int n3, boolean bl, boolean bl2, String string2, String string3, boolean bl3, boolean bl4, int n4) {
        return this.addPair(string, n, n, n2, n3, bl, bl2, string2, string3, bl3, bl4, false, false, n4);
    }

    public List<SAMRecord> addPair(String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2, String string2, String string3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n5) {
        LinkedList<SAMRecord> linkedList = new LinkedList<SAMRecord>();
        SAMRecord sAMRecord = this.createReadNoFlag(string, n, n3, bl3, bl, string2, null, n5);
        SAMRecord sAMRecord2 = this.createReadNoFlag(string, n2, n4, bl4, bl2, string3, null, n5);
        sAMRecord.setReadPairedFlag(true);
        sAMRecord.setFirstOfPairFlag(true);
        if (!bl && !bl2) {
            sAMRecord.setProperPairFlag(true);
            sAMRecord2.setProperPairFlag(true);
        }
        sAMRecord2.setReadPairedFlag(true);
        sAMRecord2.setSecondOfPairFlag(true);
        if (bl5) {
            sAMRecord.setNotPrimaryAlignmentFlag(true);
        }
        if (bl6) {
            sAMRecord2.setNotPrimaryAlignmentFlag(true);
        }
        if (bl5) {
            sAMRecord.setNotPrimaryAlignmentFlag(true);
        }
        if (bl6) {
            sAMRecord2.setNotPrimaryAlignmentFlag(true);
        }
        SamPairUtil.setMateInfo(sAMRecord, sAMRecord2, true);
        linkedList.add(sAMRecord);
        linkedList.add(sAMRecord2);
        this.records.add(sAMRecord);
        this.records.add(sAMRecord2);
        return linkedList;
    }

    public List<SAMRecord> addPair(String string, int n, int n2, int n3, boolean bl, boolean bl2, String string2, String string3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n4) {
        return this.addPair(string, n, n, n2, n3, bl, bl2, string2, string3, bl3, bl4, bl5, bl6, n4);
    }

    public void addUnmappedPair(String string) {
        SAMRecord sAMRecord = new SAMRecord(this.header);
        SAMRecord sAMRecord2 = new SAMRecord(this.header);
        boolean bl = this.random.nextBoolean();
        sAMRecord.setReadName(string);
        sAMRecord.setReadPairedFlag(false);
        sAMRecord.setReadUnmappedFlag(true);
        sAMRecord.setAttribute(SAMTag.MC.name(), null);
        sAMRecord.setProperPairFlag(false);
        sAMRecord.setFirstOfPairFlag(bl);
        sAMRecord.setSecondOfPairFlag(!bl);
        sAMRecord.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            sAMRecord.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        this.fillInBasesAndQualities(sAMRecord);
        sAMRecord2.setReadName(string);
        sAMRecord2.setReadPairedFlag(false);
        sAMRecord2.setReadUnmappedFlag(true);
        sAMRecord2.setAttribute(SAMTag.MC.name(), null);
        sAMRecord2.setProperPairFlag(false);
        sAMRecord2.setFirstOfPairFlag(!bl);
        sAMRecord2.setSecondOfPairFlag(bl);
        sAMRecord2.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            sAMRecord2.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        this.fillInBasesAndQualities(sAMRecord2);
        this.records.add(sAMRecord);
        this.records.add(sAMRecord2);
    }

    private void fillInBasesAndQualities(SAMRecord sAMRecord) {
        this.fillInBasesAndQualities(sAMRecord, -1);
    }

    private void fillInBasesAndQualities(SAMRecord sAMRecord, int n) {
        int n2 = this.readLength;
        byte[] byArray = new byte[n2];
        if (-1 != n) {
            Arrays.fill(byArray, (byte)n);
        } else {
            for (int i = 0; i < n2; ++i) {
                byArray[i] = (byte)this.random.nextInt(50);
            }
        }
        sAMRecord.setBaseQualities(byArray);
        this.fillInBases(sAMRecord);
    }

    public SamReader getSamReader() {
        File file;
        try {
            file = File.createTempFile("temp", ".sam");
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("problems creating tempfile", iOException);
        }
        this.header.setAttribute("VN", "1.0");
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeBAMWriter(this.header, true, file);
        for (SAMRecord sAMRecord : this.getRecords()) {
            sAMFileWriter.addAlignment(sAMRecord);
        }
        sAMFileWriter.close();
        SamReader samReader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(file);
        file.deleteOnExit();
        return samReader;
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }

    public void setReadLength(int n) {
        this.readLength = n;
    }
}

