/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.build.CompressionHeaderFactory;
import htsjdk.samtools.cram.encoding.writer.DataWriterFactory;
import htsjdk.samtools.cram.encoding.writer.Writer;
import htsjdk.samtools.cram.io.DefaultBitOutputStream;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.BlockCompressionMethod;
import htsjdk.samtools.cram.structure.BlockContentType;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ContainerFactory {
    SAMFileHeader samFileHeader;
    int recordsPerSlice = 10000;
    boolean preserveReadNames = true;
    long globalRecordCounter = 0L;
    boolean AP_delta = true;

    public ContainerFactory(SAMFileHeader sAMFileHeader, int n) {
        this.samFileHeader = sAMFileHeader;
        this.recordsPerSlice = n;
    }

    public Container buildContainer(List<CramCompressionRecord> list) throws IllegalArgumentException, IllegalAccessException, IOException {
        return this.buildContainer(list, null);
    }

    public Container buildContainer(List<CramCompressionRecord> list, SubstitutionMatrix substitutionMatrix) throws IllegalArgumentException, IllegalAccessException, IOException {
        long l = System.nanoTime();
        CompressionHeader compressionHeader = new CompressionHeaderFactory().build(list, substitutionMatrix);
        compressionHeader.AP_seriesDelta = this.AP_delta;
        long l2 = System.nanoTime();
        compressionHeader.readNamesIncluded = this.preserveReadNames;
        compressionHeader.AP_seriesDelta = true;
        ArrayList<Slice> arrayList = new ArrayList<Slice>();
        Container container = new Container();
        container.h = compressionHeader;
        container.nofRecords = list.size();
        container.globalRecordCounter = this.globalRecordCounter;
        container.bases = 0L;
        container.blockCount = 0;
        long l3 = System.nanoTime();
        long l4 = container.globalRecordCounter;
        for (int i = 0; i < list.size(); i += this.recordsPerSlice) {
            List<CramCompressionRecord> list2 = list.subList(i, Math.min(list.size(), i + this.recordsPerSlice));
            Slice slice = ContainerFactory.buildSlice(list2, compressionHeader, this.samFileHeader);
            slice.globalRecordCounter = l4;
            l4 += (long)slice.nofRecords;
            container.bases += slice.bases;
            arrayList.add(slice);
            if (container.sequenceId != -1 || slice.sequenceId == -1) continue;
            container.sequenceId = slice.sequenceId;
        }
        long l5 = System.nanoTime();
        container.slices = arrayList.toArray(new Slice[arrayList.size()]);
        ContainerFactory.calculateAlignmentBoundaries(container);
        container.buildHeaderTime = l2 - l;
        container.buildSlicesTime = l5 - l3;
        this.globalRecordCounter += (long)list.size();
        return container;
    }

    private static void calculateAlignmentBoundaries(Container container) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        for (Slice slice : container.slices) {
            if (slice.sequenceId == -1) continue;
            n = Math.min(n, slice.alignmentStart);
            n2 = Math.max(n2, slice.alignmentStart + slice.alignmentSpan);
        }
        if (n < Integer.MAX_VALUE) {
            container.alignmentStart = n;
            container.alignmentSpan = n2 - n;
        }
    }

    private static Slice buildSlice(List<CramCompressionRecord> list, CompressionHeader compressionHeader, SAMFileHeader sAMFileHeader) throws IllegalArgumentException, IllegalAccessException, IOException {
        HashMap<Integer, ExposedByteArrayOutputStream> hashMap = new HashMap<Integer, ExposedByteArrayOutputStream>();
        Object object = compressionHeader.externalIds.iterator();
        while (object.hasNext()) {
            int n = object.next();
            hashMap.put(n, new ExposedByteArrayOutputStream());
        }
        object = new DataWriterFactory();
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = new ExposedByteArrayOutputStream();
        DefaultBitOutputStream defaultBitOutputStream = new DefaultBitOutputStream(exposedByteArrayOutputStream);
        Slice slice = new Slice();
        slice.nofRecords = list.size();
        slice.sequenceId = -1;
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        for (CramCompressionRecord object2 : list) {
            slice.bases += (long)object2.readLength;
            if (slice.sequenceId == -2 || object2.alignmentStart == 0 || object2.sequenceId == -1) continue;
            switch (slice.sequenceId) {
                case -1: {
                    slice.sequenceId = object2.sequenceId;
                    break;
                }
                case -2: {
                    break;
                }
                default: {
                    if (slice.sequenceId == object2.sequenceId) break;
                    slice.sequenceId = -1;
                }
            }
            n = Math.min(object2.alignmentStart, n);
            n2 = Math.max(object2.getAlignmentEnd(), n2);
        }
        if (slice.sequenceId == -2 || n == Integer.MAX_VALUE) {
            slice.alignmentStart = 0;
            slice.alignmentSpan = 0;
        } else {
            slice.alignmentStart = n;
            slice.alignmentSpan = n2 - n + 1;
        }
        Writer writer = ((DataWriterFactory)object).buildWriter(defaultBitOutputStream, hashMap, compressionHeader, slice.sequenceId);
        n2 = slice.alignmentStart;
        for (CramCompressionRecord cramCompressionRecord : list) {
            cramCompressionRecord.alignmentDelta = cramCompressionRecord.alignmentStart - n2;
            n2 = cramCompressionRecord.alignmentStart;
            writer.write(cramCompressionRecord);
        }
        slice.contentType = slice.alignmentSpan > -1 ? BlockContentType.MAPPED_SLICE : BlockContentType.RESERVED;
        defaultBitOutputStream.close();
        slice.coreBlock = new Block();
        slice.coreBlock.method = BlockCompressionMethod.RAW;
        slice.coreBlock.setRawContent(exposedByteArrayOutputStream.toByteArray());
        slice.coreBlock.contentType = BlockContentType.CORE;
        slice.external = new HashMap<Integer, Block>();
        for (Integer n3 : hashMap.keySet()) {
            ExposedByteArrayOutputStream exposedByteArrayOutputStream2 = (ExposedByteArrayOutputStream)hashMap.get(n3);
            Block block = new Block();
            block.contentType = BlockContentType.EXTERNAL;
            block.method = BlockCompressionMethod.GZIP;
            block.contentId = n3;
            block.setRawContent(exposedByteArrayOutputStream2.toByteArray());
            slice.external.put(n3, block);
        }
        return slice;
    }

    public boolean isPreserveReadNames() {
        return this.preserveReadNames;
    }

    public void setPreserveReadNames(boolean bl) {
        this.preserveReadNames = bl;
    }
}

