/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.encoding.reader.DataReaderFactory;
import htsjdk.samtools.cram.io.DefaultBitInputStream;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.Log;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ContainerParser {
    private static Log log = Log.getInstance(ContainerParser.class);
    private SAMFileHeader samFileHeader;
    private Map<String, Long> nanoMap = new TreeMap<String, Long>();

    public ContainerParser(SAMFileHeader sAMFileHeader) {
        this.samFileHeader = sAMFileHeader;
    }

    public List<CramCompressionRecord> getRecords(Container container, ArrayList<CramCompressionRecord> arrayList) throws IllegalArgumentException, IllegalAccessException, IOException {
        long l = System.nanoTime();
        if (arrayList == null) {
            arrayList = new ArrayList(container.nofRecords);
        }
        for (Slice object : container.slices) {
            arrayList.addAll(this.getRecords(object, container.h));
        }
        long l2 = System.nanoTime();
        container.parseTime = l2 - l;
        if (log.isEnabled(Log.LogLevel.DEBUG)) {
            for (String string : this.nanoMap.keySet()) {
                log.debug(String.format("%s: %dms.", string, this.nanoMap.get(string) / 1000000L));
            }
        }
        return arrayList;
    }

    public List<CramCompressionRecord> getRecords(Slice slice, CompressionHeader compressionHeader) throws IllegalArgumentException, IllegalAccessException, IOException {
        Object object;
        String string = "*";
        switch (slice.sequenceId) {
            case -1: {
                break;
            }
            case -2: {
                break;
            }
            default: {
                object = this.samFileHeader.getSequence(slice.sequenceId);
                string = ((SAMSequenceRecord)object).getSequenceName();
            }
        }
        object = new DataReaderFactory();
        HashMap<Integer, InputStream> hashMap = new HashMap<Integer, InputStream>();
        for (Integer n : slice.external.keySet()) {
            hashMap.put(n, new ByteArrayInputStream(slice.external.get(n).getRawContent()));
        }
        long l = 0L;
        CramRecordReader cramRecordReader = new CramRecordReader();
        ((DataReaderFactory)object).buildReader(cramRecordReader, new DefaultBitInputStream(new ByteArrayInputStream(slice.coreBlock.getRawContent())), hashMap, compressionHeader, slice.sequenceId);
        ArrayList<CramCompressionRecord> arrayList = new ArrayList<CramCompressionRecord>();
        long l2 = 0L;
        int n = slice.alignmentStart;
        for (int i = 0; i < slice.nofRecords; ++i) {
            String string2;
            CramCompressionRecord cramCompressionRecord = new CramCompressionRecord();
            cramCompressionRecord.sliceIndex = slice.index;
            cramCompressionRecord.index = i;
            try {
                l = System.nanoTime();
                cramRecordReader.read(cramCompressionRecord);
                l2 += System.nanoTime() - l;
            }
            catch (EOFException eOFException) {
                eOFException.printStackTrace();
                throw eOFException;
            }
            cramCompressionRecord.sequenceName = cramCompressionRecord.sequenceId == slice.sequenceId ? string : (cramCompressionRecord.sequenceId == -1 ? "*" : (string2 = this.samFileHeader.getSequence(cramCompressionRecord.sequenceId).getSequenceName()));
            arrayList.add(cramCompressionRecord);
            if (!compressionHeader.AP_seriesDelta) continue;
            cramCompressionRecord.alignmentStart = n += cramCompressionRecord.alignmentDelta;
        }
        log.debug("Slice records read time: " + l2 / 1000000L);
        Map<String, DataReaderFactory.DataReaderWithStats> map = ((DataReaderFactory)object).getStats(cramRecordReader);
        for (String string2 : map.keySet()) {
            long l3 = 0L;
            if (!this.nanoMap.containsKey(string2)) {
                this.nanoMap.put(string2, 0L);
                l3 = 0L;
            } else {
                l3 = this.nanoMap.get(string2);
            }
            this.nanoMap.put(string2, l3 + map.get((Object)string2).nanos);
        }
        return arrayList;
    }
}

