/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.BlockCompressionMethod;
import htsjdk.samtools.cram.structure.BlockContentType;
import htsjdk.samtools.cram.structure.CompressionHeaderBLock;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerHeaderIO;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.SliceIO;
import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableFTPStream;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableHTTPStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.seekablestream.UserPasswordInput;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;

public class CramIO {
    public static int DEFINITION_LENGTH = 26;
    private static Log log = Log.getInstance(CramIO.class);
    public static byte[] ZERO_B_EOF_MARKER = ByteBufferUtils.bytesFromHex("0b 00 00 00 ff ff ff ff ff e0 45 4f 46 00 00 00 00 01 00 00 01 00 06 06 01 00 01 00 01 00");

    public static String getFileName(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
            return new File(uRL.getFile()).getName();
        }
        catch (MalformedURLException malformedURLException) {
            return new File(string).getName();
        }
    }

    public static InputStream openInputStreamFromURL(String string) throws SocketException, IOException, URISyntaxException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            return new SeekableBufferedStream(new SeekableFileStream(file));
        }
        String string2 = uRL.getProtocol();
        if ("ftp".equalsIgnoreCase(string2)) {
            return new SeekableBufferedStream(new NamedSeekableFTPStream(uRL));
        }
        if ("http".equalsIgnoreCase(string2)) {
            return new SeekableBufferedStream(new SeekableHTTPStream(uRL));
        }
        if ("file".equalsIgnoreCase(string2)) {
            File file = new File(uRL.toURI());
            return new SeekableBufferedStream(new SeekableFileStream(file));
        }
        throw new RuntimeException("Uknown protocol: " + string2);
    }

    public static InputStream openCramInputStream(String string, boolean bl, String string2) throws IOException, URISyntaxException {
        InputStream inputStream = null;
        inputStream = string == null ? new BufferedInputStream(System.in) : CramIO.openInputStreamFromURL(string);
        if (bl) {
            throw new SAMException("Encryption not supported in this version.");
        }
        if (inputStream instanceof SeekableStream) {
            CramHeader cramHeader = CramIO.readFormatDefinition(inputStream, new CramHeader());
            SeekableStream seekableStream = (SeekableStream)inputStream;
            if (!CramIO.hasZeroB_EOF_marker(seekableStream)) {
                CramIO.eofNotFound(cramHeader.getMajorVersion(), cramHeader.getMinorVersion());
            }
            seekableStream.seek(0L);
        } else {
            log.warn("CRAM file/stream completion cannot be verified.");
        }
        return inputStream;
    }

    private static void eofNotFound(byte by, byte by2) {
        if (by >= 2 && by2 >= 1) {
            log.error("Incomplete data: EOF marker not found.");
            System.exit(1);
        } else {
            log.warn("EOF marker not found, possibly incomplete file/stream.");
        }
    }

    public static Container readContainer(CramHeader cramHeader, InputStream inputStream) throws IOException {
        Container container = CramIO.readContainer(inputStream);
        if (container == null) {
            CramIO.eofNotFound(cramHeader.getMajorVersion(), cramHeader.getMinorVersion());
            return CramIO.readContainer(new ByteArrayInputStream(ZERO_B_EOF_MARKER));
        }
        if (container.isEOF()) {
            log.debug("EOF marker found, file/stream is complete.");
        }
        return container;
    }

    public static long issueZeroB_EOF_marker(OutputStream outputStream) throws IOException {
        outputStream.write(ZERO_B_EOF_MARKER);
        return ZERO_B_EOF_MARKER.length;
    }

    public static boolean hasZeroB_EOF_marker(SeekableStream seekableStream) throws IOException {
        byte[] byArray = new byte[ZERO_B_EOF_MARKER.length];
        seekableStream.seek(seekableStream.length() - (long)ZERO_B_EOF_MARKER.length);
        ByteBufferUtils.readFully(byArray, seekableStream);
        byArray[8] = (byte)(byArray[8] | 0xF0);
        return Arrays.equals(byArray, ZERO_B_EOF_MARKER);
    }

    public static boolean hasZeroB_EOF_marker(File file) throws IOException {
        byte[] byArray = new byte[ZERO_B_EOF_MARKER.length];
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        try {
            randomAccessFile.seek(file.length() - (long)ZERO_B_EOF_MARKER.length);
            randomAccessFile.readFully(byArray);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            randomAccessFile.close();
        }
        byArray[8] = (byte)(byArray[8] | 0xF0);
        return Arrays.equals(byArray, ZERO_B_EOF_MARKER);
    }

    public static long writeCramHeader(CramHeader cramHeader, OutputStream outputStream) throws IOException {
        outputStream.write("CRAM".getBytes("US-ASCII"));
        outputStream.write(cramHeader.getMajorVersion());
        outputStream.write(cramHeader.getMinorVersion());
        outputStream.write(cramHeader.id);
        for (int i = cramHeader.id.length; i < 20; ++i) {
            outputStream.write(0);
        }
        long l = CramIO.writeContainerForSamFileHeader(cramHeader.getSamFileHeader(), outputStream);
        return (long)DEFINITION_LENGTH + l;
    }

    private static CramHeader readFormatDefinition(InputStream inputStream, CramHeader cramHeader) throws IOException {
        for (byte by : CramHeader.magick) {
            if (by == inputStream.read()) continue;
            throw new RuntimeException("Unknown file format.");
        }
        cramHeader.setMajorVersion((byte)inputStream.read());
        cramHeader.setMinorVersion((byte)inputStream.read());
        Object object = new DataInputStream(inputStream);
        ((DataInputStream)object).readFully(cramHeader.id);
        return cramHeader;
    }

    public static CramHeader readCramHeader(InputStream inputStream) throws IOException {
        CramHeader cramHeader = new CramHeader();
        CramIO.readFormatDefinition(inputStream, cramHeader);
        cramHeader.setSamFileHeader(CramIO.readSAMFileHeader(new String(cramHeader.id), inputStream));
        return cramHeader;
    }

    public static int writeContainer(Container container, OutputStream outputStream) throws IOException {
        int n;
        long l = System.nanoTime();
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = new ExposedByteArrayOutputStream();
        CompressionHeaderBLock compressionHeaderBLock = new CompressionHeaderBLock(container.h);
        compressionHeaderBLock.write(exposedByteArrayOutputStream);
        container.blockCount = 1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        SliceIO sliceIO = new SliceIO();
        for (n = 0; n < container.slices.length; ++n) {
            Slice slice = container.slices[n];
            arrayList.add(exposedByteArrayOutputStream.size());
            sliceIO.write(slice, exposedByteArrayOutputStream);
            ++container.blockCount;
            ++container.blockCount;
            if (slice.embeddedRefBlock != null) {
                ++container.blockCount;
            }
            container.blockCount += slice.external.size();
        }
        container.landmarks = new int[arrayList.size()];
        for (n = 0; n < container.landmarks.length; ++n) {
            container.landmarks[n] = (Integer)arrayList.get(n);
        }
        container.containerByteSize = exposedByteArrayOutputStream.size();
        CramIO.calculateSliceOffsetsAndSizes(container);
        ContainerHeaderIO containerHeaderIO = new ContainerHeaderIO();
        int n2 = containerHeaderIO.writeContainerHeader(container, outputStream);
        outputStream.write(exposedByteArrayOutputStream.getBuffer(), 0, exposedByteArrayOutputStream.size());
        long l2 = System.nanoTime();
        log.debug("CONTAINER WRITTEN: " + container.toString());
        container.writeTime = l2 - l;
        return n2 += exposedByteArrayOutputStream.size();
    }

    public static Container readContainer(InputStream inputStream) throws IOException {
        return CramIO.readContainer(inputStream, 0, Integer.MAX_VALUE);
    }

    public static Container readContainerHeader(InputStream inputStream) throws IOException {
        ContainerHeaderIO containerHeaderIO = new ContainerHeaderIO();
        Container container = new Container();
        if (!containerHeaderIO.readContainerHeader(container, inputStream)) {
            return null;
        }
        return container;
    }

    private static Container readContainer(InputStream inputStream, int n, int n2) throws IOException {
        long l = System.nanoTime();
        Container container = CramIO.readContainerHeader(inputStream);
        if (container == null) {
            return null;
        }
        CompressionHeaderBLock compressionHeaderBLock = new CompressionHeaderBLock(inputStream);
        container.h = compressionHeaderBLock.getCompressionHeader();
        n2 = Math.min(container.landmarks.length, n2);
        if (n > 0) {
            inputStream.skip(container.landmarks[n]);
        }
        SliceIO sliceIO = new SliceIO();
        ArrayList<Slice> arrayList = new ArrayList<Slice>();
        int n3 = n;
        while (n3 < n2 - n) {
            Slice slice = new Slice();
            slice.index = n3++;
            sliceIO.readSliceHeadBlock(slice, inputStream);
            sliceIO.readSliceBlocks(slice, true, inputStream);
            arrayList.add(slice);
        }
        container.slices = arrayList.toArray(new Slice[arrayList.size()]);
        CramIO.calculateSliceOffsetsAndSizes(container);
        long l2 = System.nanoTime();
        log.debug("READ CONTAINER: " + container.toString());
        container.readTime = l2 - l;
        return container;
    }

    private static void calculateSliceOffsetsAndSizes(Container container) {
        if (container.slices.length == 0) {
            return;
        }
        for (int i = 0; i < container.slices.length - 1; ++i) {
            Slice slice = container.slices[i];
            slice.offset = container.landmarks[i];
            slice.size = container.landmarks[i + 1] - slice.offset;
        }
        Slice slice = container.slices[container.slices.length - 1];
        slice.offset = container.landmarks[container.landmarks.length - 1];
        slice.size = container.containerByteSize - slice.offset;
    }

    public static byte[] toByteArray(SAMFileHeader sAMFileHeader) {
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = new ExposedByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(exposedByteArrayOutputStream);
        new SAMTextHeaderCodec().encode(outputStreamWriter, sAMFileHeader);
        try {
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(exposedByteArrayOutputStream.size());
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(exposedByteArrayOutputStream.getBuffer(), 0, exposedByteArrayOutputStream.size());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static long writeContainerForSamFileHeader(SAMFileHeader sAMFileHeader, OutputStream outputStream) throws IOException {
        byte[] byArray = CramIO.toByteArray(sAMFileHeader);
        return CramIO.writeContainerForSamFileHeaderData(byArray, 0, Math.max(1024, byArray.length + byArray.length / 2), outputStream);
    }

    private static long writeContainerForSamFileHeaderData(byte[] byArray, int n, int n2, OutputStream outputStream) throws IOException {
        Block block = new Block();
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, n, Math.min(byArray.length - n, n2));
        block.setRawContent(byArray2);
        block.method = BlockCompressionMethod.RAW;
        block.contentId = 0;
        block.contentType = BlockContentType.FILE_HEADER;
        block.compress();
        Container container = new Container();
        container.blockCount = 1;
        container.blocks = new Block[]{block};
        container.landmarks = new int[0];
        container.slices = new Slice[0];
        container.alignmentSpan = 0;
        container.alignmentStart = 0;
        container.bases = 0L;
        container.globalRecordCounter = 0L;
        container.nofRecords = 0;
        container.sequenceId = 0;
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = new ExposedByteArrayOutputStream();
        block.write(exposedByteArrayOutputStream);
        container.containerByteSize = exposedByteArrayOutputStream.size();
        ContainerHeaderIO containerHeaderIO = new ContainerHeaderIO();
        int n3 = containerHeaderIO.writeContainerHeader(container, outputStream);
        outputStream.write(exposedByteArrayOutputStream.getBuffer(), 0, exposedByteArrayOutputStream.size());
        return n3 + exposedByteArrayOutputStream.size();
    }

    public static SAMFileHeader readSAMFileHeader(String string, InputStream inputStream) throws IOException {
        int n;
        CramIO.readContainerHeader(inputStream);
        Block block = new Block(inputStream, true, true);
        inputStream = new ByteArrayInputStream(block.getRawContent());
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        for (n = 0; n < 4; ++n) {
            byteBuffer.put((byte)inputStream.read());
        }
        byteBuffer.flip();
        n = byteBuffer.asIntBuffer().get();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        BufferedLineReader bufferedLineReader = new BufferedLineReader(new ByteArrayInputStream(byArray));
        SAMTextHeaderCodec sAMTextHeaderCodec = new SAMTextHeaderCodec();
        SAMFileHeader sAMFileHeader = sAMTextHeaderCodec.decode(bufferedLineReader, string);
        return sAMFileHeader;
    }

    public static boolean replaceCramHeader(File file, CramHeader cramHeader) throws IOException {
        int n = (int)Math.min(0x100000L, file.length());
        FileInputStream fileInputStream = new FileInputStream(file);
        CountingInputStream countingInputStream = new CountingInputStream(fileInputStream);
        CramHeader cramHeader2 = new CramHeader();
        CramIO.readFormatDefinition(countingInputStream, cramHeader2);
        if (cramHeader2.getMajorVersion() != cramHeader.getMajorVersion() && cramHeader2.getMinorVersion() != cramHeader.getMinorVersion()) {
            log.error(String.format("Cannot replace CRAM header because format versions differ: ", cramHeader2.getMajorVersion(), cramHeader2.getMinorVersion(), cramHeader.getMajorVersion(), cramHeader2.getMinorVersion(), file.getAbsolutePath()));
            countingInputStream.close();
            return false;
        }
        CramIO.readContainerHeader(countingInputStream);
        Block block = new Block(countingInputStream, false, false);
        long l = countingInputStream.getCount();
        countingInputStream.close();
        byte[] byArray = CramIO.toByteArray(cramHeader.getSamFileHeader());
        if (byArray.length > block.getRawContentSize()) {
            log.error("Failed to replace CRAM header because the new header is bigger.");
            return false;
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        FileChannel fileChannel = randomAccessFile.getChannel();
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, l, (long)n - l);
        mappedByteBuffer.put(byArray);
        mappedByteBuffer.force();
        fileChannel.close();
        randomAccessFile.close();
        return true;
    }

    private static class NamedSeekableFTPStream
    extends SeekableFTPStream {
        private URL source;

        public NamedSeekableFTPStream(URL uRL) throws IOException {
            super(uRL);
            this.source = uRL;
        }

        public NamedSeekableFTPStream(URL uRL, UserPasswordInput userPasswordInput) throws IOException {
            super(uRL, userPasswordInput);
            this.source = uRL;
        }

        @Override
        public String getSource() {
            return this.source.toString();
        }
    }
}

