/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

public class BetaIntegerCodec
extends AbstractBitCodec<Integer> {
    private int offset = 0;
    private int readNofBits;

    public BetaIntegerCodec(int n, int n2) {
        this.offset = n;
        this.readNofBits = n2;
    }

    @Override
    public final Integer read(BitInputStream bitInputStream) throws IOException {
        return bitInputStream.readBits(this.readNofBits) - this.offset;
    }

    @Override
    public final long write(BitOutputStream bitOutputStream, Integer n) throws IOException {
        int n2 = (int)this.numberOfBits(n);
        long l = n + this.offset;
        bitOutputStream.write(l, n2);
        return n2;
    }

    @Override
    public final long numberOfBits(Integer n) {
        if ((long)n.intValue() > 1L << this.readNofBits) {
            throw new IllegalArgumentException("Value written is bigger then allowed: value=" + n + ", max nof bits=" + this.readNofBits);
        }
        return this.readNofBits;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getReadNofBits() {
        return this.readNofBits;
    }

    public void setReadNofBits(int n) {
        this.readNofBits = n;
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int n) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

