/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CanonicalHuffmanByteCodec
extends AbstractBitCodec<Byte> {
    private TreeMap<Byte, HuffmanBitCode> codes;
    private HuffmanBitCode[] bitCodes = new HuffmanBitCode[256];
    private Integer[] codeLentghSorted;
    private Map<Integer, Map<Long, Byte>> codeCache = new HashMap<Integer, Map<Long, Byte>>();
    private Map<Long, Byte>[] codeMaps;

    public CanonicalHuffmanByteCodec(byte[] byArray, int[] nArray) {
        int n;
        int n2;
        TreeMap treeMap = new TreeMap();
        for (n2 = 0; n2 < byArray.length; ++n2) {
            if (treeMap.containsKey(nArray[n2])) {
                ((TreeSet)treeMap.get(nArray[n2])).add(byArray[n2]);
                continue;
            }
            TreeSet<Byte> treeSet = new TreeSet<Byte>();
            treeSet.add(byArray[n2]);
            treeMap.put(nArray[n2], treeSet);
        }
        this.codeLentghSorted = new Integer[treeMap.size()];
        n2 = 0;
        int n3 = 0;
        int n4 = -1;
        this.codes = new TreeMap();
        Set set = treeMap.keySet();
        for (Object k : set) {
            n = Integer.parseInt(k.toString());
            this.codeLentghSorted[n2++] = n;
            TreeSet treeSet = (TreeSet)treeMap.get(k);
            for (Byte by : treeSet) {
                HuffmanBitCode huffmanBitCode = new HuffmanBitCode();
                huffmanBitCode.bitLentgh = n;
                huffmanBitCode.value = by.byteValue();
                ++n4;
                int n5 = n - n3;
                huffmanBitCode.bitCode = n4 <<= n5;
                n3 += n5;
                if (this.NumberOfSetBits(n4) > n) {
                    throw new IllegalArgumentException("Symbol out of range");
                }
                this.bitCodes[by.byteValue() & 0xFF] = huffmanBitCode;
                this.codes.put(by, huffmanBitCode);
                Map<Long, Byte> map = this.codeCache.get(huffmanBitCode.bitLentgh);
                if (map == null) {
                    map = new HashMap<Long, Byte>();
                    this.codeCache.put(huffmanBitCode.bitLentgh, map);
                }
                map.put(new Long(huffmanBitCode.bitCode), (byte)(0xFF & huffmanBitCode.value));
            }
        }
        this.codeMaps = this.codeLentghSorted.length > 0 ? new Map[this.codeLentghSorted[this.codeLentghSorted.length - 1] + 1] : new Map[1];
        Integer[] integerArray = this.codeLentghSorted;
        int n6 = integerArray.length;
        for (n = 0; n < n6; ++n) {
            int n7 = integerArray[n];
            this.codeMaps[n7] = this.codeCache.get(n7);
        }
    }

    @Override
    public Byte read(BitInputStream bitInputStream) throws IOException {
        long l = 0L;
        int n = 0;
        Integer[] integerArray = this.codeLentghSorted;
        int n2 = integerArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = integerArray[i];
            l <<= n3 - n;
            long l2 = bitInputStream.readLongBits(n3 - n);
            n = n3;
            Map<Long, Byte> map = this.codeMaps[n3];
            Byte by = map.get(l |= l2);
            if (by == null) continue;
            return by;
        }
        throw new RuntimeException("Bit code not found. Current state: " + n + " bits read, buf=" + l);
    }

    @Override
    public long write(BitOutputStream bitOutputStream, Byte by) throws IOException {
        HuffmanBitCode huffmanBitCode = this.bitCodes[by];
        if (huffmanBitCode == null) {
            throw new RuntimeException("Huffman code not found for value: " + by);
        }
        bitOutputStream.write(huffmanBitCode.bitCode, huffmanBitCode.bitLentgh);
        return huffmanBitCode.bitLentgh;
    }

    @Override
    public long numberOfBits(Byte by) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private int NumberOfSetBits(int n) {
        n -= n >> 1 & 0x55555555;
        n = (n & 0x33333333) + (n >> 2 & 0x33333333);
        return (n + (n >> 4) & 0xF0F0F0F) * 0x1010101 >> 24;
    }

    @Override
    public Byte read(BitInputStream bitInputStream, int n) throws IOException {
        throw new RuntimeException("Not implemented");
    }

    private static class HuffmanBitCode {
        int bitCode;
        int bitLentgh;
        int value;

        private HuffmanBitCode() {
        }
    }
}

