/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.BitwiseUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExternalByteCodec
extends AbstractBitCodec<Byte> {
    private OutputStream os;
    private InputStream is;

    public ExternalByteCodec(OutputStream outputStream, InputStream inputStream) {
        this.os = outputStream;
        this.is = inputStream;
    }

    @Override
    public Byte read(BitInputStream bitInputStream) throws IOException {
        return (byte)this.is.read();
    }

    @Override
    public long write(BitOutputStream bitOutputStream, Byte by) throws IOException {
        this.os.write(by.byteValue());
        return 8L;
    }

    @Override
    public long numberOfBits(Byte by) {
        return 8L;
    }

    @Override
    public Byte read(BitInputStream bitInputStream, int n) throws IOException {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void readInto(BitInputStream bitInputStream, byte[] byArray, int n, int n2) throws IOException {
        BitwiseUtils.readFully(this.is, byArray, n, n2);
    }
}

