/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExternalIntegerCodec
extends AbstractBitCodec<Integer> {
    private OutputStream os;
    private InputStream is;
    private OutputStream nullOS = new OutputStream(){

        @Override
        public void write(byte[] byArray) throws IOException {
        }

        @Override
        public void write(int n) throws IOException {
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
        }
    };

    public ExternalIntegerCodec(OutputStream outputStream, InputStream inputStream) {
        this.os = outputStream;
        this.is = inputStream;
    }

    @Override
    public Integer read(BitInputStream bitInputStream) throws IOException {
        return ByteBufferUtils.readUnsignedITF8(this.is);
    }

    @Override
    public long write(BitOutputStream bitOutputStream, Integer n) throws IOException {
        return ByteBufferUtils.writeUnsignedITF8((int)n, this.os);
    }

    @Override
    public long numberOfBits(Integer n) {
        try {
            return ByteBufferUtils.writeUnsignedITF8((int)n, this.nullOS);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int n) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

