/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExternalLongCodec
extends AbstractBitCodec<Long> {
    private OutputStream os;
    private InputStream is;

    public ExternalLongCodec(OutputStream outputStream, InputStream inputStream) {
        this.os = outputStream;
        this.is = inputStream;
    }

    @Override
    public Long read(BitInputStream bitInputStream) throws IOException {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l <<= 8;
            l |= (long)this.is.read();
        }
        return l;
    }

    @Override
    public long write(BitOutputStream bitOutputStream, Long l) throws IOException {
        for (int i = 0; i < 8; ++i) {
            this.os.write((int)(l & 0xFFL));
            l = l >>> 8;
        }
        return 64L;
    }

    @Override
    public long numberOfBits(Long l) {
        return 8L;
    }

    @Override
    public Long read(BitInputStream bitInputStream, int n) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

