/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

public class GolombIntegerCodec
extends AbstractBitCodec<Integer> {
    private int m;
    private boolean quotientBit = true;
    private int offset = 0;

    public GolombIntegerCodec(int n) {
        this(n, true, 0);
    }

    public GolombIntegerCodec(int n, boolean bl, Integer n2) {
        if (n < 2) {
            throw new IllegalArgumentException("M parameter must be at least 2.");
        }
        this.m = n;
        this.quotientBit = bl;
        this.offset = n2;
    }

    @Override
    public final Integer read(BitInputStream bitInputStream) throws IOException {
        int n = 0;
        while (bitInputStream.readBit() == this.quotientBit) {
            ++n;
        }
        int n2 = (int)(Math.log(this.m) / Math.log(2.0) + 1.0);
        int n3 = bitInputStream.readBits(n2 - 1);
        if ((double)n3 >= Math.pow(2.0, n2) - (double)this.m) {
            n3 <<= 1;
            n3 |= bitInputStream.readBits(1);
            n3 = (int)((double)n3 - (Math.pow(2.0, n2) - (double)this.m));
        }
        return n * this.m + n3 - this.offset;
    }

    @Override
    public final long write(BitOutputStream bitOutputStream, Integer n) throws IOException {
        int n2 = n + this.offset;
        int n3 = n2 / this.m;
        int n4 = n2 % this.m;
        int n5 = (int)(Math.log(this.m) / Math.log(2.0) + 1.0);
        int n6 = n3 + 1;
        bitOutputStream.write(this.quotientBit, (long)n3);
        bitOutputStream.write(!this.quotientBit);
        if ((double)n4 < Math.pow(2.0, n5) - (double)this.m) {
            bitOutputStream.write(n4, n5 - 1);
            n6 += n5 - 1;
        } else {
            bitOutputStream.write((int)((double)n4 + Math.pow(2.0, n5) - (double)this.m), n5);
            n6 += n5;
        }
        return n6;
    }

    @Override
    public final long numberOfBits(Integer n) {
        int n2 = n + this.offset;
        int n3 = n2 / this.m;
        int n4 = n2 % this.m;
        int n5 = (int)(Math.log(this.m) / Math.log(2.0) + 1.0);
        int n6 = n3 + 1;
        n6 = (double)n4 < Math.pow(2.0, n5) - (double)this.m ? (n6 += n5 - 1) : (n6 += n5);
        return n6;
    }

    public long getM() {
        return this.m;
    }

    public boolean isQuotientBit() {
        return this.quotientBit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setM(int n) {
        this.m = n;
    }

    public void setQuotientBit(boolean bl) {
        this.quotientBit = bl;
    }

    public void setOffset(Integer n) {
        this.offset = n;
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int n) throws IOException {
        throw new RuntimeException("Multi-value read method not defined.");
    }
}

