/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

public class GolombLongCodec
extends AbstractBitCodec<Long> {
    private int m;
    private boolean quotientBit = true;
    private long offset = 0L;

    public GolombLongCodec(int n) {
        this(0L, n, true);
    }

    public GolombLongCodec(long l, int n) {
        this(l, n, true);
    }

    public GolombLongCodec(long l, int n, boolean bl) {
        if (n < 2) {
            throw new IllegalArgumentException("M parameter must be at least 2.");
        }
        this.m = n;
        this.quotientBit = bl;
        this.offset = l;
    }

    @Override
    public final Long read(BitInputStream bitInputStream) throws IOException {
        long l = 0L;
        while (bitInputStream.readBit() == this.quotientBit) {
            ++l;
        }
        long l2 = (long)(Math.log(this.m) / Math.log(2.0) + 1.0);
        long l3 = bitInputStream.readBits((int)(l2 - 1L));
        if ((double)l3 >= Math.pow(2.0, l2) - (double)this.m) {
            l3 <<= 1;
            l3 |= (long)bitInputStream.readBits(1);
            l3 = (long)((double)l3 - (Math.pow(2.0, l2) - (double)this.m));
        }
        return l * (long)this.m + l3 - this.offset;
    }

    @Override
    public final long write(BitOutputStream bitOutputStream, Long l) throws IOException {
        long l2 = l + this.offset;
        long l3 = l2 / (long)this.m;
        long l4 = l2 % (long)this.m;
        long l5 = (long)(Math.log(this.m) / Math.log(2.0) + 1.0);
        long l6 = l3 + 1L;
        bitOutputStream.write(this.quotientBit, l3);
        bitOutputStream.write(!this.quotientBit);
        if ((double)l4 < Math.pow(2.0, l5) - (double)this.m) {
            bitOutputStream.write(l4, (int)l5 - 1);
            l6 += l5 - 1L;
        } else {
            bitOutputStream.write((int)((double)l4 + Math.pow(2.0, l5) - (double)this.m), (int)l5);
            l6 += l5;
        }
        return l6;
    }

    @Override
    public final long numberOfBits(Long l) {
        long l2 = l + this.offset;
        long l3 = l2 / (long)this.m;
        long l4 = l2 % (long)this.m;
        long l5 = (long)(Math.log(this.m) / Math.log(2.0) + 1.0);
        long l6 = l3 + 1L;
        l6 = (double)l4 < Math.pow(2.0, l5) - (double)this.m ? (l6 += l5 - 1L) : (l6 += l5);
        return l6;
    }

    public int getM() {
        return this.m;
    }

    public boolean isQuotientBit() {
        return this.quotientBit;
    }

    public Long getOffset() {
        return this.offset;
    }

    public void setM(int n) {
        this.m = n;
    }

    public void setQuotientBit(boolean bl) {
        this.quotientBit = bl;
    }

    public void setOffset(Long l) {
        this.offset = l;
    }

    @Override
    public Long read(BitInputStream bitInputStream, int n) throws IOException {
        throw new RuntimeException("Multi-value read method not defined.");
    }
}

