/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.huffint.CanonicalHuffmanByteCodec2;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class HuffmanByteEncoding
implements Encoding<Byte> {
    public static final EncodingID ENCODING_ID = EncodingID.HUFFMAN;
    private int[] bitLengths;
    private byte[] values;
    private ByteBuffer buf = ByteBuffer.allocate(1024);

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    @Override
    public byte[] toByteArray() {
        this.buf.clear();
        if (this.buf.capacity() < this.values.length * 8) {
            this.buf = ByteBuffer.allocate(this.values.length * 8);
        }
        ByteBufferUtils.writeUnsignedITF8(this.values.length, this.buf);
        for (int n : this.values) {
            this.buf.put((byte)n);
        }
        ByteBufferUtils.writeUnsignedITF8(this.bitLengths.length, this.buf);
        for (int n : this.bitLengths) {
            ByteBufferUtils.writeUnsignedITF8(n, this.buf);
        }
        this.buf.flip();
        byte[] byArray = new byte[this.buf.limit()];
        this.buf.get(byArray);
        return byArray;
    }

    @Override
    public void fromByteArray(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        this.values = new byte[n];
        byteBuffer.get(this.values);
        n = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        this.bitLengths = new int[n];
        for (int i = 0; i < n; ++i) {
            this.bitLengths[i] = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        }
    }

    @Override
    public BitCodec<Byte> buildCodec(Map<Integer, InputStream> map, Map<Integer, ExposedByteArrayOutputStream> map2) {
        return new CanonicalHuffmanByteCodec2(this.values, this.bitLengths);
    }

    public static EncodingParams toParam(byte[] byArray, int[] nArray) {
        HuffmanByteEncoding huffmanByteEncoding = new HuffmanByteEncoding();
        huffmanByteEncoding.values = byArray;
        huffmanByteEncoding.bitLengths = nArray;
        return new EncodingParams(ENCODING_ID, huffmanByteEncoding.toByteArray());
    }
}

