/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.CanonicalHuffmanIntegerCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class HuffmanEncoding
implements Encoding<Integer> {
    public static final EncodingID ENCODING_ID = EncodingID.HUFFMAN;
    private int[] bitLengths;
    private int[] values;

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        ByteBufferUtils.writeUnsignedITF8(this.values.length, byteBuffer);
        for (int n : this.values) {
            ByteBufferUtils.writeUnsignedITF8(n, byteBuffer);
        }
        ByteBufferUtils.writeUnsignedITF8(this.bitLengths.length, byteBuffer);
        for (int n : this.bitLengths) {
            ByteBufferUtils.writeUnsignedITF8(n, byteBuffer);
        }
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return byArray;
    }

    @Override
    public void fromByteArray(byte[] byArray) {
        int n;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n2 = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        this.values = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.values[n] = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        }
        n2 = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        this.bitLengths = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.bitLengths[n] = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        }
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> map, Map<Integer, ExposedByteArrayOutputStream> map2) {
        return new CanonicalHuffmanIntegerCodec(this.values, this.bitLengths);
    }

    public static EncodingParams toParam(int[] nArray, int[] nArray2) {
        HuffmanEncoding huffmanEncoding = new HuffmanEncoding();
        huffmanEncoding.values = nArray;
        huffmanEncoding.bitLengths = nArray2;
        return new EncodingParams(ENCODING_ID, huffmanEncoding.toByteArray());
    }
}

