/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.huffint.CanonicalHuffmanIntegerCodec2;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;

public class HuffmanIntegerEncoding
implements Encoding<Integer> {
    public static final EncodingID ENCODING_ID = EncodingID.HUFFMAN;
    int[] bitLengths;
    int[] values;
    ByteBuffer buf = ByteBuffer.allocate(10240);

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    @Override
    public byte[] toByteArray() {
        this.buf.clear();
        ByteBufferUtils.writeUnsignedITF8(this.values.length, this.buf);
        for (int n : this.values) {
            ByteBufferUtils.writeUnsignedITF8(n, this.buf);
        }
        ByteBufferUtils.writeUnsignedITF8(this.bitLengths.length, this.buf);
        for (int n : this.bitLengths) {
            ByteBufferUtils.writeUnsignedITF8(n, this.buf);
        }
        this.buf.flip();
        byte[] byArray = new byte[this.buf.limit()];
        this.buf.get(byArray);
        return byArray;
    }

    @Override
    public void fromByteArray(byte[] byArray) {
        int n;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n2 = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        this.values = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.values[n] = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        }
        n2 = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        this.bitLengths = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.bitLengths[n] = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        }
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> map, Map<Integer, ExposedByteArrayOutputStream> map2) {
        return new CanonicalHuffmanIntegerCodec2(this.values, this.bitLengths);
    }

    public static EncodingParams toParam(int[] nArray, int[] nArray2) {
        HuffmanIntegerEncoding huffmanIntegerEncoding = new HuffmanIntegerEncoding();
        huffmanIntegerEncoding.values = nArray;
        huffmanIntegerEncoding.bitLengths = nArray2;
        return new EncodingParams(ENCODING_ID, huffmanIntegerEncoding.toByteArray());
    }

    public boolean equals(Object object) {
        if (object instanceof HuffmanIntegerEncoding) {
            HuffmanIntegerEncoding huffmanIntegerEncoding = (HuffmanIntegerEncoding)object;
            if (!Arrays.equals(this.bitLengths, huffmanIntegerEncoding.bitLengths)) {
                return false;
            }
            return Arrays.equals(this.values, huffmanIntegerEncoding.values);
        }
        return false;
    }
}

