/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

public class UnaryIntegerCodec
extends AbstractBitCodec<Integer> {
    private boolean stopBit = false;
    private int offset = 0;

    public UnaryIntegerCodec() {
        this(0, false);
    }

    public UnaryIntegerCodec(int n) {
        this(n, false);
    }

    public UnaryIntegerCodec(int n, boolean bl) {
        this.stopBit = bl;
        this.offset = n;
    }

    @Override
    public final Integer read(BitInputStream bitInputStream) throws IOException {
        int n = 0;
        while (bitInputStream.readBit() != this.stopBit) {
            ++n;
        }
        return n - this.offset;
    }

    @Override
    public final long write(BitOutputStream bitOutputStream, Integer n) throws IOException {
        int n2 = n + this.offset;
        if (n2 < 0) {
            throw new IllegalArgumentException("Unary codec, negative values not allowed: " + n2);
        }
        int n3 = n2 + 1;
        bitOutputStream.write(!this.stopBit, (long)(n3 - 1));
        bitOutputStream.write(this.stopBit, 1L);
        return n + 1;
    }

    @Override
    public final long numberOfBits(Integer n) {
        return n + this.offset + 1;
    }

    public boolean isStopBit() {
        return this.stopBit;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setStopBit(boolean bl) {
        this.stopBit = bl;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int n) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

