/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.fastq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class Template {
    public byte[] name;
    public Segment segment;
    private int hashCode;
    public byte size = 0;
    public long counter = 0L;

    public Template(byte[] byArray) {
        this.name = byArray;
        this.calculateHashCode();
    }

    public void append(byte[] byArray, byte[] byArray2) {
        Segment segment = new Segment(byArray, byArray2);
        Segment segment2 = this.getLastSegment();
        if (segment2 == null) {
            this.segment = segment;
        } else {
            segment2.next = segment;
            segment.prev = segment2;
        }
        this.size = (byte)(this.size + 1);
    }

    public void prepend(byte[] byArray, byte[] byArray2) {
        Segment segment = new Segment(byArray, byArray2);
        Segment segment2 = this.getFirstSegment();
        if (segment2 == null) {
            this.segment = segment;
        } else {
            segment2.prev = segment;
            segment.next = segment2;
        }
        this.size = (byte)(this.size + 1);
    }

    public Segment getLastSegment() {
        if (this.segment == null) {
            return null;
        }
        Segment segment = this.segment;
        while (segment.next != null) {
            segment = segment.next;
        }
        return segment;
    }

    public Segment getFirstSegment() {
        if (this.segment == null) {
            return null;
        }
        Segment segment = this.segment;
        while (segment.prev != null) {
            segment = segment.prev;
        }
        return segment;
    }

    public boolean equals(Object object) {
        if (object instanceof Template) {
            return Arrays.equals(this.name, ((Template)object).name);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected int calculateHashCode() {
        for (int i = 0; i < 4 && i < this.name.length; ++i) {
            this.hashCode <<= 8;
            this.hashCode |= this.name[this.name.length - 1 - i];
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        int n = 4;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n * 2);
        for (int i = 0; i < n; ++i) {
            arrayList.add(String.valueOf(i).getBytes());
            arrayList.add(String.valueOf(i).getBytes());
        }
        Collections.shuffle(arrayList);
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        TemplateAssembler templateAssembler = new TemplateAssembler(4 * n){

            @Override
            protected void templateComplete(Template template) {
                System.out.println("template complete: " + new String(template.name));
                atomicInteger.incrementAndGet();
            }

            @Override
            protected boolean isComplete(Template template) {
                return template.size > 1;
            }

            @Override
            protected void giveupIncomplete(List<Template> list) {
                System.out.println("Giving up on: " + list.size());
                for (Template template : list) {
                    System.out.println(new String(template.name));
                }
            }
        };
        for (byte[] byArray : arrayList) {
            templateAssembler.addSegment(byArray, "A".getBytes(), "Q".getBytes());
        }
        System.out.println("Finishing, complete=" + atomicInteger.get());
        templateAssembler.finish();
    }

    public static abstract class TemplateAssembler {
        public TemplateHash hash = new TemplateHash();
        private int maxHashMapSize;

        public TemplateAssembler(int n) {
            this.maxHashMapSize = n;
        }

        protected abstract boolean isComplete(Template var1);

        protected abstract void templateComplete(Template var1);

        protected abstract void giveupIncomplete(List<Template> var1);

        public void addSegment(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            System.out.println("Template.TemplateAssembler.addSegment()");
            System.out.println(this.hash.map.size());
            Template template = this.hash.add(byArray, byArray2, byArray3);
            System.out.println(this.hash.map.size());
            if (this.isComplete(template)) {
                System.out.println("complete");
                this.hash.remove(template.name);
                this.templateComplete(template);
            } else {
                List<Template> list;
                System.out.println("incomplete");
                if (this.hash.map.size() > this.maxHashMapSize && !(list = this.hash.purgeUpto((this.hash.counter - this.hash.min) / 2L + this.hash.min + 1L)).isEmpty()) {
                    this.giveupIncomplete(list);
                }
            }
            System.out.println(this.hash.map.size());
        }

        public void finish() {
            List<Template> list = this.hash.purgeUpto(this.hash.counter + 1L);
            if (!list.isEmpty()) {
                this.giveupIncomplete(list);
            }
        }
    }

    public static class TemplateHash {
        private HashMap<ByteArrayHashWrapper, Template> map = new HashMap();
        public long counter = 0L;
        public long min = 0L;
        private ByteArrayHashWrapper tmpRemoveWrapper = new ByteArrayHashWrapper(new byte[0]);

        public Template add(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            ByteArrayHashWrapper byteArrayHashWrapper = new ByteArrayHashWrapper(byArray);
            Template template = this.map.get(byteArrayHashWrapper);
            if (template == null) {
                template = new Template(byArray);
                template.counter = ++this.counter;
                this.map.put(byteArrayHashWrapper, template);
            }
            template.append(byArray2, byArray3);
            return template;
        }

        public List<Template> purgeUpto(long l) {
            LinkedList<Template> linkedList = new LinkedList<Template>();
            for (Template template : this.map.values()) {
                if (template.counter >= l) continue;
                linkedList.add(template);
            }
            for (Template template : linkedList) {
                this.remove(template.name);
            }
            return linkedList;
        }

        public void remove(byte[] byArray) {
            this.tmpRemoveWrapper.setArray(byArray);
            this.map.remove(this.tmpRemoveWrapper);
        }

        public int size() {
            return this.map.size();
        }
    }

    public static class ByteArrayHashWrapper {
        private byte[] array;
        private int hashcode;

        public ByteArrayHashWrapper(byte[] byArray) {
            this.setArray(byArray);
        }

        public void setArray(byte[] byArray) {
            this.array = byArray;
            this.calculateHashCode();
        }

        protected int calculateHashCode() {
            for (int i = 0; i < 4 && i < this.array.length; ++i) {
                this.hashcode <<= 8;
                this.hashcode |= this.array[this.array.length - 1 - i];
            }
            return 0;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object object) {
            return Arrays.equals(this.array, ((ByteArrayHashWrapper)object).array);
        }
    }

    public static class Segment {
        public byte[] bases;
        public byte[] scores;
        public Segment prev;
        public Segment next;

        public Segment(byte[] byArray, byte[] byArray2) {
            this.bases = byArray;
            this.scores = byArray2;
        }
    }
}

