/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.read_features;

import htsjdk.samtools.cram.encoding.read_features.BaseChange;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import java.io.Serializable;

public class Substitution
implements Serializable,
ReadFeature {
    private int position;
    private byte base = (byte)-1;
    private byte refernceBase = (byte)-1;
    private BaseChange baseChange;
    private byte code = (byte)-1;
    public static final byte operator = 88;

    public byte getCode() {
        return this.code;
    }

    public void setCode(byte by) {
        this.code = by;
    }

    @Override
    public byte getOperator() {
        return 88;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int n) {
        this.position = n;
    }

    public byte getBase() {
        return this.base;
    }

    public void setBase(byte by) {
        this.base = by;
    }

    public byte getRefernceBase() {
        return this.refernceBase;
    }

    public void setRefernceBase(byte by) {
        this.refernceBase = by;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Substitution)) {
            return false;
        }
        Substitution substitution = (Substitution)object;
        if (this.position != substitution.position) {
            return false;
        }
        if ((this.baseChange != null || substitution.baseChange != null) && (this.baseChange != null ? !this.baseChange.equals(substitution.baseChange) : !substitution.baseChange.equals(this.baseChange))) {
            return false;
        }
        if (this.code != substitution.code & (this.code == -1 || substitution.code == -1)) {
            return false;
        }
        if (this.code > -1 && substitution.code > -1) {
            if (this.refernceBase != substitution.refernceBase) {
                return false;
            }
            if (this.base != substitution.base) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append('X').append('@');
        stringBuffer.append(this.position);
        if (this.baseChange != null) {
            stringBuffer.append('/').append(this.baseChange.getChange());
        } else {
            stringBuffer.append('\\').append((char)this.base);
            stringBuffer.append((char)this.refernceBase);
        }
        return stringBuffer.toString();
    }

    public BaseChange getBaseChange() {
        return this.baseChange;
    }

    public void setBaseChange(BaseChange baseChange) {
        this.baseChange = baseChange;
    }
}

