/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.cram.encoding.reader.AbstractReader;
import htsjdk.samtools.cram.encoding.reader.DataReader;
import htsjdk.samtools.cram.encoding.reader.ReadFeatureBuffer;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.util.SequenceUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractFastqReader
extends AbstractReader {
    private ReadFeatureBuffer rfBuf = new ReadFeatureBuffer();
    public boolean reverseNegativeReads = true;
    public boolean appendSegmentIndexToReadNames = true;
    public byte[] referenceSequence;
    public int flags;
    public int compressionFlags;
    public int mateFlags;
    public int readLength;
    public int prevAlStart;
    public byte[] readName;
    public static final int maxReadBufferLength = 0x100000;
    public byte[] bases = new byte[0x100000];
    public byte[] scores = new byte[0x100000];
    private Map<Integer, Integer> nameCache = new HashMap<Integer, Integer>();
    public long counterOffset = 0L;
    public int defaultQS = 63;

    protected int getSegmentIndexInTemplate(int n) {
        if ((n & 1) == 0) {
            return 0;
        }
        if ((n & 0x40) != 0) {
            return 1;
        }
        return 2;
    }

    protected abstract byte[] refSeqChanged(int var1);

    public void read() throws IOException {
        int n = this.refId;
        this.readName = null;
        try {
            Integer n2;
            byte[][] byArray;
            int n3;
            this.flags = (Integer)this.bitFlagsC.readData();
            this.compressionFlags = ((Byte)this.compBitFlagsC.readData()).byteValue();
            if (this.refId == -2) {
                n = (Integer)this.refIdCodec.readData();
            }
            this.readLength = (Integer)this.readLengthC.readData();
            this.prevAlStart = this.AP_delta ? (this.prevAlStart += ((Integer)this.alStartC.readData()).intValue()) : (Integer)this.alStartC.readData();
            this.readGroupC.skip();
            if (this.captureReadNames) {
                this.readName = (byte[])this.readNameC.readData();
            }
            if ((this.compressionFlags & 2) != 0) {
                this.mateFlags = ((Byte)this.mbfc.readData()).byteValue();
                if (!this.captureReadNames) {
                    this.readName = (byte[])this.readNameC.readData();
                }
                this.mrc.skip();
                this.malsc.skip();
                this.tsc.skip();
                ++detachedCount;
            } else if ((this.compressionFlags & 4) != 0) {
                n3 = (Integer)this.distanceC.readData();
                this.nameCache.put(this.recordCounter + n3 + 1, this.recordCounter);
            }
            if (this.readName == null) {
                if (this.nameCache.containsKey(this.recordCounter)) {
                    n3 = this.nameCache.remove(this.recordCounter);
                    this.readName = Long.toString((long)n3 + this.counterOffset).getBytes();
                } else {
                    this.readName = Long.toString((long)this.recordCounter + this.counterOffset).getBytes();
                }
            }
            if ((byArray = this.tagIdDictionary[n2 = (Integer)this.tagIdListCodec.readData()]).length > 0) {
                for (int i = 0; i < byArray.length; ++i) {
                    int n4 = ReadTag.name3BytesToInt(byArray[i]);
                    DataReader dataReader = (DataReader)this.tagValueCodecs.get(n4);
                    dataReader.skip();
                    continue;
                }
            }
            if ((this.flags & 4) == 0) {
                byte[] byArray2 = this.referenceSequence;
                if (n != this.refId) {
                    byArray2 = this.refSeqChanged(n);
                }
                this.rfBuf.readReadFeatures(this);
                this.rfBuf.restoreReadBases(this.readLength, this.prevAlStart, byArray2, this.substitutionMatrix, this.bases);
                this.mqc.skip();
            } else {
                this.bc.readByteArrayInto(this.bases, 0, this.readLength);
            }
            Arrays.fill(this.scores, 0, this.readLength, (byte)(this.defaultQS - 33));
            if ((this.compressionFlags & 1) != 0) {
                this.qcArray.readByteArrayInto(this.scores, 0, this.readLength);
            } else if ((this.flags & 4) == 0) {
                this.rfBuf.restoreQualityScores(this.readLength, this.prevAlStart, this.scores);
            }
            for (int i = 0; i < this.readLength; ++i) {
                if (this.scores[i] == -1) {
                    this.scores[i] = (byte)this.defaultQS;
                    continue;
                }
                int n5 = i;
                this.scores[n5] = (byte)(this.scores[n5] + 33);
            }
            if (this.reverseNegativeReads && (this.flags & 0x10) != 0) {
                SequenceUtil.reverseComplement(this.bases, 0, this.readLength);
                SequenceUtil.reverse(this.scores, 0, this.readLength);
            }
            this.writeRead(this.readName, this.flags, this.bases, this.scores);
            ++this.recordCounter;
        }
        catch (Exception exception) {
            System.err.printf("Failed at record %d. \n", this.recordCounter);
            if (this.readName != null) {
                System.err.println("read name: " + new String(this.readName));
            }
            throw new RuntimeException(exception);
        }
    }

    protected abstract void writeRead(byte[] var1, int var2, byte[] var3, byte[] var4);

    public abstract void finish();
}

