/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.cram.encoding.reader.AbstractReader;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;

class ReadFeatureBuffer {
    private ByteBuffer readFeatureBuffer = ByteBuffer.allocate(0x100000);
    private int readFeatureSize;

    ReadFeatureBuffer() {
    }

    public final void readReadFeatures(AbstractReader abstractReader) throws IOException {
        this.readFeatureBuffer.clear();
        this.readFeatureSize = abstractReader.nfc.readData();
        int n = 0;
        block12: for (int i = 0; i < this.readFeatureSize; ++i) {
            int n2;
            Byte by = abstractReader.fc.readData();
            n = n2 = n + abstractReader.fp.readData();
            this.readFeatureBuffer.put(by);
            this.readFeatureBuffer.putInt(n2);
            switch (by) {
                case 66: {
                    this.readFeatureBuffer.put(abstractReader.bc.readData());
                    this.readFeatureBuffer.put(abstractReader.qc.readData());
                    continue block12;
                }
                case 88: {
                    this.readFeatureBuffer.put(abstractReader.bsc.readData());
                    continue block12;
                }
                case 73: {
                    byte[] byArray = abstractReader.inc.readData();
                    this.readFeatureBuffer.putInt(byArray.length);
                    this.readFeatureBuffer.put(byArray);
                    continue block12;
                }
                case 83: {
                    byte[] byArray = abstractReader.softClipCodec.readData();
                    this.readFeatureBuffer.putInt(byArray.length);
                    this.readFeatureBuffer.put(byArray);
                    continue block12;
                }
                case 68: {
                    this.readFeatureBuffer.putInt(abstractReader.dlc.readData());
                    continue block12;
                }
                case 78: {
                    this.readFeatureBuffer.putInt(abstractReader.refSkipCodec.readData());
                    continue block12;
                }
                case 105: {
                    this.readFeatureBuffer.put(abstractReader.bc.readData());
                    continue block12;
                }
                case 81: {
                    this.readFeatureBuffer.put(abstractReader.qc.readData());
                    continue block12;
                }
                case 72: {
                    this.readFeatureBuffer.putInt(abstractReader.hardClipCodec.readData());
                    continue block12;
                }
                case 80: {
                    this.readFeatureBuffer.putInt(abstractReader.paddingCodec.readData());
                    continue block12;
                }
                default: {
                    throw new RuntimeException("Unknown read feature operator: " + by);
                }
            }
        }
        this.readFeatureBuffer.flip();
    }

    public final void restoreReadBases(int n, int n2, byte[] byArray, SubstitutionMatrix substitutionMatrix, byte[] byArray2) {
        this.readFeatureBuffer.rewind();
        int n3 = 1;
        int n4 = n2 - 1;
        int n5 = 0;
        if (!this.readFeatureBuffer.hasRemaining()) {
            if (byArray.length < n4 + n) {
                Arrays.fill(byArray2, 0, n, (byte)78);
                System.arraycopy(byArray, n4, byArray2, 0, Math.min(n, byArray.length - n4));
            } else {
                System.arraycopy(byArray, n4, byArray2, 0, n);
            }
        }
        block12: for (int i = 0; i < this.readFeatureSize; ++i) {
            byte by = this.readFeatureBuffer.get();
            int n6 = this.readFeatureBuffer.getInt();
            while (n3 < n6) {
                byArray2[n3 - 1] = byArray[n4 + n5++];
                ++n3;
            }
            int n7 = 0;
            switch (by) {
                case 88: {
                    byte by2;
                    byte by3 = byArray[n4 + n5];
                    byArray2[n3 - 1] = by2 = substitutionMatrix.base(by3, this.readFeatureBuffer.get());
                    ++n3;
                    ++n5;
                    continue block12;
                }
                case 73: {
                    n7 = this.readFeatureBuffer.getInt();
                    this.readFeatureBuffer.get(byArray2, n3 - 1, n7);
                    n3 += n7;
                    continue block12;
                }
                case 83: {
                    n7 = this.readFeatureBuffer.getInt();
                    this.readFeatureBuffer.get(byArray2, n3 - 1, n7);
                    n3 += n7;
                    continue block12;
                }
                case 72: {
                    this.readFeatureBuffer.getInt();
                    continue block12;
                }
                case 78: {
                    n7 = this.readFeatureBuffer.getInt();
                    n5 += n7;
                    continue block12;
                }
                case 80: {
                    n5 += this.readFeatureBuffer.getInt();
                    continue block12;
                }
                case 68: {
                    n5 += this.readFeatureBuffer.getInt();
                    continue block12;
                }
                case 105: {
                    byArray2[n3++ - 1] = this.readFeatureBuffer.get();
                    continue block12;
                }
                case 66: {
                    byArray2[n3++ - 1] = this.readFeatureBuffer.get();
                    this.readFeatureBuffer.get();
                    continue block12;
                }
                case 81: {
                    this.readFeatureBuffer.get();
                    continue block12;
                }
                default: {
                    throw new RuntimeException("Unkown operator: " + by);
                }
            }
        }
        while (n3 <= n && n4 + n5 < byArray.length) {
            byArray2[n3 - 1] = byArray[n4 + n5++];
            ++n3;
        }
    }

    public final Cigar getCigar(int n) {
        CigarElement cigarElement;
        this.readFeatureBuffer.rewind();
        if (!this.readFeatureBuffer.hasRemaining()) {
            CigarElement cigarElement2 = new CigarElement(n, CigarOperator.M);
            return new Cigar(Arrays.asList(cigarElement2));
        }
        ArrayList<CigarElement> arrayList = new ArrayList<CigarElement>();
        int n2 = 1;
        CigarOperator cigarOperator = CigarOperator.MATCH_OR_MISMATCH;
        int n3 = 0;
        int n4 = 1;
        CigarOperator cigarOperator2 = null;
        int n5 = 0;
        block11: for (int i = 0; i < this.readFeatureSize; ++i) {
            byte by = this.readFeatureBuffer.get();
            int n6 = this.readFeatureBuffer.getInt();
            int n7 = n6 - (n4 + n3);
            if (n7 > 0) {
                if (cigarOperator != CigarOperator.MATCH_OR_MISMATCH) {
                    arrayList.add(new CigarElement(n3, cigarOperator));
                    n4 += n3;
                    n2 += n3;
                    n3 = n7;
                } else {
                    n3 += n7;
                }
                cigarOperator = CigarOperator.MATCH_OR_MISMATCH;
            }
            switch (by) {
                case 73: {
                    cigarOperator2 = CigarOperator.INSERTION;
                    n5 = this.readFeatureBuffer.getInt();
                    this.readFeatureBuffer.position(this.readFeatureBuffer.position() + n5);
                    break;
                }
                case 83: {
                    cigarOperator2 = CigarOperator.SOFT_CLIP;
                    n5 = this.readFeatureBuffer.getInt();
                    this.readFeatureBuffer.position(this.readFeatureBuffer.position() + n5);
                    break;
                }
                case 72: {
                    cigarOperator2 = CigarOperator.HARD_CLIP;
                    n5 = this.readFeatureBuffer.getInt();
                    break;
                }
                case 105: {
                    cigarOperator2 = CigarOperator.INSERTION;
                    n5 = 1;
                    this.readFeatureBuffer.get();
                    break;
                }
                case 68: {
                    cigarOperator2 = CigarOperator.DELETION;
                    n5 = this.readFeatureBuffer.getInt();
                    break;
                }
                case 78: {
                    cigarOperator2 = CigarOperator.SKIPPED_REGION;
                    n5 = this.readFeatureBuffer.getInt();
                    break;
                }
                case 80: {
                    cigarOperator2 = CigarOperator.PADDING;
                    n5 = this.readFeatureBuffer.getInt();
                    break;
                }
                case 66: 
                case 88: {
                    cigarOperator2 = CigarOperator.MATCH_OR_MISMATCH;
                    n5 = 1;
                    this.readFeatureBuffer.get();
                    this.readFeatureBuffer.get();
                    break;
                }
                case 81: {
                    this.readFeatureBuffer.get();
                    continue block11;
                }
                default: {
                    continue block11;
                }
            }
            if (cigarOperator != cigarOperator2) {
                if (n3 > 0) {
                    arrayList.add(new CigarElement(n3, cigarOperator));
                    n2 += n3;
                }
                cigarOperator = cigarOperator2;
                n3 = n5;
                n4 = n6;
            } else {
                n3 += n5;
            }
            if (cigarOperator2.consumesReadBases()) continue;
            n4 -= n5;
        }
        if (cigarOperator != null) {
            if (cigarOperator != CigarOperator.M) {
                arrayList.add(new CigarElement(n3, cigarOperator));
                if (n >= n4 + n3) {
                    cigarElement = new CigarElement(n - (n3 + n4) + 1, CigarOperator.M);
                    arrayList.add(cigarElement);
                }
            } else if (n > n4 - 1) {
                cigarElement = new CigarElement(n - n4 + 1, CigarOperator.M);
                arrayList.add(cigarElement);
            }
        }
        if (arrayList.isEmpty()) {
            cigarElement = new CigarElement(n, CigarOperator.M);
            return new Cigar(Arrays.asList(cigarElement));
        }
        return new Cigar(arrayList);
    }

    public void restoreQualityScores(int n, int n2, byte[] byArray) {
        this.readFeatureBuffer.rewind();
        int n3 = 1;
        block12: for (int i = 0; i < this.readFeatureSize; ++i) {
            byte by = this.readFeatureBuffer.get();
            n3 = this.readFeatureBuffer.getInt();
            int n4 = 0;
            switch (by) {
                case 88: {
                    this.readFeatureBuffer.get();
                    continue block12;
                }
                case 73: {
                    int n5;
                    n4 = this.readFeatureBuffer.getInt();
                    for (n5 = 0; n5 < n4; ++n5) {
                        this.readFeatureBuffer.get();
                    }
                    continue block12;
                }
                case 83: {
                    int n5;
                    n4 = this.readFeatureBuffer.getInt();
                    for (n5 = 0; n5 < n4; ++n5) {
                        this.readFeatureBuffer.get();
                    }
                    continue block12;
                }
                case 72: {
                    this.readFeatureBuffer.getInt();
                    continue block12;
                }
                case 78: {
                    n4 = this.readFeatureBuffer.getInt();
                    continue block12;
                }
                case 80: {
                    this.readFeatureBuffer.getInt();
                    continue block12;
                }
                case 68: {
                    this.readFeatureBuffer.getInt();
                    continue block12;
                }
                case 105: {
                    this.readFeatureBuffer.get();
                    continue block12;
                }
                case 66: {
                    this.readFeatureBuffer.get();
                    byArray[n3 - 1] = this.readFeatureBuffer.get();
                    continue block12;
                }
                case 81: {
                    byArray[n3 - 1] = this.readFeatureBuffer.get();
                    continue block12;
                }
                default: {
                    throw new RuntimeException("Unkown operator: " + by);
                }
            }
        }
    }
}

