/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.writer;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.DataSeries;
import htsjdk.samtools.cram.encoding.DataSeriesMap;
import htsjdk.samtools.cram.encoding.DataSeriesType;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.EncodingFactory;
import htsjdk.samtools.cram.encoding.writer.DataWriter;
import htsjdk.samtools.cram.encoding.writer.Writer;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class DataWriterFactory {
    public Writer buildWriter(BitOutputStream bitOutputStream, Map<Integer, ExposedByteArrayOutputStream> map, CompressionHeader compressionHeader, int n) throws IllegalArgumentException, IllegalAccessException {
        Writer writer = new Writer();
        writer.captureReadNames = compressionHeader.readNamesIncluded;
        writer.refId = n;
        writer.substitutionMatrix = compressionHeader.substitutionMatrix;
        writer.AP_delta = compressionHeader.AP_seriesDelta;
        for (Field field : writer.getClass().getFields()) {
            Object object;
            Object object2;
            Annotation annotation;
            if (field.isAnnotationPresent(DataSeries.class)) {
                annotation = field.getAnnotation(DataSeries.class);
                object2 = annotation.key();
                object = annotation.type();
                field.set(writer, this.createWriter((DataSeriesType)((Object)object), compressionHeader.eMap.get(object2), bitOutputStream, map));
            }
            if (!field.isAnnotationPresent(DataSeriesMap.class) || !"TAG".equals(object2 = (annotation = field.getAnnotation(DataSeriesMap.class)).name())) continue;
            object = new HashMap();
            for (Integer n2 : compressionHeader.tMap.keySet()) {
                EncodingParams encodingParams = compressionHeader.tMap.get(n2);
                DataWriter dataWriter = this.createWriter(DataSeriesType.BYTE_ARRAY, encodingParams, bitOutputStream, map);
                object.put(n2, dataWriter);
            }
            field.set(writer, object);
        }
        return writer;
    }

    private <T> DataWriter<T> createWriter(DataSeriesType dataSeriesType, EncodingParams encodingParams, BitOutputStream bitOutputStream, Map<Integer, ExposedByteArrayOutputStream> map) {
        EncodingFactory encodingFactory = new EncodingFactory();
        Encoding encoding = encodingFactory.createEncoding(dataSeriesType, encodingParams.id);
        if (encoding == null) {
            throw new RuntimeException("Encoding not found: value type=" + dataSeriesType.name() + ", encoding id=" + encodingParams.id.name());
        }
        encoding.fromByteArray(encodingParams.params);
        return new DefaultDataWriter(encoding.buildCodec(null, map), bitOutputStream);
    }

    private static class DefaultDataWriter<T>
    implements DataWriter<T> {
        private BitCodec<T> codec;
        private BitOutputStream bos;

        public DefaultDataWriter(BitCodec<T> bitCodec, BitOutputStream bitOutputStream) {
            this.codec = bitCodec;
            this.bos = bitOutputStream;
        }

        @Override
        public long writeData(T t) throws IOException {
            return this.codec.write(this.bos, t);
        }
    }
}

