/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.writer;

import htsjdk.samtools.cram.encoding.DataSeries;
import htsjdk.samtools.cram.encoding.DataSeriesMap;
import htsjdk.samtools.cram.encoding.DataSeriesType;
import htsjdk.samtools.cram.encoding.read_features.BaseQualityScore;
import htsjdk.samtools.cram.encoding.read_features.Deletion;
import htsjdk.samtools.cram.encoding.read_features.HardClip;
import htsjdk.samtools.cram.encoding.read_features.InsertBase;
import htsjdk.samtools.cram.encoding.read_features.Insertion;
import htsjdk.samtools.cram.encoding.read_features.Padding;
import htsjdk.samtools.cram.encoding.read_features.ReadBase;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.encoding.read_features.RefSkip;
import htsjdk.samtools.cram.encoding.read_features.SoftClip;
import htsjdk.samtools.cram.encoding.read_features.Substitution;
import htsjdk.samtools.cram.encoding.writer.DataWriter;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.EncodingKey;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;

public class Writer {
    public static final int TEST_MARK = -1599029040;
    public Charset charset = Charset.forName("UTF8");
    public boolean captureReadNames = false;
    @DataSeries(key=EncodingKey.BF_BitFlags, type=DataSeriesType.INT)
    public DataWriter<Integer> bitFlagsC;
    @DataSeries(key=EncodingKey.CF_CompressionBitFlags, type=DataSeriesType.BYTE)
    public DataWriter<Byte> compBitFlagsC;
    @DataSeries(key=EncodingKey.RL_ReadLength, type=DataSeriesType.INT)
    public DataWriter<Integer> readLengthC;
    @DataSeries(key=EncodingKey.AP_AlignmentPositionOffset, type=DataSeriesType.INT)
    public DataWriter<Integer> alStartC;
    @DataSeries(key=EncodingKey.RG_ReadGroup, type=DataSeriesType.INT)
    public DataWriter<Integer> readGroupC;
    @DataSeries(key=EncodingKey.RN_ReadName, type=DataSeriesType.BYTE_ARRAY)
    public DataWriter<byte[]> readNameC;
    @DataSeries(key=EncodingKey.NF_RecordsToNextFragment, type=DataSeriesType.INT)
    public DataWriter<Integer> distanceC;
    @DataSeries(key=EncodingKey.TC_TagCount, type=DataSeriesType.BYTE)
    public DataWriter<Byte> tagCountC;
    @DataSeries(key=EncodingKey.TN_TagNameAndType, type=DataSeriesType.INT)
    public DataWriter<Integer> tagNameAndTypeC;
    @DataSeriesMap(name="TAG")
    public Map<Integer, DataWriter<byte[]>> tagValueCodecs;
    @DataSeries(key=EncodingKey.FN_NumberOfReadFeatures, type=DataSeriesType.INT)
    public DataWriter<Integer> nfc;
    @DataSeries(key=EncodingKey.FP_FeaturePosition, type=DataSeriesType.INT)
    public DataWriter<Integer> fp;
    @DataSeries(key=EncodingKey.FC_FeatureCode, type=DataSeriesType.BYTE)
    public DataWriter<Byte> fc;
    @DataSeries(key=EncodingKey.BA_Base, type=DataSeriesType.BYTE)
    public DataWriter<Byte> bc;
    @DataSeries(key=EncodingKey.QS_QualityScore, type=DataSeriesType.BYTE)
    public DataWriter<Byte> qc;
    @DataSeries(key=EncodingKey.QS_QualityScore, type=DataSeriesType.BYTE_ARRAY)
    public DataWriter<byte[]> qcArray;
    @DataSeries(key=EncodingKey.BS_BaseSubstitutionCode, type=DataSeriesType.BYTE)
    public DataWriter<Byte> bsc;
    @DataSeries(key=EncodingKey.IN_Insertion, type=DataSeriesType.BYTE_ARRAY)
    public DataWriter<byte[]> inc;
    @DataSeries(key=EncodingKey.SC_SoftClip, type=DataSeriesType.BYTE_ARRAY)
    public DataWriter<byte[]> softClipCodec;
    @DataSeries(key=EncodingKey.HC_HardClip, type=DataSeriesType.INT)
    public DataWriter<Integer> hardClipCodec;
    @DataSeries(key=EncodingKey.PD_padding, type=DataSeriesType.INT)
    public DataWriter<Integer> paddingCodec;
    @DataSeries(key=EncodingKey.DL_DeletionLength, type=DataSeriesType.INT)
    public DataWriter<Integer> dlc;
    @DataSeries(key=EncodingKey.MQ_MappingQualityScore, type=DataSeriesType.INT)
    public DataWriter<Integer> mqc;
    @DataSeries(key=EncodingKey.MF_MateBitFlags, type=DataSeriesType.BYTE)
    public DataWriter<Byte> mbfc;
    @DataSeries(key=EncodingKey.NS_NextFragmentReferenceSequenceID, type=DataSeriesType.INT)
    public DataWriter<Integer> mrc;
    @DataSeries(key=EncodingKey.NP_NextFragmentAlignmentStart, type=DataSeriesType.INT)
    public DataWriter<Integer> malsc;
    @DataSeries(key=EncodingKey.TS_InsetSize, type=DataSeriesType.INT)
    public DataWriter<Integer> tsc;
    @DataSeries(key=EncodingKey.TM_TestMark, type=DataSeriesType.INT)
    public DataWriter<Integer> testC;
    @DataSeries(key=EncodingKey.TL_TagIdList, type=DataSeriesType.INT)
    public DataWriter<Integer> tagIdListCodec;
    @DataSeries(key=EncodingKey.RI_RefId, type=DataSeriesType.INT)
    public DataWriter<Integer> refIdCodec;
    @DataSeries(key=EncodingKey.RS_RefSkip, type=DataSeriesType.INT)
    public DataWriter<Integer> refSkipCodec;
    public int refId;
    public SubstitutionMatrix substitutionMatrix;
    public boolean AP_delta = true;
    public static int detachedCount = 0;

    public void write(CramCompressionRecord cramCompressionRecord) throws IOException {
        int n;
        this.bitFlagsC.writeData(cramCompressionRecord.flags);
        this.compBitFlagsC.writeData(cramCompressionRecord.getCompressionFlags());
        if (this.refId == -2) {
            this.refIdCodec.writeData(cramCompressionRecord.sequenceId);
        }
        this.readLengthC.writeData(cramCompressionRecord.readLength);
        if (this.AP_delta) {
            this.alStartC.writeData(cramCompressionRecord.alignmentDelta);
        } else {
            this.alStartC.writeData(cramCompressionRecord.alignmentStart);
        }
        this.readGroupC.writeData(cramCompressionRecord.readGroupID);
        if (this.captureReadNames) {
            this.readNameC.writeData(cramCompressionRecord.readName.getBytes(this.charset));
        }
        if (cramCompressionRecord.isDetached()) {
            this.mbfc.writeData(cramCompressionRecord.getMateFlags());
            if (!this.captureReadNames) {
                this.readNameC.writeData(cramCompressionRecord.readName.getBytes(this.charset));
            }
            this.mrc.writeData(cramCompressionRecord.mateSequenceID);
            this.malsc.writeData(cramCompressionRecord.mateAlignmentStart);
            this.tsc.writeData(cramCompressionRecord.templateSize);
            ++detachedCount;
        } else if (cramCompressionRecord.isHasMateDownStream()) {
            this.distanceC.writeData(cramCompressionRecord.recordsToNextFragment);
        }
        this.tagIdListCodec.writeData(cramCompressionRecord.tagIdsIndex.value);
        if (cramCompressionRecord.tags != null) {
            for (n = 0; n < cramCompressionRecord.tags.length; ++n) {
                DataWriter<byte[]> dataWriter = this.tagValueCodecs.get(cramCompressionRecord.tags[n].keyType3BytesAsInt);
                dataWriter.writeData(cramCompressionRecord.tags[n].getValueAsByteArray());
            }
        }
        if (!cramCompressionRecord.isSegmentUnmapped()) {
            this.nfc.writeData(cramCompressionRecord.readFeatures.size());
            n = 0;
            block16: for (ReadFeature readFeature : cramCompressionRecord.readFeatures) {
                this.fc.writeData(readFeature.getOperator());
                switch (readFeature.getOperator()) {
                    case 88: {
                        break;
                    }
                }
                this.fp.writeData(readFeature.getPosition() - n);
                n = readFeature.getPosition();
                switch (readFeature.getOperator()) {
                    case 66: {
                        ReadBase readBase = (ReadBase)readFeature;
                        this.bc.writeData(readBase.getBase());
                        this.qc.writeData(readBase.getQualityScore());
                        continue block16;
                    }
                    case 88: {
                        Substitution substitution = (Substitution)readFeature;
                        if (substitution.getCode() < 0) {
                            this.bsc.writeData(this.substitutionMatrix.code(substitution.getRefernceBase(), substitution.getBase()));
                            continue block16;
                        }
                        this.bsc.writeData(substitution.getCode());
                        continue block16;
                    }
                    case 73: {
                        Insertion insertion = (Insertion)readFeature;
                        this.inc.writeData(insertion.getSequence());
                        continue block16;
                    }
                    case 83: {
                        SoftClip softClip = (SoftClip)readFeature;
                        this.softClipCodec.writeData(softClip.getSequence());
                        continue block16;
                    }
                    case 72: {
                        HardClip hardClip = (HardClip)readFeature;
                        this.hardClipCodec.writeData(hardClip.getLength());
                        continue block16;
                    }
                    case 80: {
                        Padding padding = (Padding)readFeature;
                        this.paddingCodec.writeData(padding.getLength());
                        continue block16;
                    }
                    case 68: {
                        Deletion deletion = (Deletion)readFeature;
                        this.dlc.writeData(deletion.getLength());
                        continue block16;
                    }
                    case 78: {
                        RefSkip refSkip = (RefSkip)readFeature;
                        this.refSkipCodec.writeData(refSkip.getLength());
                        continue block16;
                    }
                    case 105: {
                        InsertBase insertBase = (InsertBase)readFeature;
                        this.bc.writeData(insertBase.getBase());
                        continue block16;
                    }
                    case 81: {
                        BaseQualityScore baseQualityScore = (BaseQualityScore)readFeature;
                        this.qc.writeData(baseQualityScore.getQualityScore());
                        continue block16;
                    }
                }
                throw new RuntimeException("Unknown read feature operator: " + (char)readFeature.getOperator());
            }
            this.mqc.writeData(cramCompressionRecord.mappingQuality);
            if (cramCompressionRecord.isForcePreserveQualityScores()) {
                this.qcArray.writeData(cramCompressionRecord.qualityScores);
            }
        } else {
            for (byte by : cramCompressionRecord.readBases) {
                this.bc.writeData(by);
            }
            if (cramCompressionRecord.isForcePreserveQualityScores()) {
                this.qcArray.writeData(cramCompressionRecord.qualityScores);
            }
        }
    }
}

