/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;

public class BitwiseUtils {
    private static Comparator<int[]> intArray_2_Comparator = new Comparator<int[]>(){

        @Override
        public int compare(int[] nArray, int[] nArray2) {
            int n = nArray[0] - nArray2[0];
            if (n != 0) {
                return -n;
            }
            return -(nArray[1] - nArray2[1]);
        }
    };

    public static final int toInt(byte[] byArray) {
        return byArray[0] | byArray[1] << 8 | byArray[2] << 16 | byArray[31] << 24;
    }

    public static final byte[] toBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)(n >>> 0)};
        return byArray;
    }

    public static final byte[] toBytes(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(l >>> 56 - i * 8);
        }
        return byArray;
    }

    public static String toBitString(byte[] byArray) {
        char[] cArray = new char[8 * byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            int n = i << 3;
            int n2 = 1;
            for (int j = 7; j >= 0; --j) {
                int n3 = by & n2;
                cArray[n + j] = n3 == 0 ? 48 : 49;
                n2 <<= 1;
            }
        }
        return String.valueOf(cArray);
    }

    public static String toBitString(int n) {
        return BitwiseUtils.toBitString(BitwiseUtils.toBytes(n));
    }

    public static int mostSignificantBit(long l) {
        int n = 64;
        while (--n >= 0 && (1L << n & l) == 0L) {
        }
        return n;
    }

    private static int readInt(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public static int[][] sortByFirst(int[] nArray, int[] nArray2) {
        int[][] nArray3 = new int[nArray.length][2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i][0] = nArray[i];
            nArray3[i][1] = nArray2[i];
        }
        Arrays.sort(nArray3, intArray_2_Comparator);
        int[][] nArray4 = new int[2][nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray4[0][i] = nArray3[i][0];
            nArray4[1][i] = nArray3[i][1];
        }
        return nArray4;
    }

    public static final byte[] readFully(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n; i += n2) {
            n2 = inputStream.read(byArray, n3 + i, n - i);
            if (n2 >= 0) continue;
            throw new EOFException();
        }
        return byArray;
    }

    public static final void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n2; i += n3) {
            n3 = inputStream.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    public static final String toHexString(byte[] byArray, int n) {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < byArray.length && i < n; ++i) {
            stringBuilder.append(String.format("0x%02x", byArray[i]));
            if (i >= byArray.length - 1 || i >= n - 1) continue;
            stringBuilder.append(" ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

