/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import htsjdk.samtools.cram.io.BitInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DefaultBitInputStream
extends DataInputStream
implements BitInputStream {
    private int nofBufferedBits = 0;
    private int byteBuffer = 0;
    private boolean endOfStream = false;
    private boolean throwEOF = false;
    private static final long[] masks = new long[]{0L, 1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L};
    private boolean byteAligned = false;

    public DefaultBitInputStream(InputStream inputStream) {
        this(inputStream, true);
    }

    public DefaultBitInputStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.throwEOF = bl;
    }

    @Override
    public final boolean readBit() throws IOException {
        if (--this.nofBufferedBits >= 0) {
            return (this.byteBuffer >>> this.nofBufferedBits & 1) == 1;
        }
        this.nofBufferedBits = 7;
        this.byteBuffer = this.in.read();
        if (this.byteBuffer == -1) {
            this.endOfStream = true;
            if (this.throwEOF) {
                throw new EOFException("End of stream.");
            }
        }
        return (this.byteBuffer >>> 7 & 1) == 1;
    }

    @Override
    public final int readBits(int n) throws IOException {
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        while (n > this.nofBufferedBits) {
            n2 |= DefaultBitInputStream.rightBits(this.nofBufferedBits, this.byteBuffer) << (n -= this.nofBufferedBits);
            this.byteBuffer = this.in.read();
            if (this.byteBuffer == -1) {
                this.endOfStream = true;
                throw new EOFException("End of stream.");
            }
            this.nofBufferedBits = 8;
        }
        this.nofBufferedBits -= n;
        return n2 | DefaultBitInputStream.rightBits(n, this.byteBuffer >>> this.nofBufferedBits);
    }

    private static final int rightBits(int n, int n2) {
        return n2 & (1 << n) - 1;
    }

    private static final long rightLongBits(int n, long l) {
        return l & (long)((1 << n) - 1);
    }

    private final void readNextByte() throws IOException {
        this.byteBuffer = this.in.read();
        if (this.byteBuffer == -1) {
            this.endOfStream = true;
            throw new EOFException("End of stream.");
        }
        this.nofBufferedBits = 8;
    }

    public final long readLongBits1(int n) throws IOException {
        if (n > 64) {
            throw new RuntimeException("More then 64 bits are requested in one read from bit stream.");
        }
        long l = 0L;
        long l2 = n - 1;
        for (long i = 0L; i <= l2; ++i) {
            boolean bl = this.readBit();
            if (!bl) continue;
            l |= 1L << (int)(l2 - i);
        }
        return l;
    }

    @Override
    public final long readLongBits(int n) throws IOException {
        if (n > 64) {
            throw new RuntimeException("More then 64 bits are requested in one read from bit stream.");
        }
        if (n == 0) {
            return 0L;
        }
        long l = 0L;
        long l2 = this.byteBuffer;
        if (this.nofBufferedBits == 0) {
            l2 = this.in.read();
            if (l2 == -1L) {
                this.endOfStream = true;
                throw new EOFException("End of stream.");
            }
            this.nofBufferedBits = 8;
        }
        l2 &= masks[this.nofBufferedBits];
        while (n > this.nofBufferedBits) {
            l |= l2 << (n -= this.nofBufferedBits);
            l2 = this.in.read();
            if (l2 == -1L) {
                this.endOfStream = true;
                throw new EOFException("End of stream.");
            }
            this.nofBufferedBits = 8;
        }
        this.nofBufferedBits -= n;
        this.byteBuffer = (int)(l2 & masks[this.nofBufferedBits]);
        return l | l2 >>> this.nofBufferedBits;
    }

    @Override
    public void reset() {
        this.nofBufferedBits = 0;
        this.byteBuffer = 0;
    }

    @Override
    public boolean endOfStream() throws IOException {
        return this.endOfStream;
    }

    public int getNofBufferedBits() {
        return this.nofBufferedBits;
    }

    @Override
    public boolean putBack(long l, int n) {
        return false;
    }

    @Override
    public void alignToByte() throws IOException {
        this.nofBufferedBits = 0;
        this.byteBuffer = 0;
        this.byteAligned = true;
    }

    @Override
    public int readAlignedBytes(byte[] byArray) throws IOException {
        this.readFully(byArray);
        return byArray.length * 8;
    }

    @Override
    public boolean ensureMarker(long l, int n) throws IOException {
        long l2 = this.readBits(n);
        return l2 == l;
    }
}

