/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.ref;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ReferenceSource {
    private static Log log = Log.getInstance(ReferenceSource.class);
    private ReferenceSequenceFile rsFile;
    private FastaSequenceIndex fastaSequenceIndex;
    private int downloadTriesBeforeFailing = 2;
    private Map<String, WeakReference<byte[]>> cacheW = new HashMap<String, WeakReference<byte[]>>();
    private static final Pattern chrPattern = Pattern.compile("chr.*", 2);

    public ReferenceSource() {
    }

    public ReferenceSource(File file) {
        if (file != null) {
            this.rsFile = ReferenceSequenceFileFactory.getReferenceSequenceFile(file);
            File file2 = new File(file.getAbsoluteFile() + ".fai");
            if (file2.exists()) {
                this.fastaSequenceIndex = new FastaSequenceIndex(file2);
            }
        }
    }

    public ReferenceSource(ReferenceSequenceFile referenceSequenceFile) {
        this.rsFile = referenceSequenceFile;
    }

    public void clearCache() {
        this.cacheW.clear();
    }

    private byte[] findInCache(String string) {
        byte[] byArray;
        WeakReference<byte[]> weakReference = this.cacheW.get(string);
        if (weakReference != null && (byArray = (byte[])weakReference.get()) != null) {
            return byArray;
        }
        return null;
    }

    public synchronized byte[] getReferenceBases(SAMSequenceRecord sAMSequenceRecord, boolean bl) {
        String string = sAMSequenceRecord.getSequenceName();
        byte[] byArray = this.findInCache(string);
        if (byArray != null) {
            return byArray;
        }
        string = sAMSequenceRecord.getAttribute("M5");
        if (string != null && (byArray = this.findInCache(string)) != null) {
            return byArray;
        }
        byArray = this.findBasesByName(sAMSequenceRecord.getSequenceName(), bl);
        if (byArray != null) {
            SequenceUtil.upperCase(byArray);
            this.cacheW.put(sAMSequenceRecord.getSequenceName(), new WeakReference<byte[]>(byArray));
            return byArray;
        }
        if (string != null) {
            try {
                byArray = this.findBasesByMD5(string);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        if (byArray != null) {
            SequenceUtil.upperCase(byArray);
            this.cacheW.put(string, new WeakReference<byte[]>(byArray));
            return byArray;
        }
        return null;
    }

    protected byte[] findBasesByName(String string, boolean bl) {
        if (this.rsFile == null || !this.rsFile.isIndexed()) {
            return null;
        }
        ReferenceSequence referenceSequence = null;
        if (this.fastaSequenceIndex != null) {
            referenceSequence = this.fastaSequenceIndex.hasIndexEntry(string) ? this.rsFile.getSequence(string) : null;
        }
        if (referenceSequence != null) {
            return referenceSequence.getBases();
        }
        referenceSequence = this.rsFile.getSequence(string);
        if (referenceSequence != null) {
            return referenceSequence.getBases();
        }
        if (bl) {
            for (String string2 : this.getVariants(string)) {
                try {
                    referenceSequence = this.rsFile.getSequence(string2);
                }
                catch (SAMException sAMException) {
                    log.warn("Sequence not found: " + string2);
                }
                if (referenceSequence == null) continue;
                return referenceSequence.getBases();
            }
        }
        return null;
    }

    protected byte[] findBasesByMD5(String string) throws MalformedURLException, IOException {
        String string2 = String.format(Defaults.EBI_REFERENCE_SEVICE_URL_MASK, string);
        for (int i = 0; i < this.downloadTriesBeforeFailing; ++i) {
            InputStream inputStream = new URL(string2).openStream();
            if (inputStream == null) {
                return null;
            }
            log.debug("Downloading reference sequence: " + string2);
            byte[] byArray = ByteBufferUtils.readFully(inputStream);
            log.debug("Downloaded " + byArray.length + " bytes for md5 " + string);
            inputStream.close();
            try {
                String string3 = SequenceUtil.calculateMD5String(byArray);
                if (string.equals(string3)) {
                    return byArray;
                }
                String string4 = String.format("Downloaded sequence is corrupt: requested md5=%s, received md5=%s", string, string3);
                log.error(string4);
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException(noSuchAlgorithmException);
            }
        }
        throw new RuntimeException("Giving up on downloading sequence for md5 " + string);
    }

    protected List<String> getVariants(String string) {
        boolean bl;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.equals("M")) {
            arrayList.add("MT");
        }
        if (string.equals("MT")) {
            arrayList.add("M");
        }
        if (bl = chrPattern.matcher(string).matches()) {
            arrayList.add(string.substring(3));
        } else {
            arrayList.add("chr" + string);
        }
        if ("chrM".equals(string)) {
            arrayList.add("MT");
        }
        return arrayList;
    }

    public int getDownloadTriesBeforeFailing() {
        return this.downloadTriesBeforeFailing;
    }

    public void setDownloadTriesBeforeFailing(int n) {
        this.downloadTriesBeforeFailing = n;
    }
}

