/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.encoding.NullEncoding;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingKey;
import htsjdk.samtools.cram.structure.EncodingParams;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CompressionHeader {
    private static final String RN_readNamesIncluded = "RN";
    private static final String AP_alignmentPositionIsDelta = "AP";
    private static final String RR_referenceRequired = "RR";
    private static final String TD_tagIdsDictionary = "TD";
    private static final String SM_substitutionMatrix = "SM";
    private static Log log = Log.getInstance(CompressionHeader.class);
    public boolean readNamesIncluded;
    public boolean AP_seriesDelta = true;
    public boolean referenceRequired = true;
    public Map<EncodingKey, EncodingParams> eMap;
    public Map<Integer, EncodingParams> tMap;
    public SubstitutionMatrix substitutionMatrix;
    public List<Integer> externalIds;
    public byte[][][] dictionary;

    public CompressionHeader() {
    }

    public CompressionHeader(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    /*
     * WARNING - void declaration
     */
    private byte[][][] parseDictionary(byte[] byArray) {
        void var5_7;
        Object object;
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < byArray.length; ++n) {
            object = new ArrayList();
            while (byArray[n] != 0) {
                object.add(Arrays.copyOfRange(byArray, n, n + 3));
                n += 3;
            }
            arrayList.add(object);
        }
        n = 0;
        for (List list : arrayList) {
            n = Math.max(n, list.size());
        }
        object = new byte[arrayList.size()][][];
        boolean i = false;
        while (var5_7 < arrayList.size()) {
            List list = (List)arrayList.get((int)var5_7);
            object[var5_7] = (byte[][])list.toArray((T[])new byte[list.size()][]);
            ++var5_7;
        }
        return object;
    }

    private byte[] dictionaryToByteArray() {
        int n = 0;
        for (int i = 0; i < this.dictionary.length; ++i) {
            for (int j = 0; j < this.dictionary[i].length; ++j) {
                n += this.dictionary[i][j].length;
            }
            ++n;
        }
        byte[] byArray = new byte[n];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        for (int i = 0; i < this.dictionary.length; ++i) {
            for (int j = 0; j < this.dictionary[i].length; ++j) {
                byteBuffer.put(this.dictionary[i][j]);
            }
            byteBuffer.put((byte)0);
        }
        return byArray;
    }

    public byte[][] getTagIds(int n) {
        return this.dictionary[n];
    }

    public void read(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            this.read(byteArrayInputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException("This should have never happened.");
        }
    }

    public void read(InputStream inputStream) throws IOException {
        int n;
        int n2 = ByteBufferUtils.readUnsignedITF8(inputStream);
        byte[] byArray = new byte[n2];
        ByteBufferUtils.readFully(byArray, inputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n3 = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        for (int i = 0; i < n3; ++i) {
            String string = new String(new byte[]{byteBuffer.get(), byteBuffer.get()});
            if (RN_readNamesIncluded.equals(string)) {
                this.readNamesIncluded = byteBuffer.get() == 1;
                continue;
            }
            if (AP_alignmentPositionIsDelta.equals(string)) {
                this.AP_seriesDelta = byteBuffer.get() == 1;
                continue;
            }
            if (RR_referenceRequired.equals(string)) {
                this.referenceRequired = byteBuffer.get() == 1;
                continue;
            }
            if (TD_tagIdsDictionary.equals(string)) {
                int n4 = ByteBufferUtils.readUnsignedITF8(byteBuffer);
                byte[] object2 = new byte[n4];
                byteBuffer.get(object2);
                this.dictionary = this.parseDictionary(object2);
                continue;
            }
            if (SM_substitutionMatrix.equals(string)) {
                byte[] byArray2 = new byte[5];
                byteBuffer.get(byArray2);
                this.substitutionMatrix = new SubstitutionMatrix(byArray2);
                continue;
            }
            throw new RuntimeException("Unknown preservation map key: " + string);
        }
        n2 = ByteBufferUtils.readUnsignedITF8(inputStream);
        byArray = new byte[n2];
        ByteBufferUtils.readFully(byArray, inputStream);
        byteBuffer = ByteBuffer.wrap(byArray);
        n3 = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        this.eMap = new TreeMap<EncodingKey, EncodingParams>();
        for (EncodingKey encodingKey : EncodingKey.values()) {
            this.eMap.put(encodingKey, NullEncoding.toParam());
        }
        for (n = 0; n < n3; ++n) {
            String string = new String(new byte[]{byteBuffer.get(), byteBuffer.get()});
            EncodingKey encodingKey = EncodingKey.byFirstTwoChars(string);
            if (encodingKey == null) {
                throw new RuntimeException("Unknown encoding key: " + string);
            }
            EncodingID encodingID = EncodingID.values()[byteBuffer.get()];
            int n4 = ByteBufferUtils.readUnsignedITF8(byteBuffer);
            byte[] byArray2 = new byte[n4];
            byteBuffer.get(byArray2);
            this.eMap.put(encodingKey, new EncodingParams(encodingID, byArray2));
            log.debug(String.format("FOUND ENCODING: %s, %s, %s.", encodingKey.name(), encodingID.name(), Arrays.toString(Arrays.copyOf(byArray2, 20))));
        }
        n2 = ByteBufferUtils.readUnsignedITF8(inputStream);
        byArray = new byte[n2];
        ByteBufferUtils.readFully(byArray, inputStream);
        byteBuffer = ByteBuffer.wrap(byArray);
        n3 = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        this.tMap = new TreeMap<Integer, EncodingParams>();
        for (n = 0; n < n3; ++n) {
            int n6 = ByteBufferUtils.readUnsignedITF8(byteBuffer);
            EncodingID encodingID = EncodingID.values()[byteBuffer.get()];
            int n5 = ByteBufferUtils.readUnsignedITF8(byteBuffer);
            byte[] byArray3 = new byte[n5];
            byteBuffer.get(byArray3);
            this.tMap.put(n6, new EncodingParams(encodingID, byArray3));
        }
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void write(OutputStream outputStream) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(102400);
        ByteBufferUtils.writeUnsignedITF8(5, byteBuffer);
        byteBuffer.put(RN_readNamesIncluded.getBytes());
        byteBuffer.put((byte)(this.readNamesIncluded ? 1 : 0));
        byteBuffer.put(AP_alignmentPositionIsDelta.getBytes());
        byteBuffer.put((byte)(this.AP_seriesDelta ? 1 : 0));
        byteBuffer.put(RR_referenceRequired.getBytes());
        byteBuffer.put((byte)(this.referenceRequired ? 1 : 0));
        byteBuffer.put(SM_substitutionMatrix.getBytes());
        byteBuffer.put(this.substitutionMatrix.getEncodedMatrix());
        byteBuffer.put(TD_tagIdsDictionary.getBytes());
        Object object2 = this.dictionaryToByteArray();
        ByteBufferUtils.writeUnsignedITF8(((byte[])object2).length, byteBuffer);
        byteBuffer.put((byte[])object2);
        byteBuffer.flip();
        object2 = new byte[byteBuffer.limit()];
        byteBuffer.get((byte[])object2);
        ByteBufferUtils.writeUnsignedITF8(((byte[])object2).length, outputStream);
        outputStream.write((byte[])object2);
        int n = 0;
        object2 = this.eMap.keySet().iterator();
        while (object2.hasNext()) {
            EncodingKey object4 = (EncodingKey)((Object)object2.next());
            if (this.eMap.get((Object)((Object)object4)).id == EncodingID.NULL) continue;
            ++n;
        }
        object2 = ByteBuffer.allocate(102400);
        ByteBufferUtils.writeUnsignedITF8(n, (ByteBuffer)object2);
        for (Object object : this.eMap.keySet()) {
            if (this.eMap.get((Object)object).id == EncodingID.NULL) continue;
            ((ByteBuffer)object2).put((byte)object.name().charAt(0));
            ((ByteBuffer)object2).put((byte)object.name().charAt(1));
            EncodingParams encodingParams = this.eMap.get(object);
            ((ByteBuffer)object2).put((byte)(0xFF & encodingParams.id.ordinal()));
            ByteBufferUtils.writeUnsignedITF8(encodingParams.params.length, (ByteBuffer)object2);
            ((ByteBuffer)object2).put(encodingParams.params);
        }
        ((ByteBuffer)object2).flip();
        byte[] byArray = new byte[((Buffer)object2).limit()];
        ((ByteBuffer)object2).get(byArray);
        ByteBufferUtils.writeUnsignedITF8(byArray.length, outputStream);
        outputStream.write(byArray);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(102400);
        ByteBufferUtils.writeUnsignedITF8(this.tMap.size(), byteBuffer2);
        for (Integer n2 : this.tMap.keySet()) {
            Object object;
            ByteBufferUtils.writeUnsignedITF8((int)n2, byteBuffer2);
            object = this.tMap.get(n2);
            byteBuffer2.put((byte)(0xFF & ((EncodingParams)object).id.ordinal()));
            ByteBufferUtils.writeUnsignedITF8(((EncodingParams)object).params.length, byteBuffer2);
            byteBuffer2.put(((EncodingParams)object).params);
        }
        byteBuffer2.flip();
        object2 = new byte[byteBuffer2.limit()];
        byteBuffer2.get((byte[])object2);
        ByteBufferUtils.writeUnsignedITF8(((byte[])object2).length, outputStream);
        outputStream.write((byte[])object2);
    }
}

