/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.common.MutableInt;
import htsjdk.samtools.cram.encoding.read_features.Deletion;
import htsjdk.samtools.cram.encoding.read_features.Insertion;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.encoding.read_features.SoftClip;
import htsjdk.samtools.cram.structure.ReadTag;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class CramCompressionRecord {
    public static final int MULTIFRAGMENT_FLAG = 1;
    public static final int PROPER_PAIR_FLAG = 2;
    public static final int SEGMENT_UNMAPPED_FLAG = 4;
    public static final int NEGATIVE_STRAND_FLAG = 16;
    public static final int FIRST_SEGMENT_FLAG = 64;
    public static final int LAST_SEGMENT_FLAG = 128;
    public static final int SECONDARY_ALIGNMENT_FLAG = 256;
    public static final int VENDOR_FILTERED_FLAG = 512;
    public static final int DUPLICATE_FLAG = 1024;
    public static final int MATE_NEG_STRAND_FLAG = 1;
    public static final int MATE_UNMAPPED_FLAG = 2;
    public static final int FORCE_PRESERVE_QS_FLAG = 1;
    public static final int DETACHED_FLAG = 2;
    public static final int HAS_MATE_DOWNSTREAM_FLAG = 4;
    public int index = 0;
    public int alignmentStart;
    public int alignmentDelta;
    private int alignmentEnd = -1;
    private int alignmentSpan = -1;
    public int readLength;
    public int recordsToNextFragment = -1;
    public byte[] readBases;
    public byte[] qualityScores;
    public List<ReadFeature> readFeatures;
    public int readGroupID = 0;
    public int flags = 0;
    public int mateFlags = 0;
    public int compressionFlags = 0;
    public CramCompressionRecord next;
    public CramCompressionRecord previous;
    public int mateSequenceID = -1;
    public int mateAlignmentStart = 0;
    public int mappingQuality;
    public String sequenceName;
    public int sequenceId;
    public String readName;
    public int templateSize;
    public ReadTag[] tags;
    public byte[] tagIds;
    public MutableInt tagIdsIndex;
    public int sliceIndex = 0;

    public byte getMateFlags() {
        return (byte)(0xFF & this.mateFlags);
    }

    public byte getCompressionFlags() {
        return (byte)(0xFF & this.compressionFlags);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CramCompressionRecord)) {
            return false;
        }
        CramCompressionRecord cramCompressionRecord = (CramCompressionRecord)object;
        if (this.alignmentStart != cramCompressionRecord.alignmentStart) {
            return false;
        }
        if (this.isNegativeStrand() != cramCompressionRecord.isNegativeStrand()) {
            return false;
        }
        if (this.isVendorFiltered() != cramCompressionRecord.isVendorFiltered()) {
            return false;
        }
        if (this.isSegmentUnmapped() != cramCompressionRecord.isSegmentUnmapped()) {
            return false;
        }
        if (this.readLength != cramCompressionRecord.readLength) {
            return false;
        }
        if (this.isLastSegment() != cramCompressionRecord.isLastSegment()) {
            return false;
        }
        if (this.recordsToNextFragment != cramCompressionRecord.recordsToNextFragment) {
            return false;
        }
        if (this.isFirstSegment() != cramCompressionRecord.isFirstSegment()) {
            return false;
        }
        if (this.mappingQuality != cramCompressionRecord.mappingQuality) {
            return false;
        }
        if (!this.deepEquals(this.readFeatures, cramCompressionRecord.readFeatures)) {
            return false;
        }
        if (!Arrays.equals(this.readBases, cramCompressionRecord.readBases)) {
            return false;
        }
        if (!Arrays.equals(this.qualityScores, cramCompressionRecord.qualityScores)) {
            return false;
        }
        if (!this.areEqual(this.flags, cramCompressionRecord.flags)) {
            return false;
        }
        return this.areEqual(this.readName, cramCompressionRecord.readName);
    }

    private boolean areEqual(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        return object != null && object.equals(object2);
    }

    private boolean deepEquals(Collection<?> collection, Collection<?> collection2) {
        if ((collection == null || collection.isEmpty()) && (collection2 == null || collection2.isEmpty())) {
            return true;
        }
        if (collection != null) {
            return ((Object)collection).equals(collection2);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        if (this.readName != null) {
            stringBuffer.append(this.readName).append("; ");
        }
        stringBuffer.append("flags=").append(this.flags);
        stringBuffer.append("; aloffset=").append(this.alignmentDelta);
        stringBuffer.append("; mateoffset=").append(this.recordsToNextFragment);
        stringBuffer.append("; mappingQuality=").append(this.mappingQuality);
        if (this.readFeatures != null) {
            for (ReadFeature readFeature : this.readFeatures) {
                stringBuffer.append("; ").append(readFeature.toString());
            }
        }
        if (this.readBases != null) {
            stringBuffer.append("; ").append("bases: ").append(new String(this.readBases));
        }
        if (this.qualityScores != null) {
            stringBuffer.append("; ").append("qscores: ").append(new String(this.qualityScores));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int getAlignmentSpan() {
        if (this.alignmentSpan < 0) {
            this.calculateAlignmentBoundaries();
        }
        return this.alignmentSpan;
    }

    public void calculateAlignmentBoundaries() {
        if (this.readFeatures == null || this.readFeatures.isEmpty()) {
            this.alignmentSpan = this.readLength;
            this.alignmentEnd = this.alignmentStart + this.alignmentSpan - 1;
        } else {
            this.alignmentSpan = this.readLength;
            for (ReadFeature readFeature : this.readFeatures) {
                switch (readFeature.getOperator()) {
                    case 105: {
                        --this.alignmentSpan;
                        break;
                    }
                    case 73: {
                        this.alignmentSpan -= ((Insertion)readFeature).getSequence().length;
                        break;
                    }
                    case 83: {
                        this.alignmentSpan -= ((SoftClip)readFeature).getSequence().length;
                        break;
                    }
                    case 68: {
                        this.alignmentSpan += ((Deletion)readFeature).getLength();
                        break;
                    }
                }
            }
            this.alignmentEnd = this.alignmentStart + this.alignmentSpan - 1;
        }
    }

    public int getAlignmentEnd() {
        if (this.alignmentEnd < 0) {
            this.calculateAlignmentBoundaries();
        }
        return this.alignmentEnd;
    }

    public boolean isMultiFragment() {
        return (this.flags & 1) != 0;
    }

    public void setMultiFragment(boolean bl) {
        this.flags = bl ? this.flags | 1 : this.flags & 0xFFFFFFFE;
    }

    public boolean isSegmentUnmapped() {
        return (this.flags & 4) != 0;
    }

    public void setSegmentUnmapped(boolean bl) {
        this.flags = bl ? this.flags | 4 : this.flags & 0xFFFFFFFB;
    }

    public boolean isFirstSegment() {
        return (this.flags & 0x40) != 0;
    }

    public void setFirstSegment(boolean bl) {
        this.flags = bl ? this.flags | 0x40 : this.flags & 0xFFFFFFBF;
    }

    public boolean isLastSegment() {
        return (this.flags & 0x80) != 0;
    }

    public void setLastSegment(boolean bl) {
        this.flags = bl ? this.flags | 0x80 : this.flags & 0xFFFFFF7F;
    }

    public boolean isSecondaryAlignment() {
        return (this.flags & 0x100) != 0;
    }

    public void setSecondaryAlignment(boolean bl) {
        this.flags = bl ? this.flags | 0x100 : this.flags & 0xFFFFFEFF;
    }

    public boolean isVendorFiltered() {
        return (this.flags & 0x200) != 0;
    }

    public void setVendorFiltered(boolean bl) {
        this.flags = bl ? this.flags | 0x200 : this.flags & 0xFFFFFDFF;
    }

    public boolean isProperPair() {
        return (this.flags & 2) != 0;
    }

    public void setProperPair(boolean bl) {
        this.flags = bl ? this.flags | 2 : this.flags & 0xFFFFFFFD;
    }

    public boolean isDuplicate() {
        return (this.flags & 0x400) != 0;
    }

    public void setDuplicate(boolean bl) {
        this.flags = bl ? this.flags | 0x400 : this.flags & 0xFFFFFBFF;
    }

    public boolean isNegativeStrand() {
        return (this.flags & 0x10) != 0;
    }

    public void setNegativeStrand(boolean bl) {
        this.flags = bl ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
    }

    public boolean isMateUmapped() {
        return (this.mateFlags & 2) != 0;
    }

    public void setMateUmapped(boolean bl) {
        this.mateFlags = bl ? this.mateFlags | 2 : this.mateFlags & 0xFFFFFFFD;
    }

    public boolean isMateNegativeStrand() {
        return (this.mateFlags & 1) != 0;
    }

    public void setMateNegativeStrand(boolean bl) {
        this.mateFlags = bl ? this.mateFlags | 1 : this.mateFlags & 0xFFFFFFFE;
    }

    public boolean isHasMateDownStream() {
        return (this.compressionFlags & 4) != 0;
    }

    public void setHasMateDownStream(boolean bl) {
        this.compressionFlags = bl ? this.compressionFlags | 4 : this.compressionFlags & 0xFFFFFFFB;
    }

    public boolean isDetached() {
        return (this.compressionFlags & 2) != 0;
    }

    public void setDetached(boolean bl) {
        this.compressionFlags = bl ? this.compressionFlags | 2 : this.compressionFlags & 0xFFFFFFFD;
    }

    public boolean isForcePreserveQualityScores() {
        return (this.compressionFlags & 1) != 0;
    }

    public void setForcePreserveQualityScores(boolean bl) {
        this.compressionFlags = bl ? this.compressionFlags | 1 : this.compressionFlags & 0xFFFFFFFE;
    }

    public static int getBAMFlags(int n, byte by) {
        int n2 = n;
        if ((by & 1) != 0) {
            n2 |= 0x20;
        }
        if ((by & 2) != 0) {
            n2 |= 8;
        }
        return n2;
    }

    public static class BAM_FLAGS {
        public static final int READ_PAIRED_FLAG = 1;
        public static final int PROPER_PAIR_FLAG = 2;
        public static final int READ_UNMAPPED_FLAG = 4;
        public static final int MATE_UNMAPPED_FLAG = 8;
        public static final int READ_STRAND_FLAG = 16;
        public static final int MATE_STRAND_FLAG = 32;
        public static final int FIRST_OF_PAIR_FLAG = 64;
        public static final int SECOND_OF_PAIR_FLAG = 128;
        public static final int NOT_PRIMARY_ALIGNMENT_FLAG = 256;
        public static final int READ_FAILS_VENDOR_QUALITY_CHECK_FLAG = 512;
        public static final int DUPLICATE_READ_FLAG = 1024;
    }
}

