/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.SAMFileHeader;
import java.util.Arrays;

public final class CramHeader {
    public static final byte[] magick = "CRAM".getBytes();
    private byte majorVersion;
    private byte minorVersion;
    public final byte[] id = new byte[20];
    private SAMFileHeader samFileHeader;

    public CramHeader() {
        Arrays.fill(this.id, (byte)0);
    }

    public CramHeader(int n, int n2, String string, SAMFileHeader sAMFileHeader) {
        Arrays.fill(this.id, (byte)0);
        this.majorVersion = (byte)n;
        this.minorVersion = (byte)n2;
        if (string != null) {
            System.arraycopy(string.getBytes(), 0, this.id, 0, Math.min(string.length(), this.id.length));
        }
        this.samFileHeader = sAMFileHeader;
    }

    public void setID(String string) {
        System.arraycopy(string.getBytes(), 0, this.id, 0, Math.min(this.id.length, string.length()));
    }

    public CramHeader clone() {
        CramHeader cramHeader = new CramHeader();
        cramHeader.majorVersion = this.majorVersion;
        cramHeader.minorVersion = this.minorVersion;
        System.arraycopy(this.id, 0, cramHeader.id, 0, this.id.length);
        cramHeader.samFileHeader = this.getSamFileHeader().clone();
        return cramHeader;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof CramHeader)) {
            return false;
        }
        CramHeader cramHeader = (CramHeader)object;
        if (this.getMajorVersion() != cramHeader.getMajorVersion()) {
            return false;
        }
        if (this.getMinorVersion() != cramHeader.getMinorVersion()) {
            return false;
        }
        if (!Arrays.equals(this.id, cramHeader.id)) {
            return false;
        }
        return this.getSamFileHeader().equals(cramHeader.getSamFileHeader());
    }

    public byte getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(byte by) {
        this.majorVersion = by;
    }

    public byte getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(byte by) {
        this.minorVersion = by;
    }

    public SAMFileHeader getSamFileHeader() {
        return this.samFileHeader;
    }

    public void setSamFileHeader(SAMFileHeader sAMFileHeader) {
        this.samFileHeader = sAMFileHeader;
    }

    public byte[] getId() {
        return this.id;
    }
}

