/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.BlockCompressionMethod;
import htsjdk.samtools.cram.structure.BlockContentType;
import htsjdk.samtools.cram.structure.Slice;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;

public class SliceIO {
    public void readSliceHeadBlock(Slice slice, InputStream inputStream) throws IOException {
        slice.headerBlock = new Block(inputStream, true, true);
        this.parseSliceHeaderBlock(slice);
    }

    public void parseSliceHeaderBlock(Slice slice) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(slice.headerBlock.getRawContent());
        slice.sequenceId = ByteBufferUtils.readUnsignedITF8(byteArrayInputStream);
        slice.alignmentStart = ByteBufferUtils.readUnsignedITF8(byteArrayInputStream);
        slice.alignmentSpan = ByteBufferUtils.readUnsignedITF8(byteArrayInputStream);
        slice.nofRecords = ByteBufferUtils.readUnsignedITF8(byteArrayInputStream);
        slice.globalRecordCounter = ByteBufferUtils.readUnsignedLTF8(byteArrayInputStream);
        slice.nofBlocks = ByteBufferUtils.readUnsignedITF8(byteArrayInputStream);
        slice.contentIDs = ByteBufferUtils.array(byteArrayInputStream);
        slice.embeddedRefBlockContentID = ByteBufferUtils.readUnsignedITF8(byteArrayInputStream);
        slice.refMD5 = new byte[16];
        ByteBufferUtils.readFully(slice.refMD5, byteArrayInputStream);
    }

    public byte[] createSliceHeaderBlockContent(Slice slice) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteBufferUtils.writeUnsignedITF8(slice.sequenceId, byteArrayOutputStream);
        ByteBufferUtils.writeUnsignedITF8(slice.alignmentStart, byteArrayOutputStream);
        ByteBufferUtils.writeUnsignedITF8(slice.alignmentSpan, byteArrayOutputStream);
        ByteBufferUtils.writeUnsignedITF8(slice.nofRecords, byteArrayOutputStream);
        ByteBufferUtils.writeUnsignedLTF8(slice.globalRecordCounter, byteArrayOutputStream);
        ByteBufferUtils.writeUnsignedITF8(slice.nofBlocks, byteArrayOutputStream);
        slice.contentIDs = new int[slice.external.size()];
        int n = 0;
        for (int n2 : slice.external.keySet()) {
            slice.contentIDs[n++] = n2;
        }
        ByteBufferUtils.write(slice.contentIDs, byteArrayOutputStream);
        ByteBufferUtils.writeUnsignedITF8(slice.embeddedRefBlockContentID, byteArrayOutputStream);
        byteArrayOutputStream.write(slice.refMD5 == null ? new byte[16] : slice.refMD5);
        ByteBufferUtils.writeUnsignedITF8(slice.sequenceId, byteArrayOutputStream);
        ByteBufferUtils.writeUnsignedITF8(slice.sequenceId, byteArrayOutputStream);
        ByteBufferUtils.writeUnsignedITF8(slice.sequenceId, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void createSliceHeaderBlock(Slice slice) throws IOException {
        byte[] byArray = this.createSliceHeaderBlockContent(slice);
        slice.headerBlock = new Block(BlockCompressionMethod.RAW, BlockContentType.MAPPED_SLICE, 0, byArray, null);
    }

    public void readSliceBlocks(Slice slice, boolean bl, InputStream inputStream) throws IOException {
        slice.external = new HashMap<Integer, Block>();
        block4: for (int i = 0; i < slice.nofBlocks; ++i) {
            Block block = new Block(inputStream, true, bl);
            switch (block.contentType) {
                case CORE: {
                    slice.coreBlock = block;
                    continue block4;
                }
                case EXTERNAL: {
                    if (slice.embeddedRefBlockContentID == block.contentId) {
                        slice.embeddedRefBlock = block;
                    }
                    slice.external.put(block.contentId, block);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Not a slice block, content type id " + block.contentType.name());
                }
            }
        }
    }

    public void write(Slice slice, OutputStream outputStream) throws IOException {
        slice.nofBlocks = 1 + slice.external.size() + (slice.embeddedRefBlock == null ? 0 : 1);
        slice.contentIDs = new int[slice.external.size()];
        int n = 0;
        Iterator<Integer> object2 = slice.external.keySet().iterator();
        while (object2.hasNext()) {
            int n2;
            slice.contentIDs[n] = n2 = object2.next().intValue();
        }
        this.createSliceHeaderBlock(slice);
        slice.headerBlock.write(outputStream);
        slice.coreBlock.write(outputStream);
        for (Block block : slice.external.values()) {
            block.write(outputStream);
        }
    }

    public void read(Slice slice, InputStream inputStream) throws IOException {
        this.readSliceHeadBlock(slice, inputStream);
        this.readSliceBlocks(slice, true, inputStream);
    }
}

