/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.AbstractFastaSequenceFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.FastLineReader;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.File;

public class FastaSequenceFile
extends AbstractFastaSequenceFile {
    private final boolean truncateNamesAtWhitespace;
    private FastLineReader in;
    private int sequenceIndex = -1;
    private final byte[] basesBuffer = new byte[Defaults.NON_ZERO_BUFFER_SIZE];

    public FastaSequenceFile(File file, boolean bl) {
        super(file);
        this.truncateNamesAtWhitespace = bl;
        this.in = new FastLineReader(IOUtil.openFileForReading(file));
    }

    @Override
    public void close() {
        this.in.close();
    }

    @Override
    public ReferenceSequence nextSequence() {
        ++this.sequenceIndex;
        String string = this.readSequenceName();
        if (string == null) {
            this.close();
            return null;
        }
        int n = this.sequenceDictionary == null ? -1 : this.sequenceDictionary.getSequence(this.sequenceIndex).getSequenceLength();
        byte[] byArray = this.readSequence(n);
        return new ReferenceSequence(string, this.sequenceIndex, byArray);
    }

    @Override
    public void reset() {
        this.sequenceIndex = -1;
        this.in.close();
        this.in = new FastLineReader(IOUtil.openFileForReading(this.file));
    }

    private String readSequenceName() {
        this.in.skipNewlines();
        if (this.in.eof()) {
            return null;
        }
        byte by = this.in.getByte();
        if (by != 62) {
            throw new SAMException("Format exception reading FASTA " + this.file + ".  Expected > but saw chr(" + by + ") at start of sequence with index " + this.sequenceIndex);
        }
        byte[] byArray = new byte[4096];
        int n = 0;
        while (!this.in.eof()) {
            if ((n += this.in.readToEndOfOutputBufferOrEoln(byArray, n)) == byArray.length && !this.in.atEoln()) {
                throw new SAMException("Sequence name too long in FASTA " + this.file);
            }
            if (!this.in.atEoln()) continue;
        }
        if (n == 0) {
            throw new SAMException("Missing sequence name in FASTA " + this.file);
        }
        String string = StringUtil.bytesToString(byArray, 0, n).trim();
        if (this.truncateNamesAtWhitespace) {
            string = SAMSequenceRecord.truncateSequenceName(string);
        }
        return string;
    }

    private byte[] readSequence(int n) {
        byte[] byArray = n == -1 ? this.basesBuffer : new byte[n];
        int n2 = 0;
        while (!this.in.eof()) {
            boolean bl = this.in.skipNewlines();
            if (this.in.eof() || bl && this.in.peekByte() == 62) break;
            n2 += this.in.readToEndOfOutputBufferOrEoln(byArray, n2);
            while (n2 > 0 && Character.isWhitespace(StringUtil.byteToChar(byArray[n2 - 1]))) {
                --n2;
            }
            if (n2 == n) break;
            if (n2 != byArray.length) continue;
            byte[] byArray2 = new byte[byArray.length * 2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
        if (n2 != byArray.length || byArray == this.basesBuffer) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, 0, byArray3, 0, n2);
            byArray = byArray3;
        }
        return byArray;
    }
}

