/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class ReferenceSequenceFileWalker
implements Closeable {
    private final ReferenceSequenceFile referenceSequenceFile;
    private ReferenceSequence referenceSequence = null;

    public ReferenceSequenceFileWalker(ReferenceSequenceFile referenceSequenceFile) {
        this.referenceSequenceFile = referenceSequenceFile;
    }

    public ReferenceSequenceFileWalker(File file) {
        this(ReferenceSequenceFileFactory.getReferenceSequenceFile(file));
    }

    public ReferenceSequence get(int n, String string, int n2) {
        this.get(n);
        if (!this.referenceSequence.getName().equals(string)) {
            throw new SAMException("Sequence name mismatch at sequence index (" + this.referenceSequence.getContigIndex() + ", " + this.referenceSequence.getName() + ") != " + string);
        }
        if (this.referenceSequence.getBases().length != n2) {
            throw new SAMException("Sequence length mismatch for (" + n + ", " + string + ").  expected " + n2 + " but found " + this.referenceSequence.getBases().length);
        }
        return this.referenceSequence;
    }

    public ReferenceSequence get(int n) {
        if (this.referenceSequence != null && this.referenceSequence.getContigIndex() == n) {
            return this.referenceSequence;
        }
        if (this.referenceSequence != null && this.referenceSequence.getContigIndex() > n) {
            throw new SAMException("Requesting earlier reference sequence: " + n + " < " + this.referenceSequence.getContigIndex());
        }
        this.referenceSequence = null;
        if (this.referenceSequenceFile.isIndexed()) {
            SAMSequenceRecord sAMSequenceRecord = this.referenceSequenceFile.getSequenceDictionary().getSequence(n);
            if (sAMSequenceRecord != null) {
                this.referenceSequence = this.referenceSequenceFile.getSequence(sAMSequenceRecord.getSequenceName());
            }
        } else {
            do {
                this.referenceSequence = this.referenceSequenceFile.nextSequence();
            } while (this.referenceSequence != null && this.referenceSequence.getContigIndex() < n);
        }
        if (this.referenceSequence == null || this.referenceSequence.getContigIndex() != n) {
            throw new SAMException("Reference sequence (" + n + ") not found in " + ((Object)this.referenceSequenceFile).toString());
        }
        return this.referenceSequence;
    }

    public SAMSequenceDictionary getSequenceDictionary() {
        return this.referenceSequenceFile.getSequenceDictionary();
    }

    @Override
    public void close() throws IOException {
        this.referenceSequenceFile.close();
    }
}

