/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import java.io.Closeable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractAsyncWriter<T>
implements Closeable {
    private static volatile int threadsCreated = 0;
    public static final int DEFAULT_QUEUE_SIZE = 2000;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final BlockingQueue<T> queue;
    private final Thread writer;
    private final WriterRunnable writerRunnable;
    private final AtomicReference<Throwable> ex = new AtomicReference<Object>(null);

    protected abstract String getThreadNamePrefix();

    protected abstract void synchronouslyWrite(T var1);

    protected abstract void synchronouslyClose();

    protected AbstractAsyncWriter(int n) {
        this.queue = new ArrayBlockingQueue<T>(n);
        this.writerRunnable = new WriterRunnable();
        this.writer = new Thread((Runnable)this.writerRunnable, this.getThreadNamePrefix() + threadsCreated++);
        this.writer.setDaemon(true);
        this.writer.start();
    }

    public void write(T t) {
        if (this.isClosed.get()) {
            throw new RuntimeException("Attempt to add record to closed writer.");
        }
        this.checkAndRethrow();
        try {
            this.queue.put(t);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted queueing item for writing.", interruptedException);
        }
        this.checkAndRethrow();
    }

    @Override
    public void close() {
        this.checkAndRethrow();
        if (!this.isClosed.getAndSet(true)) {
            try {
                this.writer.join();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Interrupted waiting on writer thread.", interruptedException);
            }
            if (!this.queue.isEmpty()) {
                throw new RuntimeException("Queue should be empty but is size: " + this.queue.size());
            }
            this.synchronouslyClose();
            this.checkAndRethrow();
        }
    }

    private final void checkAndRethrow() {
        Throwable throwable = this.ex.get();
        if (throwable != null) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    private class WriterRunnable
    implements Runnable {
        private WriterRunnable() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!AbstractAsyncWriter.this.queue.isEmpty() || !AbstractAsyncWriter.this.isClosed.get()) {
                    try {
                        Object e = AbstractAsyncWriter.this.queue.poll(2L, TimeUnit.SECONDS);
                        if (e == null) continue;
                        AbstractAsyncWriter.this.synchronouslyWrite(e);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
            catch (Throwable throwable) {
                AbstractAsyncWriter.this.ex.compareAndSet(null, throwable);
                AbstractAsyncWriter.this.queue.clear();
            }
        }
    }
}

