/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.Iso8601Date;
import java.io.File;
import java.math.RoundingMode;
import java.security.InvalidParameterException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FormatUtil {
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private NumberFormat integerFormat = NumberFormat.getIntegerInstance();
    private NumberFormat floatFormat;

    public FormatUtil() {
        this.integerFormat.setGroupingUsed(false);
        this.floatFormat = NumberFormat.getNumberInstance();
        this.floatFormat.setGroupingUsed(false);
        this.floatFormat.setMaximumFractionDigits(6);
        this.floatFormat.setRoundingMode(RoundingMode.HALF_DOWN);
        if (this.floatFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)this.floatFormat;
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setNaN("?");
            decimalFormatSymbols.setInfinity("?");
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        }
    }

    public String format(short s) {
        return this.integerFormat.format(s);
    }

    public String format(int n) {
        return this.integerFormat.format(n);
    }

    public String format(long l) {
        return this.integerFormat.format(l);
    }

    public String format(float f) {
        return this.floatFormat.format(f);
    }

    public String format(double d) {
        return this.floatFormat.format(d);
    }

    public String format(Enum enum_) {
        return enum_.name();
    }

    public String format(Date date) {
        return this.dateFormat.format(date);
    }

    public String format(Iso8601Date iso8601Date) {
        return iso8601Date.toString();
    }

    public String format(boolean bl) {
        if (bl) {
            return "Y";
        }
        return "N";
    }

    public String format(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Short) {
            return this.format((Short)object);
        }
        if (object instanceof Integer) {
            return this.format((Integer)object);
        }
        if (object instanceof Long) {
            return this.format((Long)object);
        }
        if (object instanceof Float) {
            return this.format(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return this.format((Double)object);
        }
        if (object instanceof Enum) {
            return this.format((Enum)object);
        }
        if (object instanceof Iso8601Date) {
            return this.format((Iso8601Date)object);
        }
        if (object instanceof Date) {
            return this.format((Date)object);
        }
        if (object instanceof Boolean) {
            return this.format((Boolean)object);
        }
        return object.toString();
    }

    public short parseShort(String string) {
        return Short.parseShort(string);
    }

    public int parseInt(String string) {
        return Integer.parseInt(string);
    }

    public long parseLong(String string) {
        return Long.parseLong(string);
    }

    public float parseFloat(String string) {
        if ("?".equals(string) || "-?".equals(string)) {
            return Float.NaN;
        }
        return Float.parseFloat(string);
    }

    public double parseDouble(String string) {
        if ("?".equals(string) || "-?".equals(string)) {
            return Double.NaN;
        }
        return Double.parseDouble(string);
    }

    public <E extends Enum> E parseEnum(String string, Class<E> clazz) {
        return Enum.valueOf(clazz, string);
    }

    public Date parseDate(String string) {
        try {
            return this.dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new SAMException("Could not parse value as date: " + string, parseException);
        }
    }

    public Iso8601Date parseIso8601Date(String string) {
        return new Iso8601Date(string);
    }

    public boolean parseBoolean(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char c = Character.toUpperCase(string.charAt(0));
        return c == 'Y';
    }

    public Object parseObject(String string, Class<?> clazz) {
        if (clazz == Short.class || clazz == Short.TYPE) {
            return this.parseShort(string);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return this.parseInt(string);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return this.parseLong(string);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(this.parseFloat(string));
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return this.parseDouble(string);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return this.parseBoolean(string);
        }
        if (clazz == Iso8601Date.class) {
            return this.parseIso8601Date(string);
        }
        if (clazz == Date.class) {
            return this.parseDate(string);
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return this.parseInt(string);
        }
        if (clazz == File.class) {
            return new File(string);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return this.parseEnum(string, clazz);
        }
        if (clazz == String.class) {
            return string;
        }
        throw new InvalidParameterException("Don't know how to convert a String to a " + clazz.getName());
    }
}

