/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import java.util.Iterator;

public class IntervalUtil {
    public static boolean contains(Interval interval, String string, long l) {
        return interval.getSequence().equals(string) && l >= (long)interval.getStart() && l <= (long)interval.getEnd();
    }

    public static boolean contains(IntervalList intervalList, String string, long l) {
        for (Interval interval : intervalList.uniqued().getIntervals()) {
            if (!IntervalUtil.contains(interval, string, l)) continue;
            return true;
        }
        return false;
    }

    public static void assertOrderedNonOverlapping(Iterator<Interval> iterator, SAMSequenceDictionary sAMSequenceDictionary) {
        if (!iterator.hasNext()) {
            return;
        }
        Interval interval = iterator.next();
        int n = sAMSequenceDictionary.getSequenceIndex(interval.getSequence());
        while (iterator.hasNext()) {
            Interval interval2 = iterator.next();
            if (interval.intersects(interval2)) {
                throw new SAMException("Intervals should not overlap: " + interval + "; " + interval2);
            }
            int n2 = sAMSequenceDictionary.getSequenceIndex(interval2.getSequence());
            if (n > n2 || n == n2 && interval.compareTo(interval2) >= 0) {
                throw new SAMException("Intervals not in order: " + interval + "; " + interval2);
            }
            interval = interval2;
            n = n2;
        }
    }
}

