/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util.ftp;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.seekablestream.UserPasswordInput;
import htsjdk.samtools.util.ftp.FTPClient;
import htsjdk.samtools.util.ftp.FTPReply;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

public class FTPUtils {
    static Map<String, String> userCredentials = new HashMap<String, String>();
    static int TIMEOUT = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resourceAvailable(URL uRL) {
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(TIMEOUT);
            uRLConnection.setReadTimeout(TIMEOUT);
            inputStream = uRLConnection.getInputStream();
            boolean bl = inputStream.read() >= 0;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new SAMException("Error closing connection", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getContentLength(URL uRL) throws IOException {
        FTPClient fTPClient = null;
        try {
            fTPClient = FTPUtils.connect(uRL.getHost(), uRL.getUserInfo(), null);
            String string = fTPClient.executeCommand("size " + uRL.getPath()).getReplyString();
            long l = Integer.parseInt(string);
            return l;
        }
        catch (Exception exception) {
            long l = -1L;
            return l;
        }
        finally {
            if (fTPClient != null) {
                fTPClient.disconnect();
            }
        }
    }

    public static synchronized FTPClient connect(String string, String string2, UserPasswordInput userPasswordInput) throws IOException {
        FTPClient fTPClient = new FTPClient();
        FTPReply fTPReply = fTPClient.connect(string);
        if (!fTPReply.isSuccess()) {
            throw new RuntimeException("Could not connect to " + string);
        }
        String string3 = "anonymous";
        String string4 = "igv@broadinstitute.org";
        if (string2 == null) {
            string2 = userCredentials.get(string);
        }
        if (string2 != null) {
            String[] stringArray = string2.split(":");
            string3 = stringArray[0];
            if (stringArray.length > 1) {
                string4 = stringArray[1];
            }
        }
        if (!(fTPReply = fTPClient.login(string3, string4)).isSuccess()) {
            if (userPasswordInput == null) {
                throw new RuntimeException("Login failure for host: " + string);
            }
            userPasswordInput.setHost(string);
            boolean bl = false;
            while (!bl && userPasswordInput.showDialog()) {
                string3 = userPasswordInput.getUser();
                string4 = userPasswordInput.getPassword();
                fTPReply = fTPClient.login(string3, string4);
                bl = fTPReply.isSuccess();
            }
            if (bl) {
                string2 = string3 + ":" + string4;
                userCredentials.put(string, string2);
            } else {
                throw new RuntimeException("Login failure for host: " + string);
            }
        }
        if (!(fTPReply = fTPClient.binary()).isSuccess()) {
            throw new RuntimeException("Could not set binary mode on host: " + string);
        }
        return fTPClient;
    }
}

