/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble;

import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.LineReader;
import htsjdk.tribble.readers.LineReaderUtil;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.tribble.readers.TabixIteratorLineReader;
import htsjdk.tribble.readers.TabixReader;
import htsjdk.tribble.util.ParsingUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TabixFeatureReader<T extends Feature, SOURCE>
extends AbstractFeatureReader<T, SOURCE> {
    TabixReader tabixReader;
    List<String> sequenceNames;

    public TabixFeatureReader(String string, AsciiFeatureCodec asciiFeatureCodec) throws IOException {
        super(string, asciiFeatureCodec);
        this.tabixReader = new TabixReader(string);
        this.sequenceNames = new ArrayList<String>(this.tabixReader.getChromosomes());
        this.readHeader();
    }

    public TabixFeatureReader(String string, String string2, AsciiFeatureCodec asciiFeatureCodec) throws IOException {
        super(string, asciiFeatureCodec);
        this.tabixReader = new TabixReader(string, string2);
        this.sequenceNames = new ArrayList<String>(this.tabixReader.getChromosomes());
        this.readHeader();
    }

    private void readHeader() throws IOException {
        Object SOURCE = null;
        try {
            SOURCE = this.codec.makeSourceFromStream(new PositionalBufferedStream(new BlockCompressedInputStream(ParsingUtils.openInputStream(this.path))));
            this.header = this.codec.readHeader(SOURCE);
        }
        catch (Exception exception) {
            throw new TribbleException.MalformedFeatureFile("Unable to parse header with error: " + exception.getMessage(), this.path, exception);
        }
        finally {
            if (SOURCE != null) {
                this.codec.close(SOURCE);
            }
        }
    }

    @Override
    public boolean hasIndex() {
        return true;
    }

    @Override
    public List<String> getSequenceNames() {
        return this.sequenceNames;
    }

    @Override
    public CloseableTribbleIterator<T> query(String string, int n, int n2) throws IOException {
        List<String> list = this.getSequenceNames();
        if (list == null) {
            throw new TribbleException.TabixReaderFailure("Unable to find sequence named " + string + " in the tabix index. ", this.path);
        }
        if (!list.contains(string)) {
            return new AbstractFeatureReader.EmptyIterator();
        }
        TabixIteratorLineReader tabixIteratorLineReader = new TabixIteratorLineReader(this.tabixReader.query(this.tabixReader.chr2tid(string), n - 1, n2));
        return new FeatureIterator(tabixIteratorLineReader, n - 1, n2);
    }

    @Override
    public CloseableTribbleIterator<T> iterator() throws IOException {
        BlockCompressedInputStream blockCompressedInputStream = new BlockCompressedInputStream(ParsingUtils.openInputStream(this.path));
        PositionalBufferedStream positionalBufferedStream = new PositionalBufferedStream(blockCompressedInputStream);
        LineReader lineReader = LineReaderUtil.fromBufferedStream(positionalBufferedStream, LineReaderUtil.LineReaderOption.SYNCHRONOUS);
        return new FeatureIterator(lineReader, 0, Integer.MAX_VALUE);
    }

    @Override
    public void close() throws IOException {
        this.tabixReader.close();
    }

    class FeatureIterator<T extends Feature>
    implements CloseableTribbleIterator<T> {
        private T currentRecord;
        private LineReader lineReader;
        private int start;
        private int end;

        public FeatureIterator(LineReader lineReader, int n, int n2) throws IOException {
            this.lineReader = lineReader;
            this.start = n;
            this.end = n2;
            this.readNextRecord();
        }

        protected void readNextRecord() throws IOException {
            String string;
            this.currentRecord = null;
            while (this.currentRecord == null && (string = this.lineReader.readLine()) != null) {
                try {
                    Object t = ((AsciiFeatureCodec)TabixFeatureReader.this.codec).decode(string);
                    if (t == null) continue;
                    if (t.getStart() > this.end) {
                        return;
                    }
                    if (t.getEnd() <= this.start) continue;
                    this.currentRecord = t;
                }
                catch (TribbleException tribbleException) {
                    tribbleException.setSource(TabixFeatureReader.this.path);
                    throw tribbleException;
                }
                catch (NumberFormatException numberFormatException) {
                    String string2 = "Error parsing line: " + string;
                    throw new TribbleException.MalformedFeatureFile(string2, TabixFeatureReader.this.path, numberFormatException);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public T next() {
            T t = this.currentRecord;
            try {
                this.readNextRecord();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to read the next record, the last record was at " + t.getChr() + ":" + t.getStart() + "-" + t.getEnd(), iOException);
            }
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported in Iterators");
        }

        @Override
        public void close() {
            this.lineReader.close();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }
}

