/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.seekablestream.SeekableStreamFactory;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.Tribble;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.index.Block;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexFactory;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.tribble.util.ParsingUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class TribbleIndexedFeatureReader<T extends Feature, SOURCE>
extends AbstractFeatureReader<T, SOURCE> {
    private Index index;
    private final boolean pathIsRegularFile;
    private SeekableStream seekableStream = null;
    private boolean needCheckForIndex = true;

    public TribbleIndexedFeatureReader(String string, FeatureCodec<T, SOURCE> featureCodec, boolean bl) throws IOException {
        super(string, featureCodec);
        if (bl) {
            this.loadIndex();
            if (!this.hasIndex()) {
                throw new TribbleException("An index is required, but none found.");
            }
        }
        this.pathIsRegularFile = SeekableStreamFactory.isFilePath(this.path);
        this.readHeader();
    }

    public TribbleIndexedFeatureReader(String string, String string2, FeatureCodec<T, SOURCE> featureCodec, boolean bl) throws IOException {
        this(string, featureCodec, false);
        if (string2 != null && ParsingUtils.resourceExists(string2)) {
            this.index = IndexFactory.loadIndex(string2);
            this.needCheckForIndex = false;
        } else if (bl) {
            if (!this.hasIndex()) {
                throw new TribbleException("An index is required, but none found.");
            }
        }
    }

    public TribbleIndexedFeatureReader(String string, FeatureCodec<T, SOURCE> featureCodec, Index index) throws IOException {
        this(string, featureCodec, false);
        this.index = index;
        this.needCheckForIndex = false;
    }

    private void loadIndex() throws IOException {
        String string = Tribble.indexFile(this.path);
        if (ParsingUtils.resourceExists(string)) {
            this.index = IndexFactory.loadIndex(string);
        } else if (ParsingUtils.resourceExists(string = ParsingUtils.appendToPath(string, ".gz"))) {
            this.index = IndexFactory.loadIndex(string);
        }
        this.needCheckForIndex = false;
    }

    private SeekableStream getSeekableStream() throws IOException {
        SeekableStream seekableStream;
        if (this.reuseStreamInQuery()) {
            if (this.seekableStream == null) {
                this.seekableStream = SeekableStreamFactory.getInstance().getStreamFor(this.path);
            }
            seekableStream = this.seekableStream;
        } else {
            seekableStream = SeekableStreamFactory.getInstance().getStreamFor(this.path);
        }
        return seekableStream;
    }

    private boolean reuseStreamInQuery() {
        return this.pathIsRegularFile;
    }

    @Override
    public void close() throws IOException {
        if (this.seekableStream != null) {
            this.seekableStream.close();
        }
    }

    @Override
    public List<String> getSequenceNames() {
        return !this.hasIndex() ? new ArrayList<String>() : new ArrayList<String>(this.index.getSequenceNames());
    }

    @Override
    public boolean hasIndex() {
        if (this.index == null && this.needCheckForIndex) {
            try {
                this.loadIndex();
            }
            catch (IOException iOException) {
                throw new TribbleException("Error loading index file: " + iOException.getMessage(), iOException);
            }
        }
        return this.index != null;
    }

    private void readHeader() throws IOException {
        InputStream inputStream = null;
        PositionalBufferedStream positionalBufferedStream = null;
        try {
            inputStream = ParsingUtils.openInputStream(this.path);
            if (this.path.endsWith("gz")) {
                inputStream = new GZIPInputStream(new BufferedInputStream(inputStream));
            }
            positionalBufferedStream = new PositionalBufferedStream(inputStream);
            Object SOURCE = this.codec.makeSourceFromStream(positionalBufferedStream);
            this.header = this.codec.readHeader(SOURCE);
        }
        catch (Exception exception) {
            throw new TribbleException.MalformedFeatureFile("Unable to parse header with error: " + exception.getMessage(), this.path, exception);
        }
        finally {
            if (positionalBufferedStream != null) {
                positionalBufferedStream.close();
            } else if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    public CloseableTribbleIterator<T> query(String string, int n, int n2) throws IOException {
        if (!this.hasIndex()) {
            throw new TribbleException("Index not found for: " + this.path);
        }
        if (this.index.containsChromosome(string)) {
            List<Block> list = this.index.getBlocks(string, n - 1, n2);
            return new QueryIterator(string, n, n2, list);
        }
        return new AbstractFeatureReader.EmptyIterator();
    }

    @Override
    public CloseableTribbleIterator<T> iterator() throws IOException {
        return new WFIterator();
    }

    static class BlockStreamWrapper
    extends InputStream {
        SeekableStream seekableStream;
        long maxPosition;

        BlockStreamWrapper(SeekableStream seekableStream, Block block) throws IOException {
            this.seekableStream = seekableStream;
            seekableStream.seek(block.getStartPosition());
            this.maxPosition = block.getEndPosition();
        }

        @Override
        public int read() throws IOException {
            return this.seekableStream.position() > this.maxPosition ? -1 : this.seekableStream.read();
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            long l = this.maxPosition - this.seekableStream.position();
            if (l <= 0L) {
                return -1;
            }
            int n3 = (int)Math.min((long)n2, Math.min(l, Integer.MAX_VALUE));
            return this.seekableStream.read(byArray, n, n3);
        }
    }

    class QueryIterator
    implements CloseableTribbleIterator<T> {
        private String chrAlias;
        int start;
        int end;
        private T currentRecord;
        private SOURCE source;
        private SeekableStream mySeekableStream;
        private Iterator<Block> blockIterator;

        public QueryIterator(String string, int n, int n2, List<Block> list) throws IOException {
            this.start = n;
            this.end = n2;
            this.mySeekableStream = TribbleIndexedFeatureReader.this.getSeekableStream();
            this.blockIterator = list.iterator();
            this.advanceBlock();
            this.readNextRecord();
            this.chrAlias = this.currentRecord == null ? string : this.currentRecord.getChr();
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public T next() {
            Object t = this.currentRecord;
            try {
                this.readNextRecord();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to read the next record, the last record was at " + t.getChr() + ":" + t.getStart() + "-" + t.getEnd(), iOException);
            }
            return t;
        }

        private void advanceBlock() throws IOException {
            while (this.blockIterator != null && this.blockIterator.hasNext()) {
                Block block = this.blockIterator.next();
                if (block.getSize() <= 0L) continue;
                int n = Math.min(2000000, block.getSize() > 100000000L ? 10000000 : (int)block.getSize());
                this.source = TribbleIndexedFeatureReader.this.codec.makeSourceFromStream(new PositionalBufferedStream(new BlockStreamWrapper(this.mySeekableStream, block), n));
                return;
            }
            if (this.source != null) {
                TribbleIndexedFeatureReader.this.codec.close(this.source);
                this.source = null;
            }
        }

        private void readNextRecord() throws IOException {
            if (this.source == null) {
                return;
            }
            this.currentRecord = null;
            while (true) {
                if (!TribbleIndexedFeatureReader.this.codec.isDone(this.source)) {
                    try {
                        Object FEATURE_TYPE = TribbleIndexedFeatureReader.this.codec.decode(this.source);
                        if (FEATURE_TYPE == null) continue;
                        if (this.chrAlias != null && !FEATURE_TYPE.getChr().equals(this.chrAlias) || FEATURE_TYPE.getStart() > this.end) {
                            if (this.blockIterator.hasNext()) {
                                this.advanceBlock();
                                continue;
                            }
                            return;
                        }
                        if (FEATURE_TYPE.getEnd() < this.start) continue;
                        this.currentRecord = FEATURE_TYPE;
                        return;
                    }
                    catch (TribbleException tribbleException) {
                        tribbleException.setSource(TribbleIndexedFeatureReader.this.path);
                        throw tribbleException;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string = "Error parsing line: " + this.source;
                        throw new TribbleException.MalformedFeatureFile(string, TribbleIndexedFeatureReader.this.path, numberFormatException);
                    }
                }
                if (this.blockIterator == null || !this.blockIterator.hasNext()) break;
                this.advanceBlock();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }

        @Override
        public void close() {
            TribbleIndexedFeatureReader.this.codec.close(this.source);
            if (!TribbleIndexedFeatureReader.this.reuseStreamInQuery()) {
                try {
                    this.mySeekableStream.close();
                }
                catch (IOException iOException) {
                    throw new TribbleException("Couldn't close seekable stream", iOException);
                }
            }
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }

    class WFIterator
    implements CloseableTribbleIterator<T> {
        private T currentRecord;
        private SOURCE source;

        public WFIterator() throws IOException {
            PositionalBufferedStream positionalBufferedStream;
            InputStream inputStream = ParsingUtils.openInputStream(TribbleIndexedFeatureReader.this.path);
            if (TribbleIndexedFeatureReader.this.path.endsWith(".gz")) {
                GZIPInputStream gZIPInputStream = new GZIPInputStream(new BufferedInputStream(inputStream, 512000));
                positionalBufferedStream = new PositionalBufferedStream(gZIPInputStream, 1000);
            } else {
                positionalBufferedStream = new PositionalBufferedStream(inputStream, 512000);
            }
            positionalBufferedStream.skip(TribbleIndexedFeatureReader.this.header.getHeaderEnd());
            this.source = TribbleIndexedFeatureReader.this.codec.makeSourceFromStream(positionalBufferedStream);
            this.readNextRecord();
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public T next() {
            Object t = this.currentRecord;
            try {
                this.readNextRecord();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to read the next record, the last record was at " + t.getChr() + ":" + t.getStart() + "-" + t.getEnd(), iOException);
            }
            return t;
        }

        private void readNextRecord() throws IOException {
            this.currentRecord = null;
            while (!TribbleIndexedFeatureReader.this.codec.isDone(this.source)) {
                try {
                    Object FEATURE_TYPE = TribbleIndexedFeatureReader.this.codec.decode(this.source);
                    if (FEATURE_TYPE == null) continue;
                    this.currentRecord = FEATURE_TYPE;
                    return;
                }
                catch (TribbleException tribbleException) {
                    tribbleException.setSource(TribbleIndexedFeatureReader.this.path);
                    throw tribbleException;
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "Error parsing line at byte position: " + this.source;
                    throw new TribbleException.MalformedFeatureFile(string, TribbleIndexedFeatureReader.this.path, numberFormatException);
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported in Iterators");
        }

        @Override
        public void close() {
            TribbleIndexedFeatureReader.this.codec.close(this.source);
        }

        public WFIterator iterator() {
            return this;
        }
    }
}

