/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.dbsnp;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.annotation.Strand;
import htsjdk.tribble.dbsnp.OldDbSNPFeature;
import htsjdk.tribble.readers.LineIterator;

public class OldDbSNPCodec
extends AsciiFeatureCodec<OldDbSNPFeature> {
    static final int expectedTokenCount = 18;

    public OldDbSNPCodec() {
        super(OldDbSNPFeature.class);
    }

    @Override
    public Feature decodeLoc(String string) {
        return this.decode(string);
    }

    @Override
    public OldDbSNPFeature decode(String string) {
        if (string.startsWith("#")) {
            return null;
        }
        String[] stringArray = string.split("\\t+");
        return this.decode(stringArray);
    }

    @Override
    public Object readActualHeader(LineIterator lineIterator) {
        return null;
    }

    @Override
    public OldDbSNPFeature decode(String[] stringArray) {
        if (stringArray.length != 18) {
            return null;
        }
        int n = Integer.valueOf(stringArray[2]) + 1;
        int n2 = Integer.valueOf(stringArray[3]);
        n2 = n2 < n ? n : n2;
        OldDbSNPFeature oldDbSNPFeature = new OldDbSNPFeature(stringArray[1], n, n2);
        oldDbSNPFeature.setRsID(stringArray[4]);
        oldDbSNPFeature.setScore(Integer.valueOf(stringArray[5]));
        oldDbSNPFeature.setStrand(stringArray[6].equals("+") ? Strand.POSITIVE : Strand.NEGATIVE);
        oldDbSNPFeature.setNCBIRefBase(stringArray[7]);
        oldDbSNPFeature.setUCSCRefBase(stringArray[8]);
        oldDbSNPFeature.setObserved(stringArray[9].split("/"));
        oldDbSNPFeature.setMolType(stringArray[10]);
        oldDbSNPFeature.setVariantType(stringArray[11]);
        oldDbSNPFeature.setValidationStatus(stringArray[12]);
        oldDbSNPFeature.setAvHet(Double.valueOf(stringArray[13]));
        oldDbSNPFeature.setAvHetSE(Double.valueOf(stringArray[14]));
        oldDbSNPFeature.setFunction(stringArray[15]);
        oldDbSNPFeature.setLocationType(stringArray[16]);
        oldDbSNPFeature.setWeight(Integer.valueOf(stringArray[17]));
        return oldDbSNPFeature;
    }
}

