/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.example;

import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.BasicFeature;
import htsjdk.tribble.BinaryFeatureCodec;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.FeatureReader;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.PositionalBufferedStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class ExampleBinaryCodec
extends BinaryFeatureCodec<Feature> {
    public static final String HEADER_LINE = "# BinaryTestFeature";

    @Override
    public Feature decodeLoc(PositionalBufferedStream positionalBufferedStream) throws IOException {
        return this.decode(positionalBufferedStream);
    }

    @Override
    public Feature decode(PositionalBufferedStream positionalBufferedStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(positionalBufferedStream);
        String string = dataInputStream.readUTF();
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        return new BasicFeature(string, n, n2);
    }

    @Override
    public FeatureCodecHeader readHeader(PositionalBufferedStream positionalBufferedStream) throws IOException {
        AsciiLineReader asciiLineReader = new AsciiLineReader(positionalBufferedStream);
        ArrayList<String> arrayList = new ArrayList<String>();
        long l = 0L;
        while (positionalBufferedStream.peek() == 35) {
            arrayList.add(asciiLineReader.readLine());
            l = positionalBufferedStream.getPosition();
        }
        return new FeatureCodecHeader(arrayList, l);
    }

    @Override
    public Class<Feature> getFeatureType() {
        return Feature.class;
    }

    @Override
    public boolean canDecode(String string) {
        return false;
    }

    public static <FEATURE_TYPE extends Feature> void convertToBinaryTest(File file, File file2, FeatureCodec<FEATURE_TYPE, LineIterator> featureCodec) throws IOException {
        AbstractFeatureReader<FEATURE_TYPE, LineIterator> abstractFeatureReader = AbstractFeatureReader.getFeatureReader(file.getAbsolutePath(), featureCodec, false);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ExampleBinaryCodec.convertToBinaryTest(abstractFeatureReader, fileOutputStream);
    }

    public static <FEATURE_TYPE extends Feature> void convertToBinaryTest(FeatureReader<FEATURE_TYPE> featureReader, OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeBytes("# BinaryTestFeature\n");
        CloseableTribbleIterator<FEATURE_TYPE> closeableTribbleIterator = featureReader.iterator();
        while (closeableTribbleIterator.hasNext()) {
            Feature feature = (Feature)closeableTribbleIterator.next();
            dataOutputStream.writeUTF(feature.getChr());
            dataOutputStream.writeInt(feature.getStart());
            dataOutputStream.writeInt(feature.getEnd());
        }
        dataOutputStream.close();
        featureReader.close();
    }
}

