/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.LocationAware;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.index.DynamicIndexCreator;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.interval.IntervalIndexCreator;
import htsjdk.tribble.index.interval.IntervalTreeIndex;
import htsjdk.tribble.index.linear.LinearIndex;
import htsjdk.tribble.index.linear.LinearIndexCreator;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.index.tabix.TabixIndex;
import htsjdk.tribble.index.tabix.TabixIndexCreator;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.tribble.util.LittleEndianInputStream;
import htsjdk.tribble.util.LittleEndianOutputStream;
import htsjdk.tribble.util.ParsingUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;

public class IndexFactory {
    public static Index loadIndex(String string) {
        Object var1_1 = null;
        BufferedInputStream bufferedInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            InputStream inputStream = ParsingUtils.openInputStream(string);
            if (string.endsWith(".gz")) {
                inputStream = new GZIPInputStream(inputStream);
            } else if (string.endsWith(".tbi")) {
                inputStream = new BlockCompressedInputStream(inputStream);
            }
            bufferedInputStream = new BufferedInputStream(inputStream, Defaults.NON_ZERO_BUFFER_SIZE);
            Class clazz = IndexType.getIndexType(bufferedInputStream).getIndexType();
            Constructor constructor = clazz.getConstructor(InputStream.class);
            Index index = (Index)constructor.newInstance(bufferedInputStream);
            return index;
        }
        catch (IOException iOException) {
            throw new TribbleException.UnableToReadIndexFile("Unable to read index file", string, iOException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static LinearIndex createLinearIndex(File file, FeatureCodec featureCodec) {
        return IndexFactory.createLinearIndex(file, featureCodec, LinearIndexCreator.DEFAULT_BIN_WIDTH);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> LinearIndex createLinearIndex(File file, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> featureCodec, int n) {
        LinearIndexCreator linearIndexCreator = new LinearIndexCreator(file, n);
        return (LinearIndex)IndexFactory.createIndex(file, new FeatureIterator<FEATURE_TYPE, SOURCE_TYPE>(file, featureCodec), linearIndexCreator);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> IntervalTreeIndex createIntervalIndex(File file, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> featureCodec) {
        return IndexFactory.createIntervalIndex(file, featureCodec, IntervalIndexCreator.DEFAULT_FEATURE_COUNT);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> IntervalTreeIndex createIntervalIndex(File file, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> featureCodec, int n) {
        IntervalIndexCreator intervalIndexCreator = new IntervalIndexCreator(file, n);
        return (IntervalTreeIndex)IndexFactory.createIndex(file, new FeatureIterator<FEATURE_TYPE, SOURCE_TYPE>(file, featureCodec), intervalIndexCreator);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createDynamicIndex(File file, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> featureCodec) {
        return IndexFactory.createDynamicIndex(file, featureCodec, IndexBalanceApproach.FOR_SEEK_TIME);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createIndex(File file, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> featureCodec, IndexType indexType) {
        switch (indexType) {
            case INTERVAL_TREE: {
                return IndexFactory.createIntervalIndex(file, featureCodec);
            }
            case LINEAR: {
                return IndexFactory.createLinearIndex(file, featureCodec);
            }
            case TABIX: {
                throw new UnsupportedOperationException("Tabix indices cannot be created through a generic interface");
            }
        }
        throw new IllegalArgumentException("Unrecognized IndexType " + (Object)((Object)indexType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeIndex(Index index, File file) throws IOException {
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            index.write((LittleEndianOutputStream)filterOutputStream);
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createDynamicIndex(File file, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> featureCodec, IndexBalanceApproach indexBalanceApproach) {
        DynamicIndexCreator dynamicIndexCreator = new DynamicIndexCreator(file, indexBalanceApproach);
        return IndexFactory.createIndex(file, new FeatureIterator<FEATURE_TYPE, SOURCE_TYPE>(file, featureCodec), dynamicIndexCreator);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> TabixIndex createTabixIndex(File file, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> featureCodec, TabixFormat tabixFormat, SAMSequenceDictionary sAMSequenceDictionary) {
        TabixIndexCreator tabixIndexCreator = new TabixIndexCreator(sAMSequenceDictionary, tabixFormat);
        return (TabixIndex)IndexFactory.createIndex(file, new FeatureIterator<FEATURE_TYPE, SOURCE_TYPE>(file, featureCodec), tabixIndexCreator);
    }

    private static Index createIndex(File file, FeatureIterator featureIterator, IndexCreator indexCreator) {
        Feature feature = null;
        HashMap<String, Feature> hashMap = new HashMap<String, Feature>(40);
        while (featureIterator.hasNext()) {
            String string;
            long l = featureIterator.getPosition();
            Feature feature2 = featureIterator.next();
            IndexFactory.checkSorted(file, feature, feature2);
            String string2 = feature2.getChr();
            String string3 = string = feature != null ? feature.getChr() : null;
            if (!string2.equals(string)) {
                if (hashMap.containsKey(string2)) {
                    String string4 = "Input file must have contiguous chromosomes.";
                    string4 = string4 + " Saw feature " + IndexFactory.featToString((Feature)hashMap.get(string2));
                    string4 = string4 + " followed later by " + IndexFactory.featToString(feature);
                    string4 = string4 + " and then " + IndexFactory.featToString(feature2);
                    throw new TribbleException.MalformedFeatureFile(string4, file.getAbsolutePath());
                }
                hashMap.put(string2, feature2);
            }
            indexCreator.addFeature(feature2, l);
            feature = feature2;
        }
        featureIterator.close();
        return indexCreator.finalizeIndex(featureIterator.getPosition());
    }

    private static String featToString(Feature feature) {
        return feature.getChr() + ":" + feature.getStart() + "-" + feature.getEnd();
    }

    private static void checkSorted(File file, Feature feature, Feature feature2) {
        if (feature != null && feature2.getStart() < feature.getStart() && feature.getChr().equals(feature2.getChr())) {
            throw new TribbleException.MalformedFeatureFile("Input file is not sorted by start position. \nWe saw a record with a start of " + feature2.getChr() + ":" + feature2.getStart() + " after a record with a start of " + feature.getChr() + ":" + feature.getStart(), file.getAbsolutePath());
        }
    }

    static class FeatureIterator<FEATURE_TYPE extends Feature, SOURCE>
    implements CloseableTribbleIterator<Feature> {
        private final SOURCE source;
        private Feature nextFeature;
        private final FeatureCodec<FEATURE_TYPE, SOURCE> codec;
        private final File inputFile;
        private long cachedPosition;

        public FeatureIterator(File file, FeatureCodec<FEATURE_TYPE, SOURCE> featureCodec) {
            this.codec = featureCodec;
            this.inputFile = file;
            FeatureCodecHeader featureCodecHeader = this.readHeader();
            this.source = featureCodec.makeIndexableSourceFromStream(this.initStream(file, featureCodecHeader.getHeaderEnd()));
            this.readNextFeature();
        }

        private FeatureCodecHeader readHeader() {
            try {
                SOURCE SOURCE = this.codec.makeSourceFromStream(this.initStream(this.inputFile, 0L));
                FeatureCodecHeader featureCodecHeader = this.codec.readHeader(SOURCE);
                this.codec.close(SOURCE);
                return featureCodecHeader;
            }
            catch (IOException iOException) {
                throw new TribbleException.InvalidHeader("Error reading header " + iOException.getMessage());
            }
        }

        private PositionalBufferedStream initStream(File file, long l) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                PositionalBufferedStream positionalBufferedStream = new PositionalBufferedStream(fileInputStream);
                if (l > 0L) {
                    positionalBufferedStream.skip(l);
                }
                return positionalBufferedStream;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new TribbleException.FeatureFileDoesntExist("Unable to open the input file, most likely the file doesn't exist.", file.getAbsolutePath());
            }
            catch (IOException iOException) {
                throw new TribbleException.MalformedFeatureFile("Error initializing stream", file.getAbsolutePath(), iOException);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextFeature != null;
        }

        @Override
        public Feature next() {
            Feature feature = this.nextFeature;
            this.readNextFeature();
            return feature;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("We cannot remove");
        }

        public long getPosition() {
            return this.hasNext() ? this.cachedPosition : ((LocationAware)this.source).getPosition();
        }

        @Override
        public Iterator<Feature> iterator() {
            return this;
        }

        @Override
        public void close() {
            this.codec.close(this.source);
        }

        private void readNextFeature() {
            this.cachedPosition = ((LocationAware)this.source).getPosition();
            try {
                this.nextFeature = null;
                while (this.nextFeature == null && !this.codec.isDone(this.source)) {
                    this.nextFeature = this.codec.decodeLoc(this.source);
                }
            }
            catch (IOException iOException) {
                throw new TribbleException.MalformedFeatureFile("Unable to read a line from the file", this.inputFile.getAbsolutePath(), iOException);
            }
        }
    }

    public static enum IndexType {
        LINEAR(1480870228, LinearIndex.INDEX_TYPE, LinearIndexCreator.class, LinearIndex.class, LinearIndexCreator.DEFAULT_BIN_WIDTH),
        INTERVAL_TREE(1480870228, IntervalTreeIndex.INDEX_TYPE, IntervalIndexCreator.class, IntervalTreeIndex.class, IntervalIndexCreator.DEFAULT_FEATURE_COUNT),
        TABIX(TabixIndex.MAGIC_NUMBER, null, null, TabixIndex.class, -1);

        private final int magicNumber;
        private final Integer tribbleIndexType;
        private final Class<IndexCreator> indexCreatorClass;
        private final int defaultBinSize;
        private final Class<Index> indexType;

        public int getDefaultBinSize() {
            return this.defaultBinSize;
        }

        public IndexCreator getIndexCreator() {
            try {
                return this.indexCreatorClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new TribbleException("Couldn't make index creator in " + (Object)((Object)this), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new TribbleException("Couldn't make index creator in " + (Object)((Object)this), illegalAccessException);
            }
        }

        public boolean canCreate() {
            return this.indexCreatorClass != null;
        }

        private IndexType(int n2, Integer n3, Class clazz, Class clazz2, int n4) {
            this.magicNumber = n2;
            this.tribbleIndexType = n3;
            this.indexCreatorClass = clazz;
            this.indexType = clazz2;
            this.defaultBinSize = n4;
        }

        public Integer getTribbleIndexType() {
            return this.tribbleIndexType;
        }

        public Class getIndexType() {
            return this.indexType;
        }

        public int getMagicNumber() {
            return this.magicNumber;
        }

        public static IndexType getIndexType(BufferedInputStream bufferedInputStream) {
            int n;
            int n2;
            bufferedInputStream.mark(128);
            LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(bufferedInputStream);
            try {
                n2 = littleEndianInputStream.readInt();
                n = littleEndianInputStream.readInt();
                bufferedInputStream.reset();
                for (IndexType indexType : IndexType.values()) {
                    if (indexType.magicNumber != n2 || indexType.tribbleIndexType != null && indexType.tribbleIndexType != n) continue;
                    return indexType;
                }
            }
            catch (IOException iOException) {
                throw new TribbleException("Problem detecting index type", iOException);
            }
            throw new TribbleException.UnableToCreateCorrectIndexType(String.format("Unknown index type.  magic number: 0x%x; type %d", n2, n));
        }
    }

    public static enum IndexBalanceApproach {
        FOR_SIZE,
        FOR_SEEK_TIME;

    }
}

