/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index.linear;

import htsjdk.tribble.index.AbstractIndex;
import htsjdk.tribble.index.Block;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.util.LittleEndianInputStream;
import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LinearIndex
extends AbstractIndex {
    public static final double MAX_FEATURES_PER_BIN = Double.valueOf(System.getProperty("MAX_FEATURES_PER_BIN", "100"));
    public static final int INDEX_TYPE = AbstractIndex.IndexType.LINEAR.fileHeaderTypeIdentifier;
    private static final int MAX_BIN_WIDTH = 1000000000;
    private static final long MAX_BIN_WIDTH_FOR_OCCUPIED_CHR_INDEX = Long.valueOf(System.getProperty("MAX_BIN_WIDTH_FOR_OCCUPIED_CHR_INDEX", "1024000"));
    public static boolean enableAdaptiveIndexing = true;

    public LinearIndex(List<ChrIndex> list, File file) {
        super(file.getAbsolutePath());
        for (ChrIndex chrIndex : list) {
            this.chrIndices.put(chrIndex.getName(), chrIndex);
        }
    }

    private LinearIndex(LinearIndex linearIndex, List<ChrIndex> list) {
        super(linearIndex);
        for (ChrIndex chrIndex : list) {
            this.chrIndices.put(chrIndex.getName(), chrIndex);
        }
    }

    public LinearIndex(String string) {
        super(string);
    }

    public LinearIndex(InputStream inputStream) throws IOException {
        LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(inputStream);
        this.validateIndexHeader(INDEX_TYPE, littleEndianInputStream);
        this.read(littleEndianInputStream);
    }

    @Override
    public boolean isCurrentVersion() {
        if (!super.isCurrentVersion()) {
            return false;
        }
        for (htsjdk.tribble.index.ChrIndex chrIndex : this.chrIndices.values()) {
            if (!((ChrIndex)chrIndex).OLD_V3_INDEX) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int getType() {
        return INDEX_TYPE;
    }

    @Override
    public List<String> getSequenceNames() {
        return this.chrIndices == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(new ArrayList(this.chrIndices.keySet()));
    }

    @Override
    public Class getChrIndexClass() {
        return ChrIndex.class;
    }

    public Index optimize(double d) {
        if (enableAdaptiveIndexing) {
            ArrayList<ChrIndex> arrayList = new ArrayList<ChrIndex>(this.chrIndices.size());
            for (String string : this.chrIndices.keySet()) {
                ChrIndex chrIndex = (ChrIndex)this.chrIndices.get(string);
                ChrIndex chrIndex2 = chrIndex.optimize(d);
                arrayList.add(chrIndex2);
            }
            return new LinearIndex(this, arrayList);
        }
        return this;
    }

    public Index optimize() {
        return this.optimize(MAX_FEATURES_PER_BIN);
    }

    public void writeTable(PrintStream printStream) {
        printStream.printf("chr binWidth avg.feature.size nFeatures.total block.id start.pos size nFeatures%n", new Object[0]);
        for (String string : this.chrIndices.keySet()) {
            ChrIndex chrIndex = (ChrIndex)this.chrIndices.get(string);
            int n = 0;
            for (Block block : chrIndex.getBlocks()) {
                printStream.printf("%s %d %.2f %d %d %d %d %d%n", string, chrIndex.binWidth, chrIndex.getAverageFeatureSize(), chrIndex.getNFeatures(), n, n * chrIndex.binWidth, block.getSize(), (int)((double)block.getSize() / chrIndex.getAverageFeatureSize()));
                ++n;
            }
        }
    }

    protected final void setTS(long l) {
        this.indexedFileTS = l;
    }

    public static class ChrIndex
    implements htsjdk.tribble.index.ChrIndex {
        private String name = "";
        private int binWidth;
        private int longestFeature;
        private int nFeatures;
        private List<Block> blocks;
        private boolean OLD_V3_INDEX = false;

        public ChrIndex() {
        }

        ChrIndex(String string, int n) {
            this.name = string;
            this.binWidth = n;
            this.blocks = new ArrayList<Block>(100);
            this.longestFeature = 0;
            this.nFeatures = 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        void addBlock(Block block) {
            this.blocks.add(block);
        }

        public int getNBlocks() {
            return this.blocks.size();
        }

        @Override
        public List<Block> getBlocks() {
            return this.blocks;
        }

        @Override
        public List<Block> getBlocks(int n, int n2) {
            if (this.blocks.isEmpty()) {
                return Collections.emptyList();
            }
            int n3 = Math.max(n - this.longestFeature, 0);
            int n4 = n3 / this.binWidth;
            if (n4 >= this.blocks.size()) {
                return Collections.emptyList();
            }
            int n5 = Math.min((n2 - 1) / this.binWidth, this.blocks.size() - 1);
            long l = this.blocks.get(n4).getStartPosition();
            long l2 = this.blocks.get(n5).getStartPosition() + this.blocks.get(n5).getSize();
            long l3 = l2 - l;
            if (l3 == 0L) {
                return Collections.EMPTY_LIST;
            }
            Block block = new Block(l, l3);
            return Arrays.asList(block);
        }

        public void updateLongestFeature(int n) {
            this.longestFeature = Math.max(this.longestFeature, n);
        }

        public int getNFeatures() {
            return this.nFeatures;
        }

        public void incrementFeatureCount() {
            ++this.nFeatures;
        }

        @Override
        public void write(LittleEndianOutputStream littleEndianOutputStream) throws IOException {
            littleEndianOutputStream.writeString(this.name);
            littleEndianOutputStream.writeInt(this.binWidth);
            littleEndianOutputStream.writeInt(this.blocks.size());
            littleEndianOutputStream.writeInt(this.longestFeature);
            littleEndianOutputStream.writeInt(0);
            littleEndianOutputStream.writeInt(this.nFeatures);
            long l = 0L;
            long l2 = 0L;
            for (Block block : this.blocks) {
                l = block.getStartPosition();
                l2 = block.getSize();
                littleEndianOutputStream.writeLong(l);
            }
            littleEndianOutputStream.writeLong(l + l2);
        }

        @Override
        public void read(LittleEndianInputStream littleEndianInputStream) throws IOException {
            this.name = littleEndianInputStream.readString();
            this.binWidth = littleEndianInputStream.readInt();
            int n = littleEndianInputStream.readInt();
            this.longestFeature = littleEndianInputStream.readInt();
            this.OLD_V3_INDEX = littleEndianInputStream.readInt() > 0;
            this.nFeatures = littleEndianInputStream.readInt();
            this.blocks = new ArrayList<Block>(n);
            long l = littleEndianInputStream.readLong();
            for (int i = 0; i < n; ++i) {
                long l2 = littleEndianInputStream.readLong();
                long l3 = l2 - l;
                this.blocks.add(new Block(l, l3));
                l = l2;
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ChrIndex)) {
                return false;
            }
            ChrIndex chrIndex = (ChrIndex)object;
            return this.binWidth == chrIndex.binWidth && this.longestFeature == chrIndex.longestFeature && this.nFeatures == chrIndex.nFeatures && this.name.equals(chrIndex.name) && ((Object)this.blocks).equals(chrIndex.blocks);
        }

        public long getTotalSize() {
            long l = 0L;
            for (Block block : this.getBlocks()) {
                l += block.getSize();
            }
            return l;
        }

        public double getAverageFeatureSize() {
            return 1.0 * (double)this.getTotalSize() / (double)this.getNFeatures();
        }

        public double getFeaturesPerBlock() {
            return 1.0 * (double)this.getNFeatures() / (double)this.getNBlocks();
        }

        private double getNFeaturesOfMostDenseBlock(double d) {
            double d2 = -1.0;
            for (Block block : this.getBlocks()) {
                double d3 = (double)block.getSize() / d;
                if (d2 != -1.0 && !(d3 > d2)) continue;
                d2 = d3;
            }
            return d2;
        }

        private double optimizeScore() {
            return this.getNFeaturesOfMostDenseBlock(this.getAverageFeatureSize());
        }

        public ChrIndex optimize(double d) {
            return ChrIndex.optimize(this, d, 0);
        }

        private static boolean badBinWidth(ChrIndex chrIndex) {
            if (chrIndex.binWidth > 1000000000 || chrIndex.binWidth < 0) {
                return true;
            }
            return MAX_BIN_WIDTH_FOR_OCCUPIED_CHR_INDEX != 0L && chrIndex.getNFeatures() > 1 && (long)chrIndex.binWidth > MAX_BIN_WIDTH_FOR_OCCUPIED_CHR_INDEX;
        }

        private static ChrIndex optimize(ChrIndex chrIndex, double d, int n) {
            double d2;
            ChrIndex chrIndex2 = chrIndex;
            while (!((d2 = chrIndex.optimizeScore()) > d) && chrIndex.getNBlocks() != 1 && !ChrIndex.badBinWidth(chrIndex)) {
                chrIndex2 = chrIndex;
                chrIndex = ChrIndex.mergeBlocks(chrIndex);
                if (++n <= 30) continue;
                throw new IllegalStateException("Too many iterations");
            }
            return chrIndex2;
        }

        private static ChrIndex mergeBlocks(ChrIndex chrIndex) {
            ChrIndex chrIndex2 = new ChrIndex(chrIndex.name, chrIndex.binWidth * 2);
            chrIndex2.longestFeature = chrIndex.longestFeature;
            chrIndex2.nFeatures = chrIndex.nFeatures;
            Iterator<Block> iterator = chrIndex.getBlocks().iterator();
            if (!iterator.hasNext()) {
                throw new IllegalStateException("Block iterator cannot be empty at the start for " + chrIndex.getName());
            }
            while (iterator.hasNext()) {
                Block block;
                Block block2 = iterator.next();
                Block block3 = block = iterator.hasNext() ? iterator.next() : null;
                if (block == null) {
                    chrIndex2.addBlock(block2);
                    continue;
                }
                chrIndex2.addBlock(new Block(block2.getStartPosition(), block2.getSize() + block.getSize()));
            }
            return chrIndex2;
        }

        private static String dupString(char c, int n) {
            char[] cArray = new char[n];
            Arrays.fill(cArray, c);
            return new String(cArray);
        }
    }
}

