/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class CommonInfo {
    public static final double NO_LOG10_PERROR = 1.0;
    private static Set<String> NO_FILTERS = Collections.emptySet();
    private static Map<String, Object> NO_ATTRIBUTES = Collections.unmodifiableMap(new HashMap());
    private double log10PError = 1.0;
    private String name = null;
    private Set<String> filters = null;
    private Map<String, Object> attributes = NO_ATTRIBUTES;

    public CommonInfo(String string, double d, Set<String> set, Map<String, Object> map) {
        this.name = string;
        this.setLog10PError(d);
        this.filters = set;
        if (map != null && !map.isEmpty()) {
            this.attributes = map;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Name cannot be null " + this);
        }
        this.name = string;
    }

    public Set<String> getFiltersMaybeNull() {
        return this.filters;
    }

    public Set<String> getFilters() {
        return this.filters == null ? NO_FILTERS : Collections.unmodifiableSet(this.filters);
    }

    public boolean filtersWereApplied() {
        return this.filters != null;
    }

    public boolean isFiltered() {
        return this.filters == null ? false : this.filters.size() > 0;
    }

    public boolean isNotFiltered() {
        return !this.isFiltered();
    }

    public void addFilter(String string) {
        if (this.filters == null) {
            this.filters = new HashSet<String>();
        }
        if (string == null) {
            throw new IllegalArgumentException("BUG: Attempting to add null filter " + this);
        }
        if (this.getFilters().contains(string)) {
            throw new IllegalArgumentException("BUG: Attempting to add duplicate filter " + string + " at " + this);
        }
        this.filters.add(string);
    }

    public void addFilters(Collection<String> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("BUG: Attempting to add null filters at" + this);
        }
        for (String string : collection) {
            this.addFilter(string);
        }
    }

    public boolean hasLog10PError() {
        return this.getLog10PError() != 1.0;
    }

    public double getLog10PError() {
        return this.log10PError;
    }

    public double getPhredScaledQual() {
        return this.getLog10PError() * -10.0;
    }

    public void setLog10PError(double d) {
        if (d > 0.0 && d != 1.0) {
            throw new IllegalArgumentException("BUG: log10PError cannot be > 0 : " + this.log10PError);
        }
        if (Double.isInfinite(this.log10PError)) {
            throw new IllegalArgumentException("BUG: log10PError should not be Infinity");
        }
        if (Double.isNaN(this.log10PError)) {
            throw new IllegalArgumentException("BUG: log10PError should not be NaN");
        }
        this.log10PError = d;
    }

    public void clearAttributes() {
        this.attributes = new HashMap<String, Object>();
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void setAttributes(Map<String, ?> map) {
        this.clearAttributes();
        this.putAttributes(map);
    }

    public void putAttribute(String string, Object object) {
        this.putAttribute(string, object, false);
    }

    public void putAttribute(String string, Object object, boolean bl) {
        if (!bl && this.hasAttribute(string)) {
            throw new IllegalStateException("Attempting to overwrite key->value binding: key = " + string + " this = " + this);
        }
        if (this.attributes == NO_ATTRIBUTES) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(string, object);
    }

    public void removeAttribute(String string) {
        if (this.attributes == NO_ATTRIBUTES) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.remove(string);
    }

    public void putAttributes(Map<String, ?> map) {
        if (map != null) {
            if (this.attributes.size() == 0) {
                if (this.attributes == NO_ATTRIBUTES) {
                    this.attributes = new HashMap<String, Object>();
                }
                this.attributes.putAll(map);
            } else {
                for (Map.Entry<String, ?> entry : map.entrySet()) {
                    this.putAttribute(entry.getKey(), entry.getValue(), false);
                }
            }
        }
    }

    public boolean hasAttribute(String string) {
        return this.attributes.containsKey(string);
    }

    public int getNumAttributes() {
        return this.attributes.size();
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Object getAttribute(String string, Object object) {
        if (this.hasAttribute(string)) {
            return this.attributes.get(string);
        }
        return object;
    }

    public String getAttributeAsString(String string, String string2) {
        Object object = this.getAttribute(string);
        if (object == null) {
            return string2;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return String.valueOf(object);
    }

    public int getAttributeAsInt(String string, int n) {
        Object object = this.getAttribute(string);
        if (object == null || object == ".") {
            return n;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return Integer.valueOf((String)object);
    }

    public double getAttributeAsDouble(String string, double d) {
        Object object = this.getAttribute(string);
        if (object == null) {
            return d;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        return Double.valueOf((String)object);
    }

    public boolean getAttributeAsBoolean(String string, boolean bl) {
        Object object = this.getAttribute(string);
        if (object == null) {
            return bl;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return Boolean.valueOf((String)object);
    }
}

